package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Location {
  def apply(graph: OdbGraph, id: Long) = new Location(graph, id)

  val Label = "LOCATION"
  val LabelId: Int = 25

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("SYMBOL", "METHOD_FULL_NAME", "METHOD_SHORT_NAME", "PACKAGE_NAME", "LINE_NUMBER", "CLASS_NAME", "CLASS_SHORT_NAME", "NODE_LABEL", "FILENAME", "node")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[LocationDb] {
    override val forLabel = Location.Label
    override val forLabelId = Location.LabelId

    override def createNode(ref: NodeRef[LocationDb]) =
      new LocationDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Location(graph, id)
  }
}

trait LocationBase extends CpgNode  with HasSymbol with HasMethodFullName with HasMethodShortName with HasPackageName with HasLineNumber with HasClassName with HasClassShortName with HasNodeLabel with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: Option[CpgNode]
}

class Location(graph: OdbGraph, id: Long) extends NodeRef[LocationDb](graph, id)
  with LocationBase
  with StoredNode
   {
    override def symbol: String = get().symbol
  override def methodFullName: String = get().methodFullName
  override def methodShortName: String = get().methodShortName
  override def packageName: String = get().packageName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def className: String = get().className
  override def classShortName: String = get().classShortName
  override def nodeLabel: String = get().nodeLabel
  override def filename: String = get().filename
    def node = get().node
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Location.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "classShortName" 
case 8 => "nodeLabel" 
case 9 => "filename" 
case 10 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => classShortName
case 8 => nodeLabel
case 9 => filename
case 10 => node
    }

  override def productPrefix = "Location"
  override def productArity = 11
}

class LocationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with LocationBase {

  override def layoutInformation: NodeLayoutInformation = Location.layoutInformation

private var _symbol: String = null
def symbol(): String = _symbol

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _methodShortName: String = null
def methodShortName(): String = _methodShortName

private var _packageName: String = null
def packageName(): String = _packageName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _className: String = null
def className(): String = _className

private var _classShortName: String = null
def classShortName(): String = _classShortName

private var _nodeLabel: String = null
def nodeLabel(): String = _nodeLabel

private var _filename: String = null
def filename(): String = _filename

private var _node: Option[CpgNode] = None
def node: Option[CpgNode] = this._node


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (symbol != null) { properties.put("SYMBOL", symbol) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (methodShortName != null) { properties.put("METHOD_SHORT_NAME", methodShortName) }
if (packageName != null) { properties.put("PACKAGE_NAME", packageName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (className != null) { properties.put("CLASS_NAME", className) }
if (classShortName != null) { properties.put("CLASS_SHORT_NAME", classShortName) }
if (nodeLabel != null) { properties.put("NODE_LABEL", nodeLabel) }
if (filename != null) { properties.put("FILENAME", filename) }
   if (this._node.nonEmpty) { properties.put("node", this._node.get) }
  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Location.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "classShortName" 
case 8 => "nodeLabel" 
case 9 => "filename" 
case 10 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => classShortName
case 8 => nodeLabel
case 9 => filename
case 10 => node
    }

  override def productPrefix = "Location"
  override def productArity = 11

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LocationDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "SYMBOL" => if(this._symbol == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._symbol.asInstanceOf[A])
  case "METHOD_FULL_NAME" => if(this._methodFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._methodFullName.asInstanceOf[A])
  case "METHOD_SHORT_NAME" => if(this._methodShortName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._methodShortName.asInstanceOf[A])
  case "PACKAGE_NAME" => if(this._packageName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._packageName.asInstanceOf[A])
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])
  case "CLASS_NAME" => if(this._className == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._className.asInstanceOf[A])
  case "CLASS_SHORT_NAME" => if(this._classShortName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._classShortName.asInstanceOf[A])
  case "NODE_LABEL" => if(this._nodeLabel == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._nodeLabel.asInstanceOf[A])
  case "FILENAME" => if(this._filename == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._filename.asInstanceOf[A])
  case "node" => if(this._node.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._node.get.asInstanceOf[A])
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "SYMBOL" => this._symbol
  case "METHOD_FULL_NAME" => this._methodFullName
  case "METHOD_SHORT_NAME" => this._methodShortName
  case "PACKAGE_NAME" => this._packageName
  case "LINE_NUMBER" => this._lineNumber.orNull
  case "CLASS_NAME" => this._className
  case "CLASS_SHORT_NAME" => this._classShortName
  case "NODE_LABEL" => this._nodeLabel
  case "FILENAME" => this._filename
  case "node" => this._node.orNull
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "SYMBOL" => this._symbol = value.asInstanceOf[String]
  case "METHOD_FULL_NAME" => this._methodFullName = value.asInstanceOf[String]
  case "METHOD_SHORT_NAME" => this._methodShortName = value.asInstanceOf[String]
  case "PACKAGE_NAME" => this._packageName = value.asInstanceOf[String]
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "CLASS_NAME" => this._className = value.asInstanceOf[String]
  case "CLASS_SHORT_NAME" => this._classShortName = value.asInstanceOf[String]
  case "NODE_LABEL" => this._nodeLabel = value.asInstanceOf[String]
  case "FILENAME" => this._filename = value.asInstanceOf[String]
  case "node" => this._node = value match {
    case null | None => None
    case someVal:CpgNode => Some(someVal)
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewLocation]
   this._symbol = other.symbol
   this._methodFullName = other.methodFullName
   this._methodShortName = other.methodShortName
   this._packageName = other.packageName
   this._lineNumber = other.lineNumber
   this._className = other.className
   this._classShortName = other.classShortName
   this._nodeLabel = other.nodeLabel
   this._filename = other.filename
  this._node = other.node match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[CpgNode])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[CpgNode])
    case _ => throw new MatchError("unreachable")
  }

}

}
