package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MetaData {
  def apply(graph: OdbGraph, id: Long) = new MetaData(graph, id)

  val Label = "META_DATA"
  val LabelId: Int = 39

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("LANGUAGE", "VERSION", "OVERLAYS", "POLICY_DIRECTORIES", "SPID")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MetaDataDb] {
    override val forLabel = MetaData.Label
    override val forLabelId = MetaData.LabelId

    override def createNode(ref: NodeRef[MetaDataDb]) =
      new MetaDataDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MetaData(graph, id)
  }
}

trait MetaDataBase extends CpgNode  with HasLanguage with HasVersion with HasOverlays with HasPolicyDirectories with HasSpid {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MetaData(graph: OdbGraph, id: Long) extends NodeRef[MetaDataDb](graph, id)
  with MetaDataBase
  with StoredNode
   {
    override def language: String = get().language
  override def version: String = get().version
  override def overlays: List[String] = get().overlays
  override def policyDirectories: List[String] = get().policyDirectories
  override def spid: Option[String] = get().spid
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MetaData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "language" 
case 2 => "version" 
case 3 => "overlays" 
case 4 => "policyDirectories" 
case 5 => "spid" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => language
case 2 => version
case 3 => overlays
case 4 => policyDirectories
case 5 => spid
    }

  override def productPrefix = "MetaData"
  override def productArity = 6
}

class MetaDataDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with MetaDataBase {

  override def layoutInformation: NodeLayoutInformation = MetaData.layoutInformation

private var _language: String = null
def language(): String = _language

private var _version: String = null
def version(): String = _version

private var _overlays: List[String] = Nil
def overlays(): List[String] = _overlays

private var _policyDirectories: List[String] = Nil
def policyDirectories(): List[String] = _policyDirectories

private var _spid: Option[String] = None
def spid(): Option[String] = _spid


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (language != null) { properties.put("LANGUAGE", language) }
if (version != null) { properties.put("VERSION", version) }
if (overlays.nonEmpty) { properties.put("OVERLAYS", overlays.asJava) }
if (policyDirectories.nonEmpty) { properties.put("POLICY_DIRECTORIES", policyDirectories.asJava) }
spid.map { value => properties.put("SPID", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MetaData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "language" 
case 2 => "version" 
case 3 => "overlays" 
case 4 => "policyDirectories" 
case 5 => "spid" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => language
case 2 => version
case 3 => overlays
case 4 => policyDirectories
case 5 => spid
    }

  override def productPrefix = "MetaData"
  override def productArity = 6

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MetaDataDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "LANGUAGE" => if(this._language == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._language.asInstanceOf[A])
  case "VERSION" => if(this._version == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._version.asInstanceOf[A])
  case "OVERLAYS" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "POLICY_DIRECTORIES" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "SPID" => if(this._spid.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._spid.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "LANGUAGE" => this._language
  case "VERSION" => this._version
  case "OVERLAYS" => this._overlays
  case "POLICY_DIRECTORIES" => this._policyDirectories
  case "SPID" => this._spid.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "LANGUAGE" => this._language = value.asInstanceOf[String]
  case "VERSION" => this._version = value.asInstanceOf[String]
  case "OVERLAYS" => this._overlays = value match {
    case null | None => Nil
    case someVal:String => this._overlays :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[String]]
  }
  case "POLICY_DIRECTORIES" => this._policyDirectories = value match {
    case null | None => Nil
    case someVal:String => this._policyDirectories :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[String]]
  }
  case "SPID" => this._spid = value match {
    case null | None => None
    case someVal:String => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMetaData]
   this._language = other.language
   this._version = other.version
   this._overlays = other.overlays
   this._policyDirectories = other.policyDirectories
   this._spid = other.spid


}

}
