package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Method {
  def apply(graph: OdbGraph, id: Long) = new Method(graph, id)

  val Label = "METHOD"
  val LabelId: Int = 1

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.SourceFile.layoutInformation, edges.TaggedBy.layoutInformation, edges.Contains.layoutInformation, edges.ReachingDef.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Vtable.layoutInformation, edges.Ref.layoutInformation, edges.Contains.layoutInformation, edges.Call.layoutInformation, edges.DynamicType.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("CODE", "NAME", "FULL_NAME", "IS_EXTERNAL", "SIGNATURE", "AST_PARENT_TYPE", "AST_PARENT_FULL_NAME", "LINE_NUMBER", "COLUMN_NUMBER", "LINE_NUMBER_END", "COLUMN_NUMBER_END", "ORDER", "FILENAME", "HAS_MAPPING", "DEPTH_FIRST_ORDER", "INTERNAL_FLAGS", "BINARY_SIGNATURE")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("VTABLE","REF","CONTAINS","CALL","DYNAMIC_TYPE","POST_DOMINATE","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("SOURCE_FILE","TAGGED_BY","CONTAINS","REACHING_DEF","CFG","AST","DOMINATE","CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodDb] {
    override val forLabel = Method.Label
    override val forLabelId = Method.LabelId

    override def createNode(ref: NodeRef[MethodDb]) =
      new MethodDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Method(graph, id)
  }
}

trait MethodBase extends CpgNode with DeclarationBase with CfgNodeBase with AstNodeBase with HasCode with HasName with HasFullName with HasIsExternal with HasSignature with HasAstParentType with HasAstParentFullName with HasLineNumber with HasColumnNumber with HasLineNumberEnd with HasColumnNumberEnd with HasOrder with HasFilename with HasHasMapping with HasDepthFirstOrder with HasInternalFlags with HasBinarySignature {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Method(graph: OdbGraph, id: Long) extends NodeRef[MethodDb](graph, id)
  with MethodBase
  with StoredNode
  with Declaration with CfgNode with AstNode {
    override def code: String = get().code
  override def name: String = get().name
  override def fullName: String = get().fullName
  override def isExternal: JBoolean = get().isExternal
  override def signature: String = get().signature
  override def astParentType: String = get().astParentType
  override def astParentFullName: String = get().astParentFullName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  override def lineNumberEnd: Option[Integer] = get().lineNumberEnd
  override def columnNumberEnd: Option[Integer] = get().columnNumberEnd
  override def order: Integer = get().order
  override def filename: String = get().filename
  override def hasMapping: Option[JBoolean] = get().hasMapping
  override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  override def binarySignature: Option[String] = get().binarySignature
  
  def _fileViaSourceFileOut: Iterator[File] = get()._fileViaSourceFileOut
override def _sourceFileOut(): JIterator[StoredNode] = get()._sourceFileOut
def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _controlStructureViaContainsOut: Iterator[ControlStructure] = get()._controlStructureViaContainsOut
def _returnViaContainsOut: Iterator[Return] = get()._returnViaContainsOut
def _fieldIdentifierViaContainsOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaContainsOut
def _jumpTargetViaContainsOut: Iterator[JumpTarget] = get()._jumpTargetViaContainsOut
def _identifierViaContainsOut: Iterator[Identifier] = get()._identifierViaContainsOut
override def _containsOut(): JIterator[StoredNode] = get()._containsOut
def _unknownViaContainsOut: Iterator[Unknown] = get()._unknownViaContainsOut
def _callViaContainsOut: Iterator[Call] = get()._callViaContainsOut
def _methodRefViaContainsOut: Iterator[MethodRef] = get()._methodRefViaContainsOut
def _blockViaContainsOut: Iterator[Block] = get()._blockViaContainsOut
def _literalViaContainsOut: Iterator[Literal] = get()._literalViaContainsOut
def _callViaReachingDefOut: Iterator[Call] = get()._callViaReachingDefOut
def _returnViaReachingDefOut: Iterator[Return] = get()._returnViaReachingDefOut
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut
def _returnViaCfgOut: Iterator[Return] = get()._returnViaCfgOut
def _callViaCfgOut: Iterator[Call] = get()._callViaCfgOut
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut
def _unknownViaCfgOut: Iterator[Unknown] = get()._unknownViaCfgOut
def _literalViaCfgOut: Iterator[Literal] = get()._literalViaCfgOut
def _fieldIdentifierViaCfgOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCfgOut
def _blockViaCfgOut: Iterator[Block] = get()._blockViaCfgOut
def _jumpTargetViaCfgOut: Iterator[JumpTarget] = get()._jumpTargetViaCfgOut
def _identifierViaCfgOut: Iterator[Identifier] = get()._identifierViaCfgOut
def _controlStructureViaCfgOut: Iterator[ControlStructure] = get()._controlStructureViaCfgOut
def _methodRefViaCfgOut: Iterator[MethodRef] = get()._methodRefViaCfgOut
def _methodReturnViaCfgOut: Option[MethodReturn] = get()._methodReturnViaCfgOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _typeDeclViaAstOut: Iterator[TypeDecl] = get()._typeDeclViaAstOut
def _methodParameterOutViaAstOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaAstOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
def _methodReturnViaAstOut: MethodReturn = get()._methodReturnViaAstOut
def _blockViaAstOut: Block = get()._blockViaAstOut
def _methodParameterInViaAstOut: Iterator[MethodParameterIn] = get()._methodParameterInViaAstOut
def _implicitCallViaAstOut: Iterator[ImplicitCall] = get()._implicitCallViaAstOut
def _methodViaAstOut: Iterator[Method] = get()._methodViaAstOut
def _typeParameterViaAstOut: Iterator[TypeParameter] = get()._typeParameterViaAstOut
def _modifierViaAstOut: Iterator[Modifier] = get()._modifierViaAstOut
def _unknownViaDominateOut: Iterator[Unknown] = get()._unknownViaDominateOut
def _identifierViaDominateOut: Iterator[Identifier] = get()._identifierViaDominateOut
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateOut
def _methodRefViaDominateOut: Iterator[MethodRef] = get()._methodRefViaDominateOut
def _methodReturnViaDominateOut: Iterator[MethodReturn] = get()._methodReturnViaDominateOut
def _literalViaDominateOut: Iterator[Literal] = get()._literalViaDominateOut
def _returnViaDominateOut: Iterator[Return] = get()._returnViaDominateOut
def _blockViaDominateOut: Iterator[Block] = get()._blockViaDominateOut
def _callViaDominateOut: Iterator[Call] = get()._callViaDominateOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeDeclViaVtableIn: Iterator[TypeDecl] = get()._typeDeclViaVtableIn
override def _vtableIn(): JIterator[StoredNode] = get()._vtableIn
def _methodRefViaRefIn: Iterator[MethodRef] = get()._methodRefViaRefIn
def _bindingViaRefIn: Iterator[Binding] = get()._bindingViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _fileViaContainsIn: Iterator[File] = get()._fileViaContainsIn
def _typeDeclViaContainsIn: Iterator[TypeDecl] = get()._typeDeclViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _callViaCallIn: Iterator[Call] = get()._callViaCallIn
override def _callIn(): JIterator[StoredNode] = get()._callIn
def _methodParameterInViaDynamicTypeIn: Iterator[MethodParameterIn] = get()._methodParameterInViaDynamicTypeIn
def _localViaDynamicTypeIn: Iterator[Local] = get()._localViaDynamicTypeIn
override def _dynamicTypeIn(): JIterator[StoredNode] = get()._dynamicTypeIn
def _unknownViaDynamicTypeIn: Iterator[Unknown] = get()._unknownViaDynamicTypeIn
def _fieldIdentifierViaDynamicTypeIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDynamicTypeIn
def _identifierViaDynamicTypeIn: Iterator[Identifier] = get()._identifierViaDynamicTypeIn
def _literalViaDynamicTypeIn: Iterator[Literal] = get()._literalViaDynamicTypeIn
def _callViaDynamicTypeIn: Iterator[Call] = get()._callViaDynamicTypeIn
def _methodReturnViaDynamicTypeIn: Iterator[MethodReturn] = get()._methodReturnViaDynamicTypeIn
def _controlStructureViaDynamicTypeIn: Iterator[ControlStructure] = get()._controlStructureViaDynamicTypeIn
def _blockViaDynamicTypeIn: Iterator[Block] = get()._blockViaDynamicTypeIn
def _methodRefViaDynamicTypeIn: Iterator[MethodRef] = get()._methodRefViaDynamicTypeIn
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateIn
def _identifierViaPostDominateIn: Iterator[Identifier] = get()._identifierViaPostDominateIn
def _blockViaPostDominateIn: Iterator[Block] = get()._blockViaPostDominateIn
def _returnViaPostDominateIn: Iterator[Return] = get()._returnViaPostDominateIn
def _callViaPostDominateIn: Iterator[Call] = get()._callViaPostDominateIn
def _literalViaPostDominateIn: Iterator[Literal] = get()._literalViaPostDominateIn
def _unknownViaPostDominateIn: Iterator[Unknown] = get()._unknownViaPostDominateIn
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = get()._methodReturnViaPostDominateIn
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = get()._controlStructureViaPostDominateIn
def _methodRefViaPostDominateIn: Iterator[MethodRef] = get()._methodRefViaPostDominateIn
def _methodViaAstIn: Option[Method] = get()._methodViaAstIn
def _namespaceBlockViaAstIn: Option[NamespaceBlock] = get()._namespaceBlockViaAstIn
def _typeDeclViaAstIn: Option[TypeDecl] = get()._typeDeclViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _sourceViaContainsNodeIn: Iterator[Source] = get()._sourceViaContainsNodeIn
def _programPointViaContainsNodeIn: Iterator[ProgramPoint] = get()._programPointViaContainsNodeIn
def _callSiteViaContainsNodeIn: Iterator[CallSite] = get()._callSiteViaContainsNodeIn
def _sinkViaContainsNodeIn: Iterator[Sink] = get()._sinkViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
def _callChainViaContainsNodeIn: Iterator[CallChain] = get()._callChainViaContainsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Method.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "isExternal" 
case 5 => "signature" 
case 6 => "astParentType" 
case 7 => "astParentFullName" 
case 8 => "lineNumber" 
case 9 => "columnNumber" 
case 10 => "lineNumberEnd" 
case 11 => "columnNumberEnd" 
case 12 => "order" 
case 13 => "filename" 
case 14 => "hasMapping" 
case 15 => "depthFirstOrder" 
case 16 => "internalFlags" 
case 17 => "binarySignature" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => fullName
case 4 => isExternal
case 5 => signature
case 6 => astParentType
case 7 => astParentFullName
case 8 => lineNumber
case 9 => columnNumber
case 10 => lineNumberEnd
case 11 => columnNumberEnd
case 12 => order
case 13 => filename
case 14 => hasMapping
case 15 => depthFirstOrder
case 16 => internalFlags
case 17 => binarySignature
    }

  override def productPrefix = "Method"
  override def productArity = 18
}

class MethodDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Declaration with CfgNode with AstNode with MethodBase {

  override def layoutInformation: NodeLayoutInformation = Method.layoutInformation

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _signature: String = null
def signature(): String = _signature

private var _astParentType: String = null
def astParentType(): String = _astParentType

private var _astParentFullName: String = null
def astParentFullName(): String = _astParentFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumberEnd: Option[Integer] = None
def lineNumberEnd(): Option[Integer] = _lineNumberEnd

private var _columnNumberEnd: Option[Integer] = None
def columnNumberEnd(): Option[Integer] = _columnNumberEnd

private var _order: Integer = null
def order(): Integer = _order

private var _filename: String = null
def filename(): String = _filename

private var _hasMapping: Option[JBoolean] = None
def hasMapping(): Option[JBoolean] = _hasMapping

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _binarySignature: Option[String] = None
def binarySignature(): Option[String] = _binarySignature


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (astParentType != null) { properties.put("AST_PARENT_TYPE", astParentType) }
if (astParentFullName != null) { properties.put("AST_PARENT_FULL_NAME", astParentFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumberEnd.map { value => properties.put("LINE_NUMBER_END", value) }
columnNumberEnd.map { value => properties.put("COLUMN_NUMBER_END", value) }
if (order != null) { properties.put("ORDER", order) }
if (filename != null) { properties.put("FILENAME", filename) }
hasMapping.map { value => properties.put("HAS_MAPPING", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
binarySignature.map { value => properties.put("BINARY_SIGNATURE", value) }

  properties
}

  def _fileViaSourceFileOut: Iterator[File] = _sourceFileOut.asScala.collect { case node: File => node }
override def _sourceFileOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _blockViaContainsOut: Iterator[Block] = _containsOut.asScala.collect { case node: Block => node }
def _fieldIdentifierViaContainsOut: Iterator[FieldIdentifier] = _containsOut.asScala.collect { case node: FieldIdentifier => node }
def _unknownViaContainsOut: Iterator[Unknown] = _containsOut.asScala.collect { case node: Unknown => node }
def _identifierViaContainsOut: Iterator[Identifier] = _containsOut.asScala.collect { case node: Identifier => node }
override def _containsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodRefViaContainsOut: Iterator[MethodRef] = _containsOut.asScala.collect { case node: MethodRef => node }
def _returnViaContainsOut: Iterator[Return] = _containsOut.asScala.collect { case node: Return => node }
def _controlStructureViaContainsOut: Iterator[ControlStructure] = _containsOut.asScala.collect { case node: ControlStructure => node }
def _jumpTargetViaContainsOut: Iterator[JumpTarget] = _containsOut.asScala.collect { case node: JumpTarget => node }
def _literalViaContainsOut: Iterator[Literal] = _containsOut.asScala.collect { case node: Literal => node }
def _callViaContainsOut: Iterator[Call] = _containsOut.asScala.collect { case node: Call => node }
def _callViaReachingDefOut: Iterator[Call] = _reachingDefOut.asScala.collect { case node: Call => node }
def _returnViaReachingDefOut: Iterator[Return] = _reachingDefOut.asScala.collect { case node: Return => node }
override def _reachingDefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _literalViaCfgOut: Iterator[Literal] = _cfgOut.asScala.collect { case node: Literal => node }
def _unknownViaCfgOut: Iterator[Unknown] = _cfgOut.asScala.collect { case node: Unknown => node }
def _identifierViaCfgOut: Iterator[Identifier] = _cfgOut.asScala.collect { case node: Identifier => node }
def _methodRefViaCfgOut: Iterator[MethodRef] = _cfgOut.asScala.collect { case node: MethodRef => node }
def _jumpTargetViaCfgOut: Iterator[JumpTarget] = _cfgOut.asScala.collect { case node: JumpTarget => node }
def _fieldIdentifierViaCfgOut: Iterator[FieldIdentifier] = _cfgOut.asScala.collect { case node: FieldIdentifier => node }
def _returnViaCfgOut: Iterator[Return] = _cfgOut.asScala.collect { case node: Return => node }
def _blockViaCfgOut: Iterator[Block] = _cfgOut.asScala.collect { case node: Block => node }
def _methodReturnViaCfgOut: Option[MethodReturn] = _cfgOut.asScala.collect { case node: MethodReturn => node }.nextOption
def _controlStructureViaCfgOut: Iterator[ControlStructure] = _cfgOut.asScala.collect { case node: ControlStructure => node }
override def _cfgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _callViaCfgOut: Iterator[Call] = _cfgOut.asScala.collect { case node: Call => node }
def _typeDeclViaAstOut: Iterator[TypeDecl] = _astOut.asScala.collect { case node: TypeDecl => node }
def _methodParameterInViaAstOut: Iterator[MethodParameterIn] = _astOut.asScala.collect { case node: MethodParameterIn => node }
def _methodViaAstOut: Iterator[Method] = _astOut.asScala.collect { case node: Method => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
def _methodParameterOutViaAstOut: Iterator[MethodParameterOut] = _astOut.asScala.collect { case node: MethodParameterOut => node }
def _typeParameterViaAstOut: Iterator[TypeParameter] = _astOut.asScala.collect { case node: TypeParameter => node }
def _methodReturnViaAstOut: MethodReturn = _astOut.asScala.collect { case node: MethodReturn => node }.next
def _modifierViaAstOut: Iterator[Modifier] = _astOut.asScala.collect { case node: Modifier => node }
def _implicitCallViaAstOut: Iterator[ImplicitCall] = _astOut.asScala.collect { case node: ImplicitCall => node }
def _blockViaAstOut: Block = _astOut.asScala.collect { case node: Block => node }.next
def _literalViaDominateOut: Iterator[Literal] = _dominateOut.asScala.collect { case node: Literal => node }
def _methodReturnViaDominateOut: Iterator[MethodReturn] = _dominateOut.asScala.collect { case node: MethodReturn => node }
def _unknownViaDominateOut: Iterator[Unknown] = _dominateOut.asScala.collect { case node: Unknown => node }
def _methodRefViaDominateOut: Iterator[MethodRef] = _dominateOut.asScala.collect { case node: MethodRef => node }
override def _dominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateOut: Iterator[Return] = _dominateOut.asScala.collect { case node: Return => node }
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = _dominateOut.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaDominateOut: Iterator[Identifier] = _dominateOut.asScala.collect { case node: Identifier => node }
def _callViaDominateOut: Iterator[Call] = _dominateOut.asScala.collect { case node: Call => node }
def _blockViaDominateOut: Iterator[Block] = _dominateOut.asScala.collect { case node: Block => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaVtableIn: Iterator[TypeDecl] = _vtableIn.asScala.collect { case node: TypeDecl => node }
override def _vtableIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _methodRefViaRefIn: Iterator[MethodRef] = _refIn.asScala.collect { case node: MethodRef => node }
def _bindingViaRefIn: Iterator[Binding] = _refIn.asScala.collect { case node: Binding => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _fileViaContainsIn: Iterator[File] = _containsIn.asScala.collect { case node: File => node }
def _typeDeclViaContainsIn: Iterator[TypeDecl] = _containsIn.asScala.collect { case node: TypeDecl => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _callViaCallIn: Iterator[Call] = _callIn.asScala.collect { case node: Call => node }
override def _callIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _blockViaDynamicTypeIn: Iterator[Block] = _dynamicTypeIn.asScala.collect { case node: Block => node }
def _identifierViaDynamicTypeIn: Iterator[Identifier] = _dynamicTypeIn.asScala.collect { case node: Identifier => node }
def _controlStructureViaDynamicTypeIn: Iterator[ControlStructure] = _dynamicTypeIn.asScala.collect { case node: ControlStructure => node }
def _methodRefViaDynamicTypeIn: Iterator[MethodRef] = _dynamicTypeIn.asScala.collect { case node: MethodRef => node }
def _literalViaDynamicTypeIn: Iterator[Literal] = _dynamicTypeIn.asScala.collect { case node: Literal => node }
def _fieldIdentifierViaDynamicTypeIn: Iterator[FieldIdentifier] = _dynamicTypeIn.asScala.collect { case node: FieldIdentifier => node }
override def _dynamicTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _methodReturnViaDynamicTypeIn: Iterator[MethodReturn] = _dynamicTypeIn.asScala.collect { case node: MethodReturn => node }
def _callViaDynamicTypeIn: Iterator[Call] = _dynamicTypeIn.asScala.collect { case node: Call => node }
def _methodParameterInViaDynamicTypeIn: Iterator[MethodParameterIn] = _dynamicTypeIn.asScala.collect { case node: MethodParameterIn => node }
def _localViaDynamicTypeIn: Iterator[Local] = _dynamicTypeIn.asScala.collect { case node: Local => node }
def _unknownViaDynamicTypeIn: Iterator[Unknown] = _dynamicTypeIn.asScala.collect { case node: Unknown => node }
def _blockViaPostDominateIn: Iterator[Block] = _postDominateIn.asScala.collect { case node: Block => node }
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = _postDominateIn.asScala.collect { case node: ControlStructure => node }
def _callViaPostDominateIn: Iterator[Call] = _postDominateIn.asScala.collect { case node: Call => node }
def _unknownViaPostDominateIn: Iterator[Unknown] = _postDominateIn.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = _postDominateIn.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaPostDominateIn: Iterator[Identifier] = _postDominateIn.asScala.collect { case node: Identifier => node }
def _literalViaPostDominateIn: Iterator[Literal] = _postDominateIn.asScala.collect { case node: Literal => node }
override def _postDominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _returnViaPostDominateIn: Iterator[Return] = _postDominateIn.asScala.collect { case node: Return => node }
def _methodRefViaPostDominateIn: Iterator[MethodRef] = _postDominateIn.asScala.collect { case node: MethodRef => node }
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = _postDominateIn.asScala.collect { case node: MethodReturn => node }
def _methodViaAstIn: Option[Method] = _astIn.asScala.collect { case node: Method => node }.nextOption
def _namespaceBlockViaAstIn: Option[NamespaceBlock] = _astIn.asScala.collect { case node: NamespaceBlock => node }.nextOption
def _typeDeclViaAstIn: Option[TypeDecl] = _astIn.asScala.collect { case node: TypeDecl => node }.nextOption
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
def _sourceViaContainsNodeIn: Iterator[Source] = _containsNodeIn.asScala.collect { case node: Source => node }
def _programPointViaContainsNodeIn: Iterator[ProgramPoint] = _containsNodeIn.asScala.collect { case node: ProgramPoint => node }
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _callChainViaContainsNodeIn: Iterator[CallChain] = _containsNodeIn.asScala.collect { case node: CallChain => node }
def _sinkViaContainsNodeIn: Iterator[Sink] = _containsNodeIn.asScala.collect { case node: Sink => node }
def _callSiteViaContainsNodeIn: Iterator[CallSite] = _containsNodeIn.asScala.collect { case node: CallSite => node }
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Method.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "isExternal" 
case 5 => "signature" 
case 6 => "astParentType" 
case 7 => "astParentFullName" 
case 8 => "lineNumber" 
case 9 => "columnNumber" 
case 10 => "lineNumberEnd" 
case 11 => "columnNumberEnd" 
case 12 => "order" 
case 13 => "filename" 
case 14 => "hasMapping" 
case 15 => "depthFirstOrder" 
case 16 => "internalFlags" 
case 17 => "binarySignature" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => fullName
case 4 => isExternal
case 5 => signature
case 6 => astParentType
case 7 => astParentFullName
case 8 => lineNumber
case 9 => columnNumber
case 10 => lineNumberEnd
case 11 => columnNumberEnd
case 12 => order
case 13 => filename
case 14 => hasMapping
case 15 => depthFirstOrder
case 16 => internalFlags
case 17 => binarySignature
    }

  override def productPrefix = "Method"
  override def productArity = 18

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "FULL_NAME" => if(this._fullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._fullName.asInstanceOf[A])
  case "IS_EXTERNAL" => if(this._isExternal == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._isExternal.asInstanceOf[A])
  case "SIGNATURE" => if(this._signature == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._signature.asInstanceOf[A])
  case "AST_PARENT_TYPE" => if(this._astParentType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._astParentType.asInstanceOf[A])
  case "AST_PARENT_FULL_NAME" => if(this._astParentFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._astParentFullName.asInstanceOf[A])
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])
  case "COLUMN_NUMBER" => if(this._columnNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumber.get.asInstanceOf[A])
  case "LINE_NUMBER_END" => if(this._lineNumberEnd.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumberEnd.get.asInstanceOf[A])
  case "COLUMN_NUMBER_END" => if(this._columnNumberEnd.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumberEnd.get.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])
  case "FILENAME" => if(this._filename == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._filename.asInstanceOf[A])
  case "HAS_MAPPING" => if(this._hasMapping.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._hasMapping.get.asInstanceOf[A])
  case "DEPTH_FIRST_ORDER" => if(this._depthFirstOrder.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._depthFirstOrder.get.asInstanceOf[A])
  case "INTERNAL_FLAGS" => if(this._internalFlags.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._internalFlags.get.asInstanceOf[A])
  case "BINARY_SIGNATURE" => if(this._binarySignature.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._binarySignature.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "CODE" => this._code
  case "NAME" => this._name
  case "FULL_NAME" => this._fullName
  case "IS_EXTERNAL" => this._isExternal
  case "SIGNATURE" => this._signature
  case "AST_PARENT_TYPE" => this._astParentType
  case "AST_PARENT_FULL_NAME" => this._astParentFullName
  case "LINE_NUMBER" => this._lineNumber.orNull
  case "COLUMN_NUMBER" => this._columnNumber.orNull
  case "LINE_NUMBER_END" => this._lineNumberEnd.orNull
  case "COLUMN_NUMBER_END" => this._columnNumberEnd.orNull
  case "ORDER" => this._order
  case "FILENAME" => this._filename
  case "HAS_MAPPING" => this._hasMapping.orNull
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
  case "INTERNAL_FLAGS" => this._internalFlags.orNull
  case "BINARY_SIGNATURE" => this._binarySignature.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "CODE" => this._code = value.asInstanceOf[String]
  case "NAME" => this._name = value.asInstanceOf[String]
  case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
  case "IS_EXTERNAL" => this._isExternal = value.asInstanceOf[JBoolean]
  case "SIGNATURE" => this._signature = value.asInstanceOf[String]
  case "AST_PARENT_TYPE" => this._astParentType = value.asInstanceOf[String]
  case "AST_PARENT_FULL_NAME" => this._astParentFullName = value.asInstanceOf[String]
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "COLUMN_NUMBER" => this._columnNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "LINE_NUMBER_END" => this._lineNumberEnd = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "COLUMN_NUMBER_END" => this._columnNumberEnd = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "ORDER" => this._order = value.asInstanceOf[Integer]
  case "FILENAME" => this._filename = value.asInstanceOf[String]
  case "HAS_MAPPING" => this._hasMapping = value match {
    case null | None => None
    case someVal:JBoolean => Some(someVal)
  }
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "INTERNAL_FLAGS" => this._internalFlags = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "BINARY_SIGNATURE" => this._binarySignature = value match {
    case null | None => None
    case someVal:String => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethod]
   this._code = other.code
   this._name = other.name
   this._fullName = other.fullName
   this._isExternal = other.isExternal
   this._signature = other.signature
   this._astParentType = other.astParentType
   this._astParentFullName = other.astParentFullName
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber
   this._lineNumberEnd = other.lineNumberEnd
   this._columnNumberEnd = other.columnNumberEnd
   this._order = other.order
   this._filename = other.filename
   this._hasMapping = other.hasMapping
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags
   this._binarySignature = other.binarySignature

  graph2().indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}
