package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodInst {
  def apply(graph: OdbGraph, id: Long) = new MethodInst(graph, id)

  val Label = "METHOD_INST"
  val LabelId: Int = 32

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("NAME", "SIGNATURE", "FULL_NAME", "METHOD_FULL_NAME", "ORDER")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodInstDb] {
    override val forLabel = MethodInst.Label
    override val forLabelId = MethodInst.LabelId

    override def createNode(ref: NodeRef[MethodInstDb]) =
      new MethodInstDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodInst(graph, id)
  }
}

trait MethodInstBase extends CpgNode with AstNodeBase with HasName with HasSignature with HasFullName with HasMethodFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodInst(graph: OdbGraph, id: Long) extends NodeRef[MethodInstDb](graph, id)
  with MethodInstBase
  with StoredNode
  with AstNode {
    override def name: String = get().name
  override def signature: String = get().signature
  override def fullName: String = get().fullName
  override def methodFullName: String = get().methodFullName
  override def order: Integer = get().order
  
  def _typeArgumentViaAstOut: Iterator[TypeArgument] = get()._typeArgumentViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodInst.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "fullName" 
case 4 => "methodFullName" 
case 5 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => signature
case 3 => fullName
case 4 => methodFullName
case 5 => order
    }

  override def productPrefix = "MethodInst"
  override def productArity = 6
}

class MethodInstDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with MethodInstBase {

  override def layoutInformation: NodeLayoutInformation = MethodInst.layoutInformation

private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _fullName: String = null
def fullName(): String = _fullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _typeArgumentViaAstOut: Iterator[TypeArgument] = _astOut.asScala.collect { case node: TypeArgument => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodInst.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "fullName" 
case 4 => "methodFullName" 
case 5 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => signature
case 3 => fullName
case 4 => methodFullName
case 5 => order
    }

  override def productPrefix = "MethodInst"
  override def productArity = 6

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodInstDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "SIGNATURE" => if(this._signature == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._signature.asInstanceOf[A])
  case "FULL_NAME" => if(this._fullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._fullName.asInstanceOf[A])
  case "METHOD_FULL_NAME" => if(this._methodFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._methodFullName.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "NAME" => this._name
  case "SIGNATURE" => this._signature
  case "FULL_NAME" => this._fullName
  case "METHOD_FULL_NAME" => this._methodFullName
  case "ORDER" => this._order

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "NAME" => this._name = value.asInstanceOf[String]
  case "SIGNATURE" => this._signature = value.asInstanceOf[String]
  case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
  case "METHOD_FULL_NAME" => this._methodFullName = value.asInstanceOf[String]
  case "ORDER" => this._order = value.asInstanceOf[Integer]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethodInst]
   this._name = other.name
   this._signature = other.signature
   this._fullName = other.fullName
   this._methodFullName = other.methodFullName
   this._order = other.order

  graph2().indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}
