package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodReturn {
  def apply(graph: OdbGraph, id: Long) = new MethodReturn(graph, id)

  val Label = "METHOD_RETURN"
  val LabelId: Int = 3

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.PostDominate.layoutInformation, edges.ContainsNode.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.Cdg.layoutInformation, edges.ReachingDef.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation, edges.Propagate.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("CODE", "EVALUATION_STRATEGY", "TYPE_FULL_NAME", "DYNAMIC_TYPE_HINT_FULL_NAME", "LINE_NUMBER", "COLUMN_NUMBER", "ORDER", "DEPTH_FIRST_ORDER", "INTERNAL_FLAGS")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CDG","REACHING_DEF","CFG","AST","DOMINATE","CONTAINS_NODE","PROPAGATE")
    val Out: Array[String] = Array("TAGGED_BY","DYNAMIC_TYPE","POST_DOMINATE","CONTAINS_NODE","EVAL_TYPE")
  }

  val factory = new NodeFactory[MethodReturnDb] {
    override val forLabel = MethodReturn.Label
    override val forLabelId = MethodReturn.LabelId

    override def createNode(ref: NodeRef[MethodReturnDb]) =
      new MethodReturnDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodReturn(graph, id)
  }
}

trait MethodReturnBase extends CpgNode with CfgNodeBase with TrackingPointBase with HasCode with HasEvaluationStrategy with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasOrder with HasDepthFirstOrder with HasInternalFlags {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodReturn(graph: OdbGraph, id: Long) extends NodeRef[MethodReturnDb](graph, id)
  with MethodReturnBase
  with StoredNode
  with CfgNode with TrackingPoint {
    override def code: String = get().code
  override def evaluationStrategy: String = get().evaluationStrategy
  override def typeFullName: String = get().typeFullName
  override def dynamicTypeHintFullName: List[String] = get().dynamicTypeHintFullName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  override def order: Integer = get().order
  override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  
  def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _methodViaDynamicTypeOut: Option[Method] = get()._methodViaDynamicTypeOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _identifierViaPostDominateOut: Iterator[Identifier] = get()._identifierViaPostDominateOut
def _literalViaPostDominateOut: Iterator[Literal] = get()._literalViaPostDominateOut
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateOut
def _callViaPostDominateOut: Iterator[Call] = get()._callViaPostDominateOut
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateOut
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = get()._controlStructureViaPostDominateOut
def _returnViaPostDominateOut: Iterator[Return] = get()._returnViaPostDominateOut
def _methodViaPostDominateOut: Iterator[Method] = get()._methodViaPostDominateOut
def _unknownViaPostDominateOut: Iterator[Unknown] = get()._unknownViaPostDominateOut
def _methodRefViaPostDominateOut: Iterator[MethodRef] = get()._methodRefViaPostDominateOut
def _blockViaPostDominateOut: Iterator[Block] = get()._blockViaPostDominateOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _methodRefViaCdgIn: Iterator[MethodRef] = get()._methodRefViaCdgIn
def _callViaCdgIn: Iterator[Call] = get()._callViaCdgIn
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = get()._jumpTargetViaCdgIn
def _unknownViaCdgIn: Iterator[Unknown] = get()._unknownViaCdgIn
def _controlStructureViaCdgIn: Iterator[ControlStructure] = get()._controlStructureViaCdgIn
def _literalViaCdgIn: Iterator[Literal] = get()._literalViaCdgIn
def _identifierViaCdgIn: Iterator[Identifier] = get()._identifierViaCdgIn
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgIn
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn
def _blockViaCdgIn: Iterator[Block] = get()._blockViaCdgIn
def _returnViaReachingDefIn: Iterator[Return] = get()._returnViaReachingDefIn
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn
def _methodRefViaCfgIn: Iterator[MethodRef] = get()._methodRefViaCfgIn
def _methodViaCfgIn: Option[Method] = get()._methodViaCfgIn
def _identifierViaCfgIn: Iterator[Identifier] = get()._identifierViaCfgIn
def _returnViaCfgIn: Option[Return] = get()._returnViaCfgIn
def _methodViaAstIn: Method = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _literalViaDominateIn: Iterator[Literal] = get()._literalViaDominateIn
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateIn
def _blockViaDominateIn: Iterator[Block] = get()._blockViaDominateIn
def _identifierViaDominateIn: Iterator[Identifier] = get()._identifierViaDominateIn
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn
def _controlStructureViaDominateIn: Iterator[ControlStructure] = get()._controlStructureViaDominateIn
def _methodRefViaDominateIn: Iterator[MethodRef] = get()._methodRefViaDominateIn
def _unknownViaDominateIn: Iterator[Unknown] = get()._unknownViaDominateIn
def _callViaDominateIn: Iterator[Call] = get()._callViaDominateIn
def _methodViaDominateIn: Iterator[Method] = get()._methodViaDominateIn
def _returnViaDominateIn: Iterator[Return] = get()._returnViaDominateIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _methodParameterInViaPropagateIn: Iterator[MethodParameterIn] = get()._methodParameterInViaPropagateIn
override def _propagateIn(): JIterator[StoredNode] = get()._propagateIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodReturn.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "evaluationStrategy" 
case 3 => "typeFullName" 
case 4 => "dynamicTypeHintFullName" 
case 5 => "lineNumber" 
case 6 => "columnNumber" 
case 7 => "order" 
case 8 => "depthFirstOrder" 
case 9 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => evaluationStrategy
case 3 => typeFullName
case 4 => dynamicTypeHintFullName
case 5 => lineNumber
case 6 => columnNumber
case 7 => order
case 8 => depthFirstOrder
case 9 => internalFlags
    }

  override def productPrefix = "MethodReturn"
  override def productArity = 10
}

class MethodReturnDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with CfgNode with TrackingPoint with MethodReturnBase {

  override def layoutInformation: NodeLayoutInformation = MethodReturn.layoutInformation

private var _code: String = null
def code(): String = _code

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }

  properties
}

  def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodViaDynamicTypeOut: Option[Method] = _dynamicTypeOut.asScala.collect { case node: Method => node }.nextOption
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = _postDominateOut.asScala.collect { case node: JumpTarget => node }
def _identifierViaPostDominateOut: Iterator[Identifier] = _postDominateOut.asScala.collect { case node: Identifier => node }
def _callViaPostDominateOut: Iterator[Call] = _postDominateOut.asScala.collect { case node: Call => node }
def _methodRefViaPostDominateOut: Iterator[MethodRef] = _postDominateOut.asScala.collect { case node: MethodRef => node }
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = _postDominateOut.asScala.collect { case node: ControlStructure => node }
def _returnViaPostDominateOut: Iterator[Return] = _postDominateOut.asScala.collect { case node: Return => node }
def _literalViaPostDominateOut: Iterator[Literal] = _postDominateOut.asScala.collect { case node: Literal => node }
override def _postDominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _unknownViaPostDominateOut: Iterator[Unknown] = _postDominateOut.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = _postDominateOut.asScala.collect { case node: FieldIdentifier => node }
def _methodViaPostDominateOut: Iterator[Method] = _postDominateOut.asScala.collect { case node: Method => node }
def _blockViaPostDominateOut: Iterator[Block] = _postDominateOut.asScala.collect { case node: Block => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCdgIn: Iterator[Identifier] = _cdgIn.asScala.collect { case node: Identifier => node }
def _literalViaCdgIn: Iterator[Literal] = _cdgIn.asScala.collect { case node: Literal => node }
def _callViaCdgIn: Iterator[Call] = _cdgIn.asScala.collect { case node: Call => node }
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = _cdgIn.asScala.collect { case node: JumpTarget => node }
def _controlStructureViaCdgIn: Iterator[ControlStructure] = _cdgIn.asScala.collect { case node: ControlStructure => node }
def _blockViaCdgIn: Iterator[Block] = _cdgIn.asScala.collect { case node: Block => node }
def _unknownViaCdgIn: Iterator[Unknown] = _cdgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCdgIn: Iterator[MethodRef] = _cdgIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = _cdgIn.asScala.collect { case node: FieldIdentifier => node }
override def _cdgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _returnViaReachingDefIn: Iterator[Return] = _reachingDefIn.asScala.collect { case node: Return => node }
override def _reachingDefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodViaCfgIn: Option[Method] = _cfgIn.asScala.collect { case node: Method => node }.nextOption
def _returnViaCfgIn: Option[Return] = _cfgIn.asScala.collect { case node: Return => node }.nextOption
def _methodRefViaCfgIn: Iterator[MethodRef] = _cfgIn.asScala.collect { case node: MethodRef => node }
override def _cfgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCfgIn: Iterator[Identifier] = _cfgIn.asScala.collect { case node: Identifier => node }
def _methodViaAstIn: Method = _astIn.asScala.collect { case node: Method => node }.next
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _unknownViaDominateIn: Iterator[Unknown] = _dominateIn.asScala.collect { case node: Unknown => node }
def _methodRefViaDominateIn: Iterator[MethodRef] = _dominateIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = _dominateIn.asScala.collect { case node: FieldIdentifier => node }
def _methodViaDominateIn: Iterator[Method] = _dominateIn.asScala.collect { case node: Method => node }
def _returnViaDominateIn: Iterator[Return] = _dominateIn.asScala.collect { case node: Return => node }
def _identifierViaDominateIn: Iterator[Identifier] = _dominateIn.asScala.collect { case node: Identifier => node }
def _blockViaDominateIn: Iterator[Block] = _dominateIn.asScala.collect { case node: Block => node }
def _callViaDominateIn: Iterator[Call] = _dominateIn.asScala.collect { case node: Call => node }
def _controlStructureViaDominateIn: Iterator[ControlStructure] = _dominateIn.asScala.collect { case node: ControlStructure => node }
def _literalViaDominateIn: Iterator[Literal] = _dominateIn.asScala.collect { case node: Literal => node }
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaPropagateIn: Iterator[MethodParameterIn] = _propagateIn.asScala.collect { case node: MethodParameterIn => node }
override def _propagateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodReturn.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "evaluationStrategy" 
case 3 => "typeFullName" 
case 4 => "dynamicTypeHintFullName" 
case 5 => "lineNumber" 
case 6 => "columnNumber" 
case 7 => "order" 
case 8 => "depthFirstOrder" 
case 9 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => evaluationStrategy
case 3 => typeFullName
case 4 => dynamicTypeHintFullName
case 5 => lineNumber
case 6 => columnNumber
case 7 => order
case 8 => depthFirstOrder
case 9 => internalFlags
    }

  override def productPrefix = "MethodReturn"
  override def productArity = 10

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodReturnDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "EVALUATION_STRATEGY" => if(this._evaluationStrategy == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._evaluationStrategy.asInstanceOf[A])
  case "TYPE_FULL_NAME" => if(this._typeFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._typeFullName.asInstanceOf[A])
  case "DYNAMIC_TYPE_HINT_FULL_NAME" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])
  case "COLUMN_NUMBER" => if(this._columnNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumber.get.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])
  case "DEPTH_FIRST_ORDER" => if(this._depthFirstOrder.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._depthFirstOrder.get.asInstanceOf[A])
  case "INTERNAL_FLAGS" => if(this._internalFlags.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._internalFlags.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "CODE" => this._code
  case "EVALUATION_STRATEGY" => this._evaluationStrategy
  case "TYPE_FULL_NAME" => this._typeFullName
  case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName
  case "LINE_NUMBER" => this._lineNumber.orNull
  case "COLUMN_NUMBER" => this._columnNumber.orNull
  case "ORDER" => this._order
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
  case "INTERNAL_FLAGS" => this._internalFlags.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "CODE" => this._code = value.asInstanceOf[String]
  case "EVALUATION_STRATEGY" => this._evaluationStrategy = value.asInstanceOf[String]
  case "TYPE_FULL_NAME" => this._typeFullName = value.asInstanceOf[String]
  case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName = value match {
    case null | None => Nil
    case someVal:String => this._dynamicTypeHintFullName :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[String]]
  }
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "COLUMN_NUMBER" => this._columnNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "ORDER" => this._order = value.asInstanceOf[Integer]
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "INTERNAL_FLAGS" => this._internalFlags = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethodReturn]
   this._code = other.code
   this._evaluationStrategy = other.evaluationStrategy
   this._typeFullName = other.typeFullName
   this._dynamicTypeHintFullName = other.dynamicTypeHintFullName
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber
   this._order = other.order
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags


}

}
