package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodSummary {
  def apply(graph: OdbGraph, id: Long) = new MethodSummary(graph, id)

  val Label = "METHOD_SUMMARY"
  val LabelId: Int = 199

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("IS_STATIC", "IS_EXTERNAL", "BINARY_SIGNATURE", "method", "parameters", "outParameters", "returnParameter", "paramTypes", "returnParameterType", "tags", "paramTags", "outParamTags", "returnParamTags", "annotationParameters", "modifiers", "routes")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodSummaryDb] {
    override val forLabel = MethodSummary.Label
    override val forLabelId = MethodSummary.LabelId

    override def createNode(ref: NodeRef[MethodSummaryDb]) =
      new MethodSummaryDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodSummary(graph, id)
  }
}

trait MethodSummaryBase extends CpgNode  with HasIsStatic with HasIsExternal with HasBinarySignature {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def method: MethodBase
def parameters: List[MethodParameterInBase]
def outParameters: List[MethodParameterOutBase]
def returnParameter: MethodReturnBase
def paramTypes: List[TypeBase]
def returnParameterType: TypeBase
def tags: List[TagBase]
def paramTags: List[TagsBase]
def outParamTags: List[TagsBase]
def returnParamTags: List[TagBase]
def annotationParameters: List[SpAnnotationParameterBase]
def modifiers: List[ModifierBase]
def routes: List[RouteBase]
}

class MethodSummary(graph: OdbGraph, id: Long) extends NodeRef[MethodSummaryDb](graph, id)
  with MethodSummaryBase
  with StoredNode
   {
    override def isStatic: JBoolean = get().isStatic
  override def isExternal: JBoolean = get().isExternal
  override def binarySignature: Option[String] = get().binarySignature
    def method = get().method
  def parameters = get().parameters
  def outParameters = get().outParameters
  def returnParameter = get().returnParameter
  def paramTypes = get().paramTypes
  def returnParameterType = get().returnParameterType
  def tags = get().tags
  def paramTags = get().paramTags
  def outParamTags = get().outParamTags
  def returnParamTags = get().returnParamTags
  def annotationParameters = get().annotationParameters
  def modifiers = get().modifiers
  def routes = get().routes
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodReturnViaContainsNodeOut: Iterator[MethodReturn] = get()._methodReturnViaContainsNodeOut
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = get()._methodParameterInViaContainsNodeOut
def _routeViaContainsNodeOut: Iterator[Route] = get()._routeViaContainsNodeOut
def _tagsViaContainsNodeOut: Iterator[Tags] = get()._tagsViaContainsNodeOut
def _spAnnotationParameterViaContainsNodeOut: Iterator[SpAnnotationParameter] = get()._spAnnotationParameterViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _typeViaContainsNodeOut: Iterator[Type] = get()._typeViaContainsNodeOut
def _modifierViaContainsNodeOut: Iterator[Modifier] = get()._modifierViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodParameterOutViaContainsNodeOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaContainsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodSummary.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "isStatic" 
case 2 => "isExternal" 
case 3 => "binarySignature" 
case 4 => "method" 
case 5 => "parameters" 
case 6 => "outParameters" 
case 7 => "returnParameter" 
case 8 => "paramTypes" 
case 9 => "returnParameterType" 
case 10 => "tags" 
case 11 => "paramTags" 
case 12 => "outParamTags" 
case 13 => "returnParamTags" 
case 14 => "annotationParameters" 
case 15 => "modifiers" 
case 16 => "routes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => isStatic
case 2 => isExternal
case 3 => binarySignature
case 4 => method
case 5 => parameters
case 6 => outParameters
case 7 => returnParameter
case 8 => paramTypes
case 9 => returnParameterType
case 10 => tags
case 11 => paramTags
case 12 => outParamTags
case 13 => returnParamTags
case 14 => annotationParameters
case 15 => modifiers
case 16 => routes
    }

  override def productPrefix = "MethodSummary"
  override def productArity = 17
}

class MethodSummaryDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with MethodSummaryBase {

  override def layoutInformation: NodeLayoutInformation = MethodSummary.layoutInformation

private var _isStatic: JBoolean = null
def isStatic(): JBoolean = _isStatic

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _binarySignature: Option[String] = None
def binarySignature(): Option[String] = _binarySignature

private var _method: Method = null
def method: Method = this._method


private var _parameters: List[MethodParameterIn] = Nil
def parameters: List[MethodParameterIn] = this._parameters


private var _outParameters: List[MethodParameterOut] = Nil
def outParameters: List[MethodParameterOut] = this._outParameters


private var _returnParameter: MethodReturn = null
def returnParameter: MethodReturn = this._returnParameter


private var _paramTypes: List[Type] = Nil
def paramTypes: List[Type] = this._paramTypes


private var _returnParameterType: Type = null
def returnParameterType: Type = this._returnParameterType


private var _tags: List[Tag] = Nil
def tags: List[Tag] = this._tags


private var _paramTags: List[Tags] = Nil
def paramTags: List[Tags] = this._paramTags


private var _outParamTags: List[Tags] = Nil
def outParamTags: List[Tags] = this._outParamTags


private var _returnParamTags: List[Tag] = Nil
def returnParamTags: List[Tag] = this._returnParamTags


private var _annotationParameters: List[SpAnnotationParameter] = Nil
def annotationParameters: List[SpAnnotationParameter] = this._annotationParameters


private var _modifiers: List[Modifier] = Nil
def modifiers: List[Modifier] = this._modifiers


private var _routes: List[Route] = Nil
def routes: List[Route] = this._routes


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (isStatic != null) { properties.put("IS_STATIC", isStatic) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
binarySignature.map { value => properties.put("BINARY_SIGNATURE", value) }
   if (this._method != null) { properties.put("method", this._method) }
  if (this._parameters.nonEmpty) { properties.put("parameters", this._parameters.asJava) }
  if (this._outParameters.nonEmpty) { properties.put("outParameters", this._outParameters.asJava) }
   if (this._returnParameter != null) { properties.put("returnParameter", this._returnParameter) }
  if (this._paramTypes.nonEmpty) { properties.put("paramTypes", this._paramTypes.asJava) }
   if (this._returnParameterType != null) { properties.put("returnParameterType", this._returnParameterType) }
  if (this._tags.nonEmpty) { properties.put("tags", this._tags.asJava) }
  if (this._paramTags.nonEmpty) { properties.put("paramTags", this._paramTags.asJava) }
  if (this._outParamTags.nonEmpty) { properties.put("outParamTags", this._outParamTags.asJava) }
  if (this._returnParamTags.nonEmpty) { properties.put("returnParamTags", this._returnParamTags.asJava) }
  if (this._annotationParameters.nonEmpty) { properties.put("annotationParameters", this._annotationParameters.asJava) }
  if (this._modifiers.nonEmpty) { properties.put("modifiers", this._modifiers.asJava) }
  if (this._routes.nonEmpty) { properties.put("routes", this._routes.asJava) }
  properties
}

  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _typeViaContainsNodeOut: Iterator[Type] = _containsNodeOut.asScala.collect { case node: Type => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _modifierViaContainsNodeOut: Iterator[Modifier] = _containsNodeOut.asScala.collect { case node: Modifier => node }
def _spAnnotationParameterViaContainsNodeOut: Iterator[SpAnnotationParameter] = _containsNodeOut.asScala.collect { case node: SpAnnotationParameter => node }
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = _containsNodeOut.asScala.collect { case node: MethodParameterIn => node }
def _methodParameterOutViaContainsNodeOut: Iterator[MethodParameterOut] = _containsNodeOut.asScala.collect { case node: MethodParameterOut => node }
def _routeViaContainsNodeOut: Iterator[Route] = _containsNodeOut.asScala.collect { case node: Route => node }
def _methodReturnViaContainsNodeOut: Iterator[MethodReturn] = _containsNodeOut.asScala.collect { case node: MethodReturn => node }
def _tagsViaContainsNodeOut: Iterator[Tags] = _containsNodeOut.asScala.collect { case node: Tags => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodSummary.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "isStatic" 
case 2 => "isExternal" 
case 3 => "binarySignature" 
case 4 => "method" 
case 5 => "parameters" 
case 6 => "outParameters" 
case 7 => "returnParameter" 
case 8 => "paramTypes" 
case 9 => "returnParameterType" 
case 10 => "tags" 
case 11 => "paramTags" 
case 12 => "outParamTags" 
case 13 => "returnParamTags" 
case 14 => "annotationParameters" 
case 15 => "modifiers" 
case 16 => "routes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => isStatic
case 2 => isExternal
case 3 => binarySignature
case 4 => method
case 5 => parameters
case 6 => outParameters
case 7 => returnParameter
case 8 => paramTypes
case 9 => returnParameterType
case 10 => tags
case 11 => paramTags
case 12 => outParamTags
case 13 => returnParamTags
case 14 => annotationParameters
case 15 => modifiers
case 16 => routes
    }

  override def productPrefix = "MethodSummary"
  override def productArity = 17

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodSummaryDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "IS_STATIC" => if(this._isStatic == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._isStatic.asInstanceOf[A])
  case "IS_EXTERNAL" => if(this._isExternal == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._isExternal.asInstanceOf[A])
  case "BINARY_SIGNATURE" => if(this._binarySignature.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._binarySignature.get.asInstanceOf[A])
  case "method" => if(this._method == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._method.asInstanceOf[A])
  case "parameters" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "outParameters" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "returnParameter" => if(this._returnParameter == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._returnParameter.asInstanceOf[A])
  case "paramTypes" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "returnParameterType" => if(this._returnParameterType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._returnParameterType.asInstanceOf[A])
  case "tags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "paramTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "outParamTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "returnParamTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "annotationParameters" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "modifiers" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "routes" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "IS_STATIC" => this._isStatic
  case "IS_EXTERNAL" => this._isExternal
  case "BINARY_SIGNATURE" => this._binarySignature.orNull
  case "method" => this._method
  case "parameters" => this._parameters
  case "outParameters" => this._outParameters
  case "returnParameter" => this._returnParameter
  case "paramTypes" => this._paramTypes
  case "returnParameterType" => this._returnParameterType
  case "tags" => this._tags
  case "paramTags" => this._paramTags
  case "outParamTags" => this._outParamTags
  case "returnParamTags" => this._returnParamTags
  case "annotationParameters" => this._annotationParameters
  case "modifiers" => this._modifiers
  case "routes" => this._routes
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "IS_STATIC" => this._isStatic = value.asInstanceOf[JBoolean]
  case "IS_EXTERNAL" => this._isExternal = value.asInstanceOf[JBoolean]
  case "BINARY_SIGNATURE" => this._binarySignature = value match {
    case null | None => None
    case someVal:String => Some(someVal)
  }
  case "method" => this._method =     value.asInstanceOf[Method]
  case "parameters" => this._parameters = value match {
    case null | None => Nil
    case someVal:MethodParameterIn => this._parameters :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[MethodParameterIn]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[MethodParameterIn]]
  }
  case "outParameters" => this._outParameters = value match {
    case null | None => Nil
    case someVal:MethodParameterOut => this._outParameters :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[MethodParameterOut]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[MethodParameterOut]]
  }
  case "returnParameter" => this._returnParameter =     value.asInstanceOf[MethodReturn]
  case "paramTypes" => this._paramTypes = value match {
    case null | None => Nil
    case someVal:Type => this._paramTypes :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Type]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Type]]
  }
  case "returnParameterType" => this._returnParameterType =     value.asInstanceOf[Type]
  case "tags" => this._tags = value match {
    case null | None => Nil
    case someVal:Tag => this._tags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case "paramTags" => this._paramTags = value match {
    case null | None => Nil
    case someVal:Tags => this._paramTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tags]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tags]]
  }
  case "outParamTags" => this._outParamTags = value match {
    case null | None => Nil
    case someVal:Tags => this._outParamTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tags]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tags]]
  }
  case "returnParamTags" => this._returnParamTags = value match {
    case null | None => Nil
    case someVal:Tag => this._returnParamTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case "annotationParameters" => this._annotationParameters = value match {
    case null | None => Nil
    case someVal:SpAnnotationParameter => this._annotationParameters :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[SpAnnotationParameter]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[SpAnnotationParameter]]
  }
  case "modifiers" => this._modifiers = value match {
    case null | None => Nil
    case someVal:Modifier => this._modifiers :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Modifier]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Modifier]]
  }
  case "routes" => this._routes = value match {
    case null | None => Nil
    case someVal:Route => this._routes :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Route]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Route]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethodSummary]
   this._isStatic = other.isStatic
   this._isExternal = other.isExternal
   this._binarySignature = other.binarySignature
  this._method = other.method match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode: StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }
  this._parameters = if(other.parameters == null) Nil else other.parameters.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[MethodParameterIn]
    case oldNode:StoredNode => oldNode.asInstanceOf[MethodParameterIn]
    case _ => throw new MatchError("unreachable")
  }}
  this._outParameters = if(other.outParameters == null) Nil else other.outParameters.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[MethodParameterOut]
    case oldNode:StoredNode => oldNode.asInstanceOf[MethodParameterOut]
    case _ => throw new MatchError("unreachable")
  }}
  this._returnParameter = other.returnParameter match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[MethodReturn]
    case oldNode: StoredNode => oldNode.asInstanceOf[MethodReturn]
    case _ => throw new MatchError("unreachable")
  }
  this._paramTypes = if(other.paramTypes == null) Nil else other.paramTypes.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Type]
    case oldNode:StoredNode => oldNode.asInstanceOf[Type]
    case _ => throw new MatchError("unreachable")
  }}
  this._returnParameterType = other.returnParameterType match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Type]
    case oldNode: StoredNode => oldNode.asInstanceOf[Type]
    case _ => throw new MatchError("unreachable")
  }
  this._tags = if(other.tags == null) Nil else other.tags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._paramTags = if(other.paramTags == null) Nil else other.paramTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tags]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tags]
    case _ => throw new MatchError("unreachable")
  }}
  this._outParamTags = if(other.outParamTags == null) Nil else other.outParamTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tags]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tags]
    case _ => throw new MatchError("unreachable")
  }}
  this._returnParamTags = if(other.returnParamTags == null) Nil else other.returnParamTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._annotationParameters = if(other.annotationParameters == null) Nil else other.annotationParameters.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[SpAnnotationParameter]
    case oldNode:StoredNode => oldNode.asInstanceOf[SpAnnotationParameter]
    case _ => throw new MatchError("unreachable")
  }}
  this._modifiers = if(other.modifiers == null) Nil else other.modifiers.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Modifier]
    case oldNode:StoredNode => oldNode.asInstanceOf[Modifier]
    case _ => throw new MatchError("unreachable")
  }}
  this._routes = if(other.routes == null) Nil else other.routes.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Route]
    case oldNode:StoredNode => oldNode.asInstanceOf[Route]
    case _ => throw new MatchError("unreachable")
  }}

}

}
