package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object ProgramPoint {
  def apply(graph: OdbGraph, id: Long) = new ProgramPoint(graph, id)

  val Label = "PROGRAM_POINT"
  val LabelId: Int = 205

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("elem", "method", "methodTags", "paramTags")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[ProgramPointDb] {
    override val forLabel = ProgramPoint.Label
    override val forLabelId = ProgramPoint.LabelId

    override def createNode(ref: NodeRef[ProgramPointDb]) =
      new ProgramPointDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = ProgramPoint(graph, id)
  }
}

trait ProgramPointBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def elem: TrackingPointBase
def method: Option[MethodBase]
def methodTags: List[TagBase]
def paramTags: List[TagBase]
}

class ProgramPoint(graph: OdbGraph, id: Long) extends NodeRef[ProgramPointDb](graph, id)
  with ProgramPointBase
  with StoredNode
   {
  
    def elem = get().elem
  def method = get().method
  def methodTags = get().methodTags
  def paramTags = get().paramTags
  def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ProgramPoint.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "elem" 
case 2 => "method" 
case 3 => "methodTags" 
case 4 => "paramTags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => elem
case 2 => method
case 3 => methodTags
case 4 => paramTags
    }

  override def productPrefix = "ProgramPoint"
  override def productArity = 5
}

class ProgramPointDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with ProgramPointBase {

  override def layoutInformation: NodeLayoutInformation = ProgramPoint.layoutInformation



private var _elem: TrackingPoint = null
def elem: TrackingPoint = this._elem


private var _method: Option[Method] = None
def method: Option[Method] = this._method


private var _methodTags: List[Tag] = Nil
def methodTags: List[Tag] = this._methodTags


private var _paramTags: List[Tag] = Nil
def paramTags: List[Tag] = this._paramTags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

   if (this._elem != null) { properties.put("elem", this._elem) }
   if (this._method.nonEmpty) { properties.put("method", this._method.get) }
  if (this._methodTags.nonEmpty) { properties.put("methodTags", this._methodTags.asJava) }
  if (this._paramTags.nonEmpty) { properties.put("paramTags", this._paramTags.asJava) }
  properties
}

  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ProgramPoint.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "elem" 
case 2 => "method" 
case 3 => "methodTags" 
case 4 => "paramTags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => elem
case 2 => method
case 3 => methodTags
case 4 => paramTags
    }

  override def productPrefix = "ProgramPoint"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ProgramPointDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "elem" => if(this._elem == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._elem.asInstanceOf[A])
  case "method" => if(this._method.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._method.get.asInstanceOf[A])
  case "methodTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "paramTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "elem" => this._elem
  case "method" => this._method.orNull
  case "methodTags" => this._methodTags
  case "paramTags" => this._paramTags
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "elem" => this._elem =     value.asInstanceOf[TrackingPoint]
  case "method" => this._method = value match {
    case null | None => None
    case someVal:Method => Some(someVal)
  }
  case "methodTags" => this._methodTags = value match {
    case null | None => Nil
    case someVal:Tag => this._methodTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case "paramTags" => this._paramTags = value match {
    case null | None => Nil
    case someVal:Tag => this._paramTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewProgramPoint]

  this._elem = other.elem match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode: StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }
  this._method = other.method match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[Method])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[Method])
    case _ => throw new MatchError("unreachable")
  }
  this._methodTags = if(other.methodTags == null) Nil else other.methodTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._paramTags = if(other.paramTags == null) Nil else other.paramTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}

}

}
