package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Read {
  def apply(graph: OdbGraph, id: Long) = new Read(graph, id)

  val Label = "READ"
  val LabelId: Int = 209

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("triggerCallChains", "descriptorFlows", "source")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[ReadDb] {
    override val forLabel = Read.Label
    override val forLabelId = Read.LabelId

    override def createNode(ref: NodeRef[ReadDb]) =
      new ReadDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Read(graph, id)
  }
}

trait ReadBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def source: SourceBase
}

class Read(graph: OdbGraph, id: Long) extends NodeRef[ReadDb](graph, id)
  with ReadBase
  with StoredNode
   {
  
    def triggerCallChains = get().triggerCallChains
  def descriptorFlows = get().descriptorFlows
  def source = get().source
  def _callChainViaContainsNodeOut: Iterator[CallChain] = get()._callChainViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Read.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "source" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => source
    }

  override def productPrefix = "Read"
  override def productArity = 4
}

class ReadDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with ReadBase {

  override def layoutInformation: NodeLayoutInformation = Read.layoutInformation



private var _triggerCallChains: List[CallChain] = Nil
def triggerCallChains: List[CallChain] = this._triggerCallChains


private var _descriptorFlows: List[Flow] = Nil
def descriptorFlows: List[Flow] = this._descriptorFlows


private var _source: Source = null
def source: Source = this._source


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._triggerCallChains.nonEmpty) { properties.put("triggerCallChains", this._triggerCallChains.asJava) }
  if (this._descriptorFlows.nonEmpty) { properties.put("descriptorFlows", this._descriptorFlows.asJava) }
   if (this._source != null) { properties.put("source", this._source) }
  properties
}

  def _callChainViaContainsNodeOut: Iterator[CallChain] = _containsNodeOut.asScala.collect { case node: CallChain => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Read.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "source" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => source
    }

  override def productPrefix = "Read"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ReadDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "triggerCallChains" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "descriptorFlows" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "source" => if(this._source == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._source.asInstanceOf[A])
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "triggerCallChains" => this._triggerCallChains
  case "descriptorFlows" => this._descriptorFlows
  case "source" => this._source
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "triggerCallChains" => this._triggerCallChains = value match {
    case null | None => Nil
    case someVal:CallChain => this._triggerCallChains :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CallChain]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[CallChain]]
  }
  case "descriptorFlows" => this._descriptorFlows = value match {
    case null | None => Nil
    case someVal:Flow => this._descriptorFlows :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Flow]]
  }
  case "source" => this._source =     value.asInstanceOf[Source]
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewRead]

  this._triggerCallChains = if(other.triggerCallChains == null) Nil else other.triggerCallChains.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CallChain]
    case oldNode:StoredNode => oldNode.asInstanceOf[CallChain]
    case _ => throw new MatchError("unreachable")
  }}
  this._descriptorFlows = if(other.descriptorFlows == null) Nil else other.descriptorFlows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}
  this._source = other.source match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Source]
    case oldNode: StoredNode => oldNode.asInstanceOf[Source]
    case _ => throw new MatchError("unreachable")
  }

}

}
