package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Return {
  def apply(graph: OdbGraph, id: Long) = new Return(graph, id)

  val Label = "RETURN"
  val LabelId: Int = 30

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Argument.layoutInformation, edges.ReachingDef.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Cdg.layoutInformation, edges.Argument.layoutInformation, edges.Contains.layoutInformation, edges.ReachingDef.layoutInformation, edges.Condition.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("LINE_NUMBER", "COLUMN_NUMBER", "ORDER", "ARGUMENT_INDEX", "CODE", "DEPTH_FIRST_ORDER", "INTERNAL_FLAGS")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CDG","ARGUMENT","CONTAINS","REACHING_DEF","CONDITION","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE")
    val Out: Array[String] = Array("ARGUMENT","REACHING_DEF","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ReturnDb] {
    override val forLabel = Return.Label
    override val forLabelId = Return.LabelId

    override def createNode(ref: NodeRef[ReturnDb]) =
      new ReturnDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Return(graph, id)
  }
}

trait ReturnBase extends CpgNode with ExpressionBase with HasLineNumber with HasColumnNumber with HasOrder with HasArgumentIndex with HasCode with HasDepthFirstOrder with HasInternalFlags {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Return(graph: OdbGraph, id: Long) extends NodeRef[ReturnDb](graph, id)
  with ReturnBase
  with StoredNode
  with Expression {
    override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  override def order: Integer = get().order
  override def argumentIndex: Integer = get().argumentIndex
  override def code: String = get().code
  override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  
  def _literalViaArgumentOut: Option[Literal] = get()._literalViaArgumentOut
def _unknownViaArgumentOut: Iterator[Unknown] = get()._unknownViaArgumentOut
def _identifierViaArgumentOut: Option[Identifier] = get()._identifierViaArgumentOut
def _jumpTargetViaArgumentOut: Iterator[JumpTarget] = get()._jumpTargetViaArgumentOut
def _callViaArgumentOut: Option[Call] = get()._callViaArgumentOut
override def _argumentOut(): JIterator[StoredNode] = get()._argumentOut
def _blockViaArgumentOut: Option[Block] = get()._blockViaArgumentOut
def _returnViaArgumentOut: Option[Return] = get()._returnViaArgumentOut
def _methodRefViaArgumentOut: Option[MethodRef] = get()._methodRefViaArgumentOut
def _controlStructureViaArgumentOut: Iterator[ControlStructure] = get()._controlStructureViaArgumentOut
def _methodReturnViaReachingDefOut: Iterator[MethodReturn] = get()._methodReturnViaReachingDefOut
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut
def _methodReturnViaCfgOut: MethodReturn = get()._methodReturnViaCfgOut
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut
def _identifierViaPostDominateOut: Iterator[Identifier] = get()._identifierViaPostDominateOut
def _literalViaPostDominateOut: Iterator[Literal] = get()._literalViaPostDominateOut
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateOut
def _callViaPostDominateOut: Iterator[Call] = get()._callViaPostDominateOut
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateOut
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = get()._controlStructureViaPostDominateOut
def _returnViaPostDominateOut: Iterator[Return] = get()._returnViaPostDominateOut
def _methodViaPostDominateOut: Iterator[Method] = get()._methodViaPostDominateOut
def _unknownViaPostDominateOut: Iterator[Unknown] = get()._unknownViaPostDominateOut
def _methodRefViaPostDominateOut: Iterator[MethodRef] = get()._methodRefViaPostDominateOut
def _blockViaPostDominateOut: Iterator[Block] = get()._blockViaPostDominateOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _identifierViaAstOut: Iterator[Identifier] = get()._identifierViaAstOut
def _methodRefViaAstOut: Iterator[MethodRef] = get()._methodRefViaAstOut
def _blockViaAstOut: Iterator[Block] = get()._blockViaAstOut
def _literalViaAstOut: Iterator[Literal] = get()._literalViaAstOut
def _controlStructureViaAstOut: Iterator[ControlStructure] = get()._controlStructureViaAstOut
def _jumpTargetViaAstOut: Iterator[JumpTarget] = get()._jumpTargetViaAstOut
def _unknownViaAstOut: Iterator[Unknown] = get()._unknownViaAstOut
def _returnViaAstOut: Iterator[Return] = get()._returnViaAstOut
def _callViaAstOut: Iterator[Call] = get()._callViaAstOut
def _unknownViaDominateOut: Iterator[Unknown] = get()._unknownViaDominateOut
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaDominateOut
def _identifierViaDominateOut: Iterator[Identifier] = get()._identifierViaDominateOut
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut
def _controlStructureViaDominateOut: Iterator[ControlStructure] = get()._controlStructureViaDominateOut
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateOut
def _methodRefViaDominateOut: Iterator[MethodRef] = get()._methodRefViaDominateOut
def _methodReturnViaDominateOut: Iterator[MethodReturn] = get()._methodReturnViaDominateOut
def _literalViaDominateOut: Iterator[Literal] = get()._literalViaDominateOut
def _returnViaDominateOut: Iterator[Return] = get()._returnViaDominateOut
def _blockViaDominateOut: Iterator[Block] = get()._blockViaDominateOut
def _callViaDominateOut: Iterator[Call] = get()._callViaDominateOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodRefViaCdgIn: Iterator[MethodRef] = get()._methodRefViaCdgIn
def _callViaCdgIn: Iterator[Call] = get()._callViaCdgIn
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = get()._jumpTargetViaCdgIn
def _unknownViaCdgIn: Iterator[Unknown] = get()._unknownViaCdgIn
def _controlStructureViaCdgIn: Iterator[ControlStructure] = get()._controlStructureViaCdgIn
def _literalViaCdgIn: Iterator[Literal] = get()._literalViaCdgIn
def _identifierViaCdgIn: Iterator[Identifier] = get()._identifierViaCdgIn
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgIn
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn
def _blockViaCdgIn: Iterator[Block] = get()._blockViaCdgIn
def _returnViaArgumentIn: Option[Return] = get()._returnViaArgumentIn
override def _argumentIn(): JIterator[StoredNode] = get()._argumentIn
def _methodViaContainsIn: Iterator[Method] = get()._methodViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _controlStructureViaReachingDefIn: Iterator[ControlStructure] = get()._controlStructureViaReachingDefIn
def _blockViaReachingDefIn: Iterator[Block] = get()._blockViaReachingDefIn
def _unknownViaReachingDefIn: Iterator[Unknown] = get()._unknownViaReachingDefIn
def _callViaReachingDefIn: Iterator[Call] = get()._callViaReachingDefIn
def _methodParameterInViaReachingDefIn: Iterator[MethodParameterIn] = get()._methodParameterInViaReachingDefIn
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn
def _methodViaReachingDefIn: Iterator[Method] = get()._methodViaReachingDefIn
def _controlStructureViaConditionIn: Iterator[ControlStructure] = get()._controlStructureViaConditionIn
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn
def _callViaCfgIn: Iterator[Call] = get()._callViaCfgIn
def _methodViaCfgIn: Iterator[Method] = get()._methodViaCfgIn
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn
def _methodRefViaCfgIn: Iterator[MethodRef] = get()._methodRefViaCfgIn
def _unknownViaCfgIn: Iterator[Unknown] = get()._unknownViaCfgIn
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = get()._jumpTargetViaCfgIn
def _blockViaCfgIn: Iterator[Block] = get()._blockViaCfgIn
def _controlStructureViaCfgIn: Iterator[ControlStructure] = get()._controlStructureViaCfgIn
def _identifierViaCfgIn: Iterator[Identifier] = get()._identifierViaCfgIn
def _fieldIdentifierViaCfgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCfgIn
def _literalViaCfgIn: Iterator[Literal] = get()._literalViaCfgIn
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateIn
def _identifierViaPostDominateIn: Iterator[Identifier] = get()._identifierViaPostDominateIn
def _blockViaPostDominateIn: Iterator[Block] = get()._blockViaPostDominateIn
def _returnViaPostDominateIn: Iterator[Return] = get()._returnViaPostDominateIn
def _callViaPostDominateIn: Iterator[Call] = get()._callViaPostDominateIn
def _literalViaPostDominateIn: Iterator[Literal] = get()._literalViaPostDominateIn
def _unknownViaPostDominateIn: Iterator[Unknown] = get()._unknownViaPostDominateIn
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = get()._methodReturnViaPostDominateIn
def _jumpTargetViaPostDominateIn: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateIn
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = get()._controlStructureViaPostDominateIn
def _methodRefViaPostDominateIn: Iterator[MethodRef] = get()._methodRefViaPostDominateIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _controlStructureViaAstIn: Option[ControlStructure] = get()._controlStructureViaAstIn
def _blockViaAstIn: Iterator[Block] = get()._blockViaAstIn
def _returnViaAstIn: Iterator[Return] = get()._returnViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _callViaAstIn: Iterator[Call] = get()._callViaAstIn
def _literalViaDominateIn: Iterator[Literal] = get()._literalViaDominateIn
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateIn
def _blockViaDominateIn: Iterator[Block] = get()._blockViaDominateIn
def _identifierViaDominateIn: Iterator[Identifier] = get()._identifierViaDominateIn
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn
def _controlStructureViaDominateIn: Iterator[ControlStructure] = get()._controlStructureViaDominateIn
def _methodRefViaDominateIn: Iterator[MethodRef] = get()._methodRefViaDominateIn
def _unknownViaDominateIn: Iterator[Unknown] = get()._unknownViaDominateIn
def _callViaDominateIn: Iterator[Call] = get()._callViaDominateIn
def _methodViaDominateIn: Iterator[Method] = get()._methodViaDominateIn
def _returnViaDominateIn: Iterator[Return] = get()._returnViaDominateIn
def _jumpTargetViaDominateIn: Iterator[JumpTarget] = get()._jumpTargetViaDominateIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Return.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "columnNumber" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "code" 
case 6 => "depthFirstOrder" 
case 7 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => lineNumber
case 2 => columnNumber
case 3 => order
case 4 => argumentIndex
case 5 => code
case 6 => depthFirstOrder
case 7 => internalFlags
    }

  override def productPrefix = "Return"
  override def productArity = 8
}

class ReturnDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Expression with ReturnBase {

  override def layoutInformation: NodeLayoutInformation = Return.layoutInformation

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _code: String = null
def code(): String = _code

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (code != null) { properties.put("CODE", code) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }

  properties
}

  def _jumpTargetViaArgumentOut: Iterator[JumpTarget] = _argumentOut.asScala.collect { case node: JumpTarget => node }
def _blockViaArgumentOut: Option[Block] = _argumentOut.asScala.collect { case node: Block => node }.nextOption
def _controlStructureViaArgumentOut: Iterator[ControlStructure] = _argumentOut.asScala.collect { case node: ControlStructure => node }
def _literalViaArgumentOut: Option[Literal] = _argumentOut.asScala.collect { case node: Literal => node }.nextOption
def _callViaArgumentOut: Option[Call] = _argumentOut.asScala.collect { case node: Call => node }.nextOption
def _identifierViaArgumentOut: Option[Identifier] = _argumentOut.asScala.collect { case node: Identifier => node }.nextOption
def _methodRefViaArgumentOut: Option[MethodRef] = _argumentOut.asScala.collect { case node: MethodRef => node }.nextOption
def _unknownViaArgumentOut: Iterator[Unknown] = _argumentOut.asScala.collect { case node: Unknown => node }
override def _argumentOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _returnViaArgumentOut: Option[Return] = _argumentOut.asScala.collect { case node: Return => node }.nextOption
def _methodReturnViaReachingDefOut: Iterator[MethodReturn] = _reachingDefOut.asScala.collect { case node: MethodReturn => node }
override def _reachingDefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodReturnViaCfgOut: MethodReturn = _cfgOut.asScala.collect { case node: MethodReturn => node }.next
override def _cfgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = _postDominateOut.asScala.collect { case node: JumpTarget => node }
def _identifierViaPostDominateOut: Iterator[Identifier] = _postDominateOut.asScala.collect { case node: Identifier => node }
def _callViaPostDominateOut: Iterator[Call] = _postDominateOut.asScala.collect { case node: Call => node }
def _methodRefViaPostDominateOut: Iterator[MethodRef] = _postDominateOut.asScala.collect { case node: MethodRef => node }
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = _postDominateOut.asScala.collect { case node: ControlStructure => node }
def _returnViaPostDominateOut: Iterator[Return] = _postDominateOut.asScala.collect { case node: Return => node }
override def _postDominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _literalViaPostDominateOut: Iterator[Literal] = _postDominateOut.asScala.collect { case node: Literal => node }
def _unknownViaPostDominateOut: Iterator[Unknown] = _postDominateOut.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = _postDominateOut.asScala.collect { case node: FieldIdentifier => node }
def _methodViaPostDominateOut: Iterator[Method] = _postDominateOut.asScala.collect { case node: Method => node }
def _blockViaPostDominateOut: Iterator[Block] = _postDominateOut.asScala.collect { case node: Block => node }
def _methodRefViaAstOut: Iterator[MethodRef] = _astOut.asScala.collect { case node: MethodRef => node }
def _literalViaAstOut: Iterator[Literal] = _astOut.asScala.collect { case node: Literal => node }
def _blockViaAstOut: Iterator[Block] = _astOut.asScala.collect { case node: Block => node }
def _identifierViaAstOut: Iterator[Identifier] = _astOut.asScala.collect { case node: Identifier => node }
def _controlStructureViaAstOut: Iterator[ControlStructure] = _astOut.asScala.collect { case node: ControlStructure => node }
def _callViaAstOut: Iterator[Call] = _astOut.asScala.collect { case node: Call => node }
def _returnViaAstOut: Iterator[Return] = _astOut.asScala.collect { case node: Return => node }
def _jumpTargetViaAstOut: Iterator[JumpTarget] = _astOut.asScala.collect { case node: JumpTarget => node }
def _unknownViaAstOut: Iterator[Unknown] = _astOut.asScala.collect { case node: Unknown => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _literalViaDominateOut: Iterator[Literal] = _dominateOut.asScala.collect { case node: Literal => node }
def _methodReturnViaDominateOut: Iterator[MethodReturn] = _dominateOut.asScala.collect { case node: MethodReturn => node }
def _unknownViaDominateOut: Iterator[Unknown] = _dominateOut.asScala.collect { case node: Unknown => node }
def _controlStructureViaDominateOut: Iterator[ControlStructure] = _dominateOut.asScala.collect { case node: ControlStructure => node }
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = _dominateOut.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateOut: Iterator[MethodRef] = _dominateOut.asScala.collect { case node: MethodRef => node }
override def _dominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateOut: Iterator[Return] = _dominateOut.asScala.collect { case node: Return => node }
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = _dominateOut.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaDominateOut: Iterator[Identifier] = _dominateOut.asScala.collect { case node: Identifier => node }
def _callViaDominateOut: Iterator[Call] = _dominateOut.asScala.collect { case node: Call => node }
def _blockViaDominateOut: Iterator[Block] = _dominateOut.asScala.collect { case node: Block => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCdgIn: Iterator[Identifier] = _cdgIn.asScala.collect { case node: Identifier => node }
def _literalViaCdgIn: Iterator[Literal] = _cdgIn.asScala.collect { case node: Literal => node }
def _callViaCdgIn: Iterator[Call] = _cdgIn.asScala.collect { case node: Call => node }
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = _cdgIn.asScala.collect { case node: JumpTarget => node }
def _controlStructureViaCdgIn: Iterator[ControlStructure] = _cdgIn.asScala.collect { case node: ControlStructure => node }
def _blockViaCdgIn: Iterator[Block] = _cdgIn.asScala.collect { case node: Block => node }
override def _cdgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _unknownViaCdgIn: Iterator[Unknown] = _cdgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCdgIn: Iterator[MethodRef] = _cdgIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = _cdgIn.asScala.collect { case node: FieldIdentifier => node }
def _returnViaArgumentIn: Option[Return] = _argumentIn.asScala.collect { case node: Return => node }.nextOption
override def _argumentIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsIn: Iterator[Method] = _containsIn.asScala.collect { case node: Method => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _unknownViaReachingDefIn: Iterator[Unknown] = _reachingDefIn.asScala.collect { case node: Unknown => node }
override def _reachingDefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _methodViaReachingDefIn: Iterator[Method] = _reachingDefIn.asScala.collect { case node: Method => node }
def _controlStructureViaReachingDefIn: Iterator[ControlStructure] = _reachingDefIn.asScala.collect { case node: ControlStructure => node }
def _methodParameterInViaReachingDefIn: Iterator[MethodParameterIn] = _reachingDefIn.asScala.collect { case node: MethodParameterIn => node }
def _callViaReachingDefIn: Iterator[Call] = _reachingDefIn.asScala.collect { case node: Call => node }
def _blockViaReachingDefIn: Iterator[Block] = _reachingDefIn.asScala.collect { case node: Block => node }
def _controlStructureViaConditionIn: Iterator[ControlStructure] = _conditionIn.asScala.collect { case node: ControlStructure => node }
override def _conditionIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _methodViaCfgIn: Iterator[Method] = _cfgIn.asScala.collect { case node: Method => node }
def _controlStructureViaCfgIn: Iterator[ControlStructure] = _cfgIn.asScala.collect { case node: ControlStructure => node }
def _fieldIdentifierViaCfgIn: Iterator[FieldIdentifier] = _cfgIn.asScala.collect { case node: FieldIdentifier => node }
def _callViaCfgIn: Iterator[Call] = _cfgIn.asScala.collect { case node: Call => node }
def _unknownViaCfgIn: Iterator[Unknown] = _cfgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCfgIn: Iterator[MethodRef] = _cfgIn.asScala.collect { case node: MethodRef => node }
def _literalViaCfgIn: Iterator[Literal] = _cfgIn.asScala.collect { case node: Literal => node }
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = _cfgIn.asScala.collect { case node: JumpTarget => node }
def _identifierViaCfgIn: Iterator[Identifier] = _cfgIn.asScala.collect { case node: Identifier => node }
def _blockViaCfgIn: Iterator[Block] = _cfgIn.asScala.collect { case node: Block => node }
def _blockViaPostDominateIn: Iterator[Block] = _postDominateIn.asScala.collect { case node: Block => node }
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = _postDominateIn.asScala.collect { case node: ControlStructure => node }
def _callViaPostDominateIn: Iterator[Call] = _postDominateIn.asScala.collect { case node: Call => node }
def _unknownViaPostDominateIn: Iterator[Unknown] = _postDominateIn.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = _postDominateIn.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaPostDominateIn: Iterator[Identifier] = _postDominateIn.asScala.collect { case node: Identifier => node }
def _literalViaPostDominateIn: Iterator[Literal] = _postDominateIn.asScala.collect { case node: Literal => node }
override def _postDominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _returnViaPostDominateIn: Iterator[Return] = _postDominateIn.asScala.collect { case node: Return => node }
def _methodRefViaPostDominateIn: Iterator[MethodRef] = _postDominateIn.asScala.collect { case node: MethodRef => node }
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = _postDominateIn.asScala.collect { case node: MethodReturn => node }
def _jumpTargetViaPostDominateIn: Iterator[JumpTarget] = _postDominateIn.asScala.collect { case node: JumpTarget => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
def _returnViaAstIn: Iterator[Return] = _astIn.asScala.collect { case node: Return => node }
def _blockViaAstIn: Iterator[Block] = _astIn.asScala.collect { case node: Block => node }
def _callViaAstIn: Iterator[Call] = _astIn.asScala.collect { case node: Call => node }
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaAstIn: Option[ControlStructure] = _astIn.asScala.collect { case node: ControlStructure => node }.nextOption
def _unknownViaDominateIn: Iterator[Unknown] = _dominateIn.asScala.collect { case node: Unknown => node }
def _jumpTargetViaDominateIn: Iterator[JumpTarget] = _dominateIn.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateIn: Iterator[MethodRef] = _dominateIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = _dominateIn.asScala.collect { case node: FieldIdentifier => node }
def _methodViaDominateIn: Iterator[Method] = _dominateIn.asScala.collect { case node: Method => node }
override def _dominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateIn: Iterator[Return] = _dominateIn.asScala.collect { case node: Return => node }
def _identifierViaDominateIn: Iterator[Identifier] = _dominateIn.asScala.collect { case node: Identifier => node }
def _blockViaDominateIn: Iterator[Block] = _dominateIn.asScala.collect { case node: Block => node }
def _callViaDominateIn: Iterator[Call] = _dominateIn.asScala.collect { case node: Call => node }
def _controlStructureViaDominateIn: Iterator[ControlStructure] = _dominateIn.asScala.collect { case node: ControlStructure => node }
def _literalViaDominateIn: Iterator[Literal] = _dominateIn.asScala.collect { case node: Literal => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Return.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "columnNumber" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "code" 
case 6 => "depthFirstOrder" 
case 7 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => lineNumber
case 2 => columnNumber
case 3 => order
case 4 => argumentIndex
case 5 => code
case 6 => depthFirstOrder
case 7 => internalFlags
    }

  override def productPrefix = "Return"
  override def productArity = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ReturnDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])
  case "COLUMN_NUMBER" => if(this._columnNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumber.get.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])
  case "ARGUMENT_INDEX" => if(this._argumentIndex == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._argumentIndex.asInstanceOf[A])
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "DEPTH_FIRST_ORDER" => if(this._depthFirstOrder.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._depthFirstOrder.get.asInstanceOf[A])
  case "INTERNAL_FLAGS" => if(this._internalFlags.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._internalFlags.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "LINE_NUMBER" => this._lineNumber.orNull
  case "COLUMN_NUMBER" => this._columnNumber.orNull
  case "ORDER" => this._order
  case "ARGUMENT_INDEX" => this._argumentIndex
  case "CODE" => this._code
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
  case "INTERNAL_FLAGS" => this._internalFlags.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "COLUMN_NUMBER" => this._columnNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "ORDER" => this._order = value.asInstanceOf[Integer]
  case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
  case "CODE" => this._code = value.asInstanceOf[String]
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "INTERNAL_FLAGS" => this._internalFlags = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewReturn]
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber
   this._order = other.order
   this._argumentIndex = other.argumentIndex
   this._code = other.code
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags


}

}
