package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SensitiveDataType {
  def apply(graph: OdbGraph, id: Long) = new SensitiveDataType(graph, id)

  val Label = "SENSITIVE_DATA_TYPE"
  val LabelId: Int = 52

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataOfType.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("FULL_NAME", "names", "members")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_OF_TYPE","CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveDataTypeDb] {
    override val forLabel = SensitiveDataType.Label
    override val forLabelId = SensitiveDataType.LabelId

    override def createNode(ref: NodeRef[SensitiveDataTypeDb]) =
      new SensitiveDataTypeDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveDataType(graph, id)
  }
}

trait SensitiveDataTypeBase extends CpgNode  with HasFullName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def names: List[MatchInfoBase]
def members: List[SensitiveMemberBase]
}

class SensitiveDataType(graph: OdbGraph, id: Long) extends NodeRef[SensitiveDataTypeDb](graph, id)
  with SensitiveDataTypeBase
  with StoredNode
   {
    override def fullName: String = get().fullName
    def names = get().names
  def members = get().members
  def _typeDeclViaIsSensitiveDataDescrOfOut: Iterator[TypeDecl] = get()._typeDeclViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = get()._matchInfoViaContainsNodeOut
def _sensitiveMemberViaContainsNodeOut: Iterator[SensitiveMember] = get()._sensitiveMemberViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveVariableViaIsSensitiveDataOfTypeIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataOfTypeIn
override def _isSensitiveDataOfTypeIn(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveDataType.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fullName" 
case 2 => "names" 
case 3 => "members" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => fullName
case 2 => names
case 3 => members
    }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 4
}

class SensitiveDataTypeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SensitiveDataTypeBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveDataType.layoutInformation

private var _fullName: String = null
def fullName(): String = _fullName

private var _names: List[MatchInfo] = Nil
def names: List[MatchInfo] = this._names


private var _members: List[SensitiveMember] = Nil
def members: List[SensitiveMember] = this._members


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (fullName != null) { properties.put("FULL_NAME", fullName) }
  if (this._names.nonEmpty) { properties.put("names", this._names.asJava) }
  if (this._members.nonEmpty) { properties.put("members", this._members.asJava) }
  properties
}

  def _typeDeclViaIsSensitiveDataDescrOfOut: Iterator[TypeDecl] = _isSensitiveDataDescrOfOut.asScala.collect { case node: TypeDecl => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = _containsNodeOut.asScala.collect { case node: MatchInfo => node }
def _sensitiveMemberViaContainsNodeOut: Iterator[SensitiveMember] = _containsNodeOut.asScala.collect { case node: SensitiveMember => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataOfTypeIn: Iterator[SensitiveVariable] = _isSensitiveDataOfTypeIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataOfTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveDataType.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fullName" 
case 2 => "names" 
case 3 => "members" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => fullName
case 2 => names
case 3 => members
    }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveDataTypeDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "FULL_NAME" => if(this._fullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._fullName.asInstanceOf[A])
  case "names" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "members" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "FULL_NAME" => this._fullName
  case "names" => this._names
  case "members" => this._members
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
  case "names" => this._names = value match {
    case null | None => Nil
    case someVal:MatchInfo => this._names :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[MatchInfo]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[MatchInfo]]
  }
  case "members" => this._members = value match {
    case null | None => Nil
    case someVal:SensitiveMember => this._members :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[SensitiveMember]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[SensitiveMember]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSensitiveDataType]
   this._fullName = other.fullName
  this._names = if(other.names == null) Nil else other.names.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[MatchInfo]
    case oldNode:StoredNode => oldNode.asInstanceOf[MatchInfo]
    case _ => throw new MatchError("unreachable")
  }}
  this._members = if(other.members == null) Nil else other.members.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[SensitiveMember]
    case oldNode:StoredNode => oldNode.asInstanceOf[SensitiveMember]
    case _ => throw new MatchError("unreachable")
  }}
  graph2().indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}
