package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Sink {
  def apply(graph: OdbGraph, id: Long) = new Sink(graph, id)

  val Label = "SINK"
  val LabelId: Int = 203

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("SINK_TYPE", "node", "nodeType", "method", "methodTags", "callingMethod", "callsite", "parameterIn", "parameterInTags")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SinkDb] {
    override val forLabel = Sink.Label
    override val forLabelId = Sink.LabelId

    override def createNode(ref: NodeRef[SinkDb]) =
      new SinkDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Sink(graph, id)
  }
}

trait SinkBase extends CpgNode  with HasSinkType {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: TrackingPointBase
def nodeType: TypeBase
def method: MethodBase
def methodTags: List[TagBase]
def callingMethod: Option[MethodBase]
def callsite: Option[CallBase]
def parameterIn: Option[MethodParameterInBase]
def parameterInTags: List[TagBase]
}

class Sink(graph: OdbGraph, id: Long) extends NodeRef[SinkDb](graph, id)
  with SinkBase
  with StoredNode
   {
    override def sinkType: String = get().sinkType
    def node = get().node
  def nodeType = get().nodeType
  def method = get().method
  def methodTags = get().methodTags
  def callingMethod = get().callingMethod
  def callsite = get().callsite
  def parameterIn = get().parameterIn
  def parameterInTags = get().parameterInTags
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = get()._methodParameterInViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _typeViaContainsNodeOut: Iterator[Type] = get()._typeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _writeViaContainsNodeIn: Iterator[Write] = get()._writeViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Sink.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sinkType" 
case 2 => "node" 
case 3 => "nodeType" 
case 4 => "method" 
case 5 => "methodTags" 
case 6 => "callingMethod" 
case 7 => "callsite" 
case 8 => "parameterIn" 
case 9 => "parameterInTags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sinkType
case 2 => node
case 3 => nodeType
case 4 => method
case 5 => methodTags
case 6 => callingMethod
case 7 => callsite
case 8 => parameterIn
case 9 => parameterInTags
    }

  override def productPrefix = "Sink"
  override def productArity = 10
}

class SinkDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SinkBase {

  override def layoutInformation: NodeLayoutInformation = Sink.layoutInformation

private var _sinkType: String = null
def sinkType(): String = _sinkType

private var _node: TrackingPoint = null
def node: TrackingPoint = this._node


private var _nodeType: Type = null
def nodeType: Type = this._nodeType


private var _method: Method = null
def method: Method = this._method


private var _methodTags: List[Tag] = Nil
def methodTags: List[Tag] = this._methodTags


private var _callingMethod: Option[Method] = None
def callingMethod: Option[Method] = this._callingMethod


private var _callsite: Option[Call] = None
def callsite: Option[Call] = this._callsite


private var _parameterIn: Option[MethodParameterIn] = None
def parameterIn: Option[MethodParameterIn] = this._parameterIn


private var _parameterInTags: List[Tag] = Nil
def parameterInTags: List[Tag] = this._parameterInTags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (sinkType != null) { properties.put("SINK_TYPE", sinkType) }
   if (this._node != null) { properties.put("node", this._node) }
   if (this._nodeType != null) { properties.put("nodeType", this._nodeType) }
   if (this._method != null) { properties.put("method", this._method) }
  if (this._methodTags.nonEmpty) { properties.put("methodTags", this._methodTags.asJava) }
   if (this._callingMethod.nonEmpty) { properties.put("callingMethod", this._callingMethod.get) }
   if (this._callsite.nonEmpty) { properties.put("callsite", this._callsite.get) }
   if (this._parameterIn.nonEmpty) { properties.put("parameterIn", this._parameterIn.get) }
  if (this._parameterInTags.nonEmpty) { properties.put("parameterInTags", this._parameterInTags.asJava) }
  properties
}

  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _typeViaContainsNodeOut: Iterator[Type] = _containsNodeOut.asScala.collect { case node: Type => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = _containsNodeOut.asScala.collect { case node: MethodParameterIn => node }
def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _writeViaContainsNodeIn: Iterator[Write] = _containsNodeIn.asScala.collect { case node: Write => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }

  override def label: String = {
    Sink.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sinkType" 
case 2 => "node" 
case 3 => "nodeType" 
case 4 => "method" 
case 5 => "methodTags" 
case 6 => "callingMethod" 
case 7 => "callsite" 
case 8 => "parameterIn" 
case 9 => "parameterInTags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sinkType
case 2 => node
case 3 => nodeType
case 4 => method
case 5 => methodTags
case 6 => callingMethod
case 7 => callsite
case 8 => parameterIn
case 9 => parameterInTags
    }

  override def productPrefix = "Sink"
  override def productArity = 10

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SinkDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "SINK_TYPE" => if(this._sinkType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._sinkType.asInstanceOf[A])
  case "node" => if(this._node == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._node.asInstanceOf[A])
  case "nodeType" => if(this._nodeType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._nodeType.asInstanceOf[A])
  case "method" => if(this._method == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._method.asInstanceOf[A])
  case "methodTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "callingMethod" => if(this._callingMethod.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._callingMethod.get.asInstanceOf[A])
  case "callsite" => if(this._callsite.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._callsite.get.asInstanceOf[A])
  case "parameterIn" => if(this._parameterIn.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._parameterIn.get.asInstanceOf[A])
  case "parameterInTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "SINK_TYPE" => this._sinkType
  case "node" => this._node
  case "nodeType" => this._nodeType
  case "method" => this._method
  case "methodTags" => this._methodTags
  case "callingMethod" => this._callingMethod.orNull
  case "callsite" => this._callsite.orNull
  case "parameterIn" => this._parameterIn.orNull
  case "parameterInTags" => this._parameterInTags
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "SINK_TYPE" => this._sinkType = value.asInstanceOf[String]
  case "node" => this._node =     value.asInstanceOf[TrackingPoint]
  case "nodeType" => this._nodeType =     value.asInstanceOf[Type]
  case "method" => this._method =     value.asInstanceOf[Method]
  case "methodTags" => this._methodTags = value match {
    case null | None => Nil
    case someVal:Tag => this._methodTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case "callingMethod" => this._callingMethod = value match {
    case null | None => None
    case someVal:Method => Some(someVal)
  }
  case "callsite" => this._callsite = value match {
    case null | None => None
    case someVal:Call => Some(someVal)
  }
  case "parameterIn" => this._parameterIn = value match {
    case null | None => None
    case someVal:MethodParameterIn => Some(someVal)
  }
  case "parameterInTags" => this._parameterInTags = value match {
    case null | None => Nil
    case someVal:Tag => this._parameterInTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSink]
   this._sinkType = other.sinkType
  this._node = other.node match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode: StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }
  this._nodeType = other.nodeType match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Type]
    case oldNode: StoredNode => oldNode.asInstanceOf[Type]
    case _ => throw new MatchError("unreachable")
  }
  this._method = other.method match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode: StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }
  this._methodTags = if(other.methodTags == null) Nil else other.methodTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._callingMethod = other.callingMethod match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[Method])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[Method])
    case _ => throw new MatchError("unreachable")
  }
  this._callsite = other.callsite match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[Call])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[Call])
    case _ => throw new MatchError("unreachable")
  }
  this._parameterIn = other.parameterIn match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[MethodParameterIn])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[MethodParameterIn])
    case _ => throw new MatchError("unreachable")
  }
  this._parameterInTags = if(other.parameterInTags == null) Nil else other.parameterInTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}

}

}
