package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Source {
  def apply(graph: OdbGraph, id: Long) = new Source(graph, id)

  val Label = "SOURCE"
  val LabelId: Int = 202

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("SOURCE_TYPE", "node", "method", "methodTags", "callingMethod", "callsite", "tags", "nodeType")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SourceDb] {
    override val forLabel = Source.Label
    override val forLabelId = Source.LabelId

    override def createNode(ref: NodeRef[SourceDb]) =
      new SourceDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Source(graph, id)
  }
}

trait SourceBase extends CpgNode  with HasSourceType {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: TrackingPointBase
def method: MethodBase
def methodTags: List[TagBase]
def callingMethod: Option[MethodBase]
def callsite: Option[CallBase]
def tags: List[TagBase]
def nodeType: TypeBase
}

class Source(graph: OdbGraph, id: Long) extends NodeRef[SourceDb](graph, id)
  with SourceBase
  with StoredNode
   {
    override def sourceType: String = get().sourceType
    def node = get().node
  def method = get().method
  def methodTags = get().methodTags
  def callingMethod = get().callingMethod
  def callsite = get().callsite
  def tags = get().tags
  def nodeType = get().nodeType
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _typeViaContainsNodeOut: Iterator[Type] = get()._typeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _readViaContainsNodeIn: Iterator[Read] = get()._readViaContainsNodeIn
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Source.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sourceType" 
case 2 => "node" 
case 3 => "method" 
case 4 => "methodTags" 
case 5 => "callingMethod" 
case 6 => "callsite" 
case 7 => "tags" 
case 8 => "nodeType" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sourceType
case 2 => node
case 3 => method
case 4 => methodTags
case 5 => callingMethod
case 6 => callsite
case 7 => tags
case 8 => nodeType
    }

  override def productPrefix = "Source"
  override def productArity = 9
}

class SourceDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SourceBase {

  override def layoutInformation: NodeLayoutInformation = Source.layoutInformation

private var _sourceType: String = null
def sourceType(): String = _sourceType

private var _node: TrackingPoint = null
def node: TrackingPoint = this._node


private var _method: Method = null
def method: Method = this._method


private var _methodTags: List[Tag] = Nil
def methodTags: List[Tag] = this._methodTags


private var _callingMethod: Option[Method] = None
def callingMethod: Option[Method] = this._callingMethod


private var _callsite: Option[Call] = None
def callsite: Option[Call] = this._callsite


private var _tags: List[Tag] = Nil
def tags: List[Tag] = this._tags


private var _nodeType: Type = null
def nodeType: Type = this._nodeType


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (sourceType != null) { properties.put("SOURCE_TYPE", sourceType) }
   if (this._node != null) { properties.put("node", this._node) }
   if (this._method != null) { properties.put("method", this._method) }
  if (this._methodTags.nonEmpty) { properties.put("methodTags", this._methodTags.asJava) }
   if (this._callingMethod.nonEmpty) { properties.put("callingMethod", this._callingMethod.get) }
   if (this._callsite.nonEmpty) { properties.put("callsite", this._callsite.get) }
  if (this._tags.nonEmpty) { properties.put("tags", this._tags.asJava) }
   if (this._nodeType != null) { properties.put("nodeType", this._nodeType) }
  properties
}

  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _typeViaContainsNodeOut: Iterator[Type] = _containsNodeOut.asScala.collect { case node: Type => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _readViaContainsNodeIn: Iterator[Read] = _containsNodeIn.asScala.collect { case node: Read => node }
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Source.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sourceType" 
case 2 => "node" 
case 3 => "method" 
case 4 => "methodTags" 
case 5 => "callingMethod" 
case 6 => "callsite" 
case 7 => "tags" 
case 8 => "nodeType" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sourceType
case 2 => node
case 3 => method
case 4 => methodTags
case 5 => callingMethod
case 6 => callsite
case 7 => tags
case 8 => nodeType
    }

  override def productPrefix = "Source"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SourceDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "SOURCE_TYPE" => if(this._sourceType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._sourceType.asInstanceOf[A])
  case "node" => if(this._node == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._node.asInstanceOf[A])
  case "method" => if(this._method == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._method.asInstanceOf[A])
  case "methodTags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "callingMethod" => if(this._callingMethod.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._callingMethod.get.asInstanceOf[A])
  case "callsite" => if(this._callsite.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._callsite.get.asInstanceOf[A])
  case "tags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "nodeType" => if(this._nodeType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._nodeType.asInstanceOf[A])
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "SOURCE_TYPE" => this._sourceType
  case "node" => this._node
  case "method" => this._method
  case "methodTags" => this._methodTags
  case "callingMethod" => this._callingMethod.orNull
  case "callsite" => this._callsite.orNull
  case "tags" => this._tags
  case "nodeType" => this._nodeType
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "SOURCE_TYPE" => this._sourceType = value.asInstanceOf[String]
  case "node" => this._node =     value.asInstanceOf[TrackingPoint]
  case "method" => this._method =     value.asInstanceOf[Method]
  case "methodTags" => this._methodTags = value match {
    case null | None => Nil
    case someVal:Tag => this._methodTags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case "callingMethod" => this._callingMethod = value match {
    case null | None => None
    case someVal:Method => Some(someVal)
  }
  case "callsite" => this._callsite = value match {
    case null | None => None
    case someVal:Call => Some(someVal)
  }
  case "tags" => this._tags = value match {
    case null | None => Nil
    case someVal:Tag => this._tags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case "nodeType" => this._nodeType =     value.asInstanceOf[Type]
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSource]
   this._sourceType = other.sourceType
  this._node = other.node match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode: StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }
  this._method = other.method match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode: StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }
  this._methodTags = if(other.methodTags == null) Nil else other.methodTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._callingMethod = other.callingMethod match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[Method])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[Method])
    case _ => throw new MatchError("unreachable")
  }
  this._callsite = other.callsite match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[Call])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[Call])
    case _ => throw new MatchError("unreachable")
  }
  this._tags = if(other.tags == null) Nil else other.tags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._nodeType = other.nodeType match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Type]
    case oldNode: StoredNode => oldNode.asInstanceOf[Type]
    case _ => throw new MatchError("unreachable")
  }

}

}
