package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SpAnnotationParameter {
  def apply(graph: OdbGraph, id: Long) = new SpAnnotationParameter(graph, id)

  val Label = "SP_ANNOTATION_PARAMETER"
  val LabelId: Int = 200

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("ANNOTATION_NAME", "ANNOTATION_FULL_NAME", "NAME", "VALUE")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SpAnnotationParameterDb] {
    override val forLabel = SpAnnotationParameter.Label
    override val forLabelId = SpAnnotationParameter.LabelId

    override def createNode(ref: NodeRef[SpAnnotationParameterDb]) =
      new SpAnnotationParameterDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SpAnnotationParameter(graph, id)
  }
}

trait SpAnnotationParameterBase extends CpgNode  with HasAnnotationName with HasAnnotationFullName with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class SpAnnotationParameter(graph: OdbGraph, id: Long) extends NodeRef[SpAnnotationParameterDb](graph, id)
  with SpAnnotationParameterBase
  with StoredNode
   {
    override def annotationName: String = get().annotationName
  override def annotationFullName: String = get().annotationFullName
  override def name: String = get().name
  override def value: String = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SpAnnotationParameter.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "annotationName" 
case 2 => "annotationFullName" 
case 3 => "name" 
case 4 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => annotationName
case 2 => annotationFullName
case 3 => name
case 4 => value
    }

  override def productPrefix = "SpAnnotationParameter"
  override def productArity = 5
}

class SpAnnotationParameterDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SpAnnotationParameterBase {

  override def layoutInformation: NodeLayoutInformation = SpAnnotationParameter.layoutInformation

private var _annotationName: String = null
def annotationName(): String = _annotationName

private var _annotationFullName: String = null
def annotationFullName(): String = _annotationFullName

private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (annotationName != null) { properties.put("ANNOTATION_NAME", annotationName) }
if (annotationFullName != null) { properties.put("ANNOTATION_FULL_NAME", annotationFullName) }
if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SpAnnotationParameter.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "annotationName" 
case 2 => "annotationFullName" 
case 3 => "name" 
case 4 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => annotationName
case 2 => annotationFullName
case 3 => name
case 4 => value
    }

  override def productPrefix = "SpAnnotationParameter"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SpAnnotationParameterDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "ANNOTATION_NAME" => if(this._annotationName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._annotationName.asInstanceOf[A])
  case "ANNOTATION_FULL_NAME" => if(this._annotationFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._annotationFullName.asInstanceOf[A])
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "VALUE" => if(this._value == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._value.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "ANNOTATION_NAME" => this._annotationName
  case "ANNOTATION_FULL_NAME" => this._annotationFullName
  case "NAME" => this._name
  case "VALUE" => this._value

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "ANNOTATION_NAME" => this._annotationName = value.asInstanceOf[String]
  case "ANNOTATION_FULL_NAME" => this._annotationFullName = value.asInstanceOf[String]
  case "NAME" => this._name = value.asInstanceOf[String]
  case "VALUE" => this._value = value.asInstanceOf[String]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSpAnnotationParameter]
   this._annotationName = other.annotationName
   this._annotationFullName = other.annotationFullName
   this._name = other.name
   this._value = other.value


}

}
