package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SpBlacklist {
  def apply(graph: OdbGraph, id: Long) = new SpBlacklist(graph, id)

  val Label = "SP_BLACKLIST"
  val LabelId: Int = 216

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("tags")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SpBlacklistDb] {
    override val forLabel = SpBlacklist.Label
    override val forLabelId = SpBlacklist.LabelId

    override def createNode(ref: NodeRef[SpBlacklistDb]) =
      new SpBlacklistDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SpBlacklist(graph, id)
  }
}

trait SpBlacklistBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def tags: List[TagBase]
}

class SpBlacklist(graph: OdbGraph, id: Long) extends NodeRef[SpBlacklistDb](graph, id)
  with SpBlacklistBase
  with StoredNode
   {
  
    def tags = get().tags
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SpBlacklist.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "tags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => tags
    }

  override def productPrefix = "SpBlacklist"
  override def productArity = 2
}

class SpBlacklistDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SpBlacklistBase {

  override def layoutInformation: NodeLayoutInformation = SpBlacklist.layoutInformation



private var _tags: List[Tag] = Nil
def tags: List[Tag] = this._tags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._tags.nonEmpty) { properties.put("tags", this._tags.asJava) }
  properties
}

  def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SpBlacklist.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "tags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => tags
    }

  override def productPrefix = "SpBlacklist"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SpBlacklistDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "tags" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "tags" => this._tags
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "tags" => this._tags = value match {
    case null | None => Nil
    case someVal:Tag => this._tags :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Tag]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSpBlacklist]

  this._tags = if(other.tags == null) Nil else other.tags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}

}

}
