package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Tag {
  def apply(graph: OdbGraph, id: Long) = new Tag(graph, id)

  val Label = "TAG"
  val LabelId: Int = 24

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.TaggedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("NAME", "VALUE")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("TAGGED_BY","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TagDb] {
    override val forLabel = Tag.Label
    override val forLabelId = Tag.LabelId

    override def createNode(ref: NodeRef[TagDb]) =
      new TagDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Tag(graph, id)
  }
}

trait TagBase extends CpgNode  with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Tag(graph: OdbGraph, id: Long) extends NodeRef[TagDb](graph, id)
  with TagBase
  with StoredNode
   {
    override def name: String = get().name
  override def value: String = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _localViaTaggedByIn: Iterator[Local] = get()._localViaTaggedByIn
def _literalViaTaggedByIn: Iterator[Literal] = get()._literalViaTaggedByIn
def _unknownViaTaggedByIn: Iterator[Unknown] = get()._unknownViaTaggedByIn
def _methodParameterInViaTaggedByIn: Iterator[MethodParameterIn] = get()._methodParameterInViaTaggedByIn
def _identifierViaTaggedByIn: Iterator[Identifier] = get()._identifierViaTaggedByIn
def _methodParameterOutViaTaggedByIn: Iterator[MethodParameterOut] = get()._methodParameterOutViaTaggedByIn
def _fileViaTaggedByIn: Iterator[File] = get()._fileViaTaggedByIn
override def _taggedByIn(): JIterator[StoredNode] = get()._taggedByIn
def _methodReturnViaTaggedByIn: Iterator[MethodReturn] = get()._methodReturnViaTaggedByIn
def _methodViaTaggedByIn: Iterator[Method] = get()._methodViaTaggedByIn
def _fieldIdentifierViaTaggedByIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaTaggedByIn
def _callViaTaggedByIn: Iterator[Call] = get()._callViaTaggedByIn
def _controlStructureViaTaggedByIn: Iterator[ControlStructure] = get()._controlStructureViaTaggedByIn
def _memberViaTaggedByIn: Iterator[Member] = get()._memberViaTaggedByIn
def _tagsViaContainsNodeIn: Iterator[Tags] = get()._tagsViaContainsNodeIn
def _tagNodePairViaContainsNodeIn: Iterator[TagNodePair] = get()._tagNodePairViaContainsNodeIn
def _sourceViaContainsNodeIn: Iterator[Source] = get()._sourceViaContainsNodeIn
def _programPointViaContainsNodeIn: Iterator[ProgramPoint] = get()._programPointViaContainsNodeIn
def _sinkViaContainsNodeIn: Iterator[Sink] = get()._sinkViaContainsNodeIn
def _spBlacklistViaContainsNodeIn: Iterator[SpBlacklist] = get()._spBlacklistViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Tag.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => value
    }

  override def productPrefix = "Tag"
  override def productArity = 3
}

class TagDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with TagBase {

  override def layoutInformation: NodeLayoutInformation = Tag.layoutInformation

private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _taggedByIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaTaggedByIn: Iterator[Method] = _taggedByIn.asScala.collect { case node: Method => node }
def _fileViaTaggedByIn: Iterator[File] = _taggedByIn.asScala.collect { case node: File => node }
def _methodParameterInViaTaggedByIn: Iterator[MethodParameterIn] = _taggedByIn.asScala.collect { case node: MethodParameterIn => node }
def _identifierViaTaggedByIn: Iterator[Identifier] = _taggedByIn.asScala.collect { case node: Identifier => node }
def _fieldIdentifierViaTaggedByIn: Iterator[FieldIdentifier] = _taggedByIn.asScala.collect { case node: FieldIdentifier => node }
def _literalViaTaggedByIn: Iterator[Literal] = _taggedByIn.asScala.collect { case node: Literal => node }
def _methodParameterOutViaTaggedByIn: Iterator[MethodParameterOut] = _taggedByIn.asScala.collect { case node: MethodParameterOut => node }
def _memberViaTaggedByIn: Iterator[Member] = _taggedByIn.asScala.collect { case node: Member => node }
def _callViaTaggedByIn: Iterator[Call] = _taggedByIn.asScala.collect { case node: Call => node }
def _methodReturnViaTaggedByIn: Iterator[MethodReturn] = _taggedByIn.asScala.collect { case node: MethodReturn => node }
def _unknownViaTaggedByIn: Iterator[Unknown] = _taggedByIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaTaggedByIn: Iterator[ControlStructure] = _taggedByIn.asScala.collect { case node: ControlStructure => node }
def _localViaTaggedByIn: Iterator[Local] = _taggedByIn.asScala.collect { case node: Local => node }
def _tagsViaContainsNodeIn: Iterator[Tags] = _containsNodeIn.asScala.collect { case node: Tags => node }
def _sourceViaContainsNodeIn: Iterator[Source] = _containsNodeIn.asScala.collect { case node: Source => node }
def _programPointViaContainsNodeIn: Iterator[ProgramPoint] = _containsNodeIn.asScala.collect { case node: ProgramPoint => node }
def _spBlacklistViaContainsNodeIn: Iterator[SpBlacklist] = _containsNodeIn.asScala.collect { case node: SpBlacklist => node }
def _tagNodePairViaContainsNodeIn: Iterator[TagNodePair] = _containsNodeIn.asScala.collect { case node: TagNodePair => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _sinkViaContainsNodeIn: Iterator[Sink] = _containsNodeIn.asScala.collect { case node: Sink => node }
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }

  override def label: String = {
    Tag.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => value
    }

  override def productPrefix = "Tag"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TagDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "VALUE" => if(this._value == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._value.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "NAME" => this._name
  case "VALUE" => this._value

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "NAME" => this._name = value.asInstanceOf[String]
  case "VALUE" => this._value = value.asInstanceOf[String]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTag]
   this._name = other.name
   this._value = other.value


}

}
