package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object TagNodePair {
  def apply(graph: OdbGraph, id: Long) = new TagNodePair(graph, id)

  val Label = "TAG_NODE_PAIR"
  val LabelId: Int = 208

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("tag", "node")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TagNodePairDb] {
    override val forLabel = TagNodePair.Label
    override val forLabelId = TagNodePair.LabelId

    override def createNode(ref: NodeRef[TagNodePairDb]) =
      new TagNodePairDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = TagNodePair(graph, id)
  }
}

trait TagNodePairBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def tag: TagBase
def node: CpgNode
}

class TagNodePair(graph: OdbGraph, id: Long) extends NodeRef[TagNodePairDb](graph, id)
  with TagNodePairBase
  with StoredNode
   {
  
    def tag = get().tag
  def node = get().node
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TagNodePair.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "tag" 
case 2 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => tag
case 2 => node
    }

  override def productPrefix = "TagNodePair"
  override def productArity = 3
}

class TagNodePairDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with TagNodePairBase {

  override def layoutInformation: NodeLayoutInformation = TagNodePair.layoutInformation



private var _tag: Tag = null
def tag: Tag = this._tag


private var _node: CpgNode = null
def node: CpgNode = this._node


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

   if (this._tag != null) { properties.put("tag", this._tag) }
   if (this._node != null) { properties.put("node", this._node) }
  properties
}

  def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    TagNodePair.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "tag" 
case 2 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => tag
case 2 => node
    }

  override def productPrefix = "TagNodePair"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TagNodePairDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "tag" => if(this._tag == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._tag.asInstanceOf[A])
  case "node" => if(this._node == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._node.asInstanceOf[A])
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "tag" => this._tag
  case "node" => this._node
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "tag" => this._tag =     value.asInstanceOf[Tag]
  case "node" => this._node =     value.asInstanceOf[CpgNode]
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTagNodePair]

  this._tag = other.tag match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode: StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }
  this._node = other.node match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[CpgNode]
    case oldNode: StoredNode => oldNode.asInstanceOf[CpgNode]
    case _ => throw new MatchError("unreachable")
  }

}

}
