package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Transform {
  def apply(graph: OdbGraph, id: Long) = new Transform(graph, id)

  val Label = "TRANSFORM"
  val LabelId: Int = 211

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("triggerCallChains", "descriptorFlows", "call", "sink")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TransformDb] {
    override val forLabel = Transform.Label
    override val forLabelId = Transform.LabelId

    override def createNode(ref: NodeRef[TransformDb]) =
      new TransformDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Transform(graph, id)
  }
}

trait TransformBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def call: CallBase
def sink: SinkBase
}

class Transform(graph: OdbGraph, id: Long) extends NodeRef[TransformDb](graph, id)
  with TransformBase
  with StoredNode
   {
  
    def triggerCallChains = get().triggerCallChains
  def descriptorFlows = get().descriptorFlows
  def call = get().call
  def sink = get().sink
  def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _callChainViaContainsNodeOut: Iterator[CallChain] = get()._callChainViaContainsNodeOut
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Transform.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "call" 
case 4 => "sink" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => call
case 4 => sink
    }

  override def productPrefix = "Transform"
  override def productArity = 5
}

class TransformDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with TransformBase {

  override def layoutInformation: NodeLayoutInformation = Transform.layoutInformation



private var _triggerCallChains: List[CallChain] = Nil
def triggerCallChains: List[CallChain] = this._triggerCallChains


private var _descriptorFlows: List[Flow] = Nil
def descriptorFlows: List[Flow] = this._descriptorFlows


private var _call: Call = null
def call: Call = this._call


private var _sink: Sink = null
def sink: Sink = this._sink


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._triggerCallChains.nonEmpty) { properties.put("triggerCallChains", this._triggerCallChains.asJava) }
  if (this._descriptorFlows.nonEmpty) { properties.put("descriptorFlows", this._descriptorFlows.asJava) }
   if (this._call != null) { properties.put("call", this._call) }
   if (this._sink != null) { properties.put("sink", this._sink) }
  properties
}

  def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _callChainViaContainsNodeOut: Iterator[CallChain] = _containsNodeOut.asScala.collect { case node: CallChain => node }
def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Transform.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "call" 
case 4 => "sink" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => call
case 4 => sink
    }

  override def productPrefix = "Transform"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TransformDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "triggerCallChains" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "descriptorFlows" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "call" => if(this._call == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._call.asInstanceOf[A])
  case "sink" => if(this._sink == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._sink.asInstanceOf[A])
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "triggerCallChains" => this._triggerCallChains
  case "descriptorFlows" => this._descriptorFlows
  case "call" => this._call
  case "sink" => this._sink
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "triggerCallChains" => this._triggerCallChains = value match {
    case null | None => Nil
    case someVal:CallChain => this._triggerCallChains :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CallChain]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[CallChain]]
  }
  case "descriptorFlows" => this._descriptorFlows = value match {
    case null | None => Nil
    case someVal:Flow => this._descriptorFlows :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Flow]]
  }
  case "call" => this._call =     value.asInstanceOf[Call]
  case "sink" => this._sink =     value.asInstanceOf[Sink]
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTransform]

  this._triggerCallChains = if(other.triggerCallChains == null) Nil else other.triggerCallChains.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CallChain]
    case oldNode:StoredNode => oldNode.asInstanceOf[CallChain]
    case _ => throw new MatchError("unreachable")
  }}
  this._descriptorFlows = if(other.descriptorFlows == null) Nil else other.descriptorFlows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}
  this._call = other.call match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Call]
    case oldNode: StoredNode => oldNode.asInstanceOf[Call]
    case _ => throw new MatchError("unreachable")
  }
  this._sink = other.sink match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Sink]
    case oldNode: StoredNode => oldNode.asInstanceOf[Sink]
    case _ => throw new MatchError("unreachable")
  }

}

}
