package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Transformation {
  def apply(graph: OdbGraph, id: Long) = new Transformation(graph, id)

  val Label = "TRANSFORMATION"
  val LabelId: Int = 213

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("node")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TransformationDb] {
    override val forLabel = Transformation.Label
    override val forLabelId = Transformation.LabelId

    override def createNode(ref: NodeRef[TransformationDb]) =
      new TransformationDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Transformation(graph, id)
  }
}

trait TransformationBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: TrackingPointBase
}

class Transformation(graph: OdbGraph, id: Long) extends NodeRef[TransformationDb](graph, id)
  with TransformationBase
  with StoredNode
   {
  
    def node = get().node
  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Transformation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => node
    }

  override def productPrefix = "Transformation"
  override def productArity = 2
}

class TransformationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with TransformationBase {

  override def layoutInformation: NodeLayoutInformation = Transformation.layoutInformation



private var _node: TrackingPoint = null
def node: TrackingPoint = this._node


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

   if (this._node != null) { properties.put("node", this._node) }
  properties
}

  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Transformation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => node
    }

  override def productPrefix = "Transformation"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TransformationDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "node" => if(this._node == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._node.asInstanceOf[A])
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "node" => this._node
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "node" => this._node =     value.asInstanceOf[TrackingPoint]
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTransformation]

  this._node = other.node match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode: StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }

}

}
