package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object TypeArgument {
  def apply(graph: OdbGraph, id: Long) = new TypeArgument(graph, id)

  val Label = "TYPE_ARGUMENT"
  val LabelId: Int = 48

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.BindsTo.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("ORDER")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("BINDS_TO","REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[TypeArgumentDb] {
    override val forLabel = TypeArgument.Label
    override val forLabelId = TypeArgument.LabelId

    override def createNode(ref: NodeRef[TypeArgumentDb]) =
      new TypeArgumentDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = TypeArgument(graph, id)
  }
}

trait TypeArgumentBase extends CpgNode with AstNodeBase with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class TypeArgument(graph: OdbGraph, id: Long) extends NodeRef[TypeArgumentDb](graph, id)
  with TypeArgumentBase
  with StoredNode
  with AstNode {
    override def order: Integer = get().order
  
  def _typeParameterViaBindsToOut: Iterator[TypeParameter] = get()._typeParameterViaBindsToOut
override def _bindsToOut(): JIterator[StoredNode] = get()._bindsToOut
def _typeViaRefOut: Iterator[Type] = get()._typeViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodInstViaAstIn: Iterator[MethodInst] = get()._methodInstViaAstIn
def _typeViaAstIn: Iterator[Type] = get()._typeViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeArgument.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => order
    }

  override def productPrefix = "TypeArgument"
  override def productArity = 2
}

class TypeArgumentDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with TypeArgumentBase {

  override def layoutInformation: NodeLayoutInformation = TypeArgument.layoutInformation

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _typeParameterViaBindsToOut: Iterator[TypeParameter] = _bindsToOut.asScala.collect { case node: TypeParameter => node }
override def _bindsToOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _typeViaRefOut: Iterator[Type] = _refOut.asScala.collect { case node: Type => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodInstViaAstIn: Iterator[MethodInst] = _astIn.asScala.collect { case node: MethodInst => node }
def _typeViaAstIn: Iterator[Type] = _astIn.asScala.collect { case node: Type => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    TypeArgument.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => order
    }

  override def productPrefix = "TypeArgument"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeArgumentDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "ORDER" => this._order

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "ORDER" => this._order = value.asInstanceOf[Integer]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTypeArgument]
   this._order = other.order


}

}
