package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object VariableInfo {
  def apply(graph: OdbGraph, id: Long) = new VariableInfo(graph, id)

  val Label = "VARIABLE_INFO"
  val LabelId: Int = 206

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("VAR_TYPE", "EVALUATION_TYPE", "PARAMETER_INDEX")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[VariableInfoDb] {
    override val forLabel = VariableInfo.Label
    override val forLabelId = VariableInfo.LabelId

    override def createNode(ref: NodeRef[VariableInfoDb]) =
      new VariableInfoDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = VariableInfo(graph, id)
  }
}

trait VariableInfoBase extends CpgNode  with HasVarType with HasEvaluationType with HasParameterIndex {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class VariableInfo(graph: OdbGraph, id: Long) extends NodeRef[VariableInfoDb](graph, id)
  with VariableInfoBase
  with StoredNode
   {
    override def varType: String = get().varType
  override def evaluationType: String = get().evaluationType
  override def parameterIndex: Option[Integer] = get().parameterIndex
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    VariableInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
    }

  override def productPrefix = "VariableInfo"
  override def productArity = 4
}

class VariableInfoDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with VariableInfoBase {

  override def layoutInformation: NodeLayoutInformation = VariableInfo.layoutInformation

private var _varType: String = null
def varType(): String = _varType

private var _evaluationType: String = null
def evaluationType(): String = _evaluationType

private var _parameterIndex: Option[Integer] = None
def parameterIndex(): Option[Integer] = _parameterIndex


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (varType != null) { properties.put("VAR_TYPE", varType) }
if (evaluationType != null) { properties.put("EVALUATION_TYPE", evaluationType) }
parameterIndex.map { value => properties.put("PARAMETER_INDEX", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    VariableInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
    }

  override def productPrefix = "VariableInfo"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[VariableInfoDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "VAR_TYPE" => if(this._varType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._varType.asInstanceOf[A])
  case "EVALUATION_TYPE" => if(this._evaluationType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._evaluationType.asInstanceOf[A])
  case "PARAMETER_INDEX" => if(this._parameterIndex.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._parameterIndex.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "VAR_TYPE" => this._varType
  case "EVALUATION_TYPE" => this._evaluationType
  case "PARAMETER_INDEX" => this._parameterIndex.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "VAR_TYPE" => this._varType = value.asInstanceOf[String]
  case "EVALUATION_TYPE" => this._evaluationType = value.asInstanceOf[String]
  case "PARAMETER_INDEX" => this._parameterIndex = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewVariableInfo]
   this._varType = other.varType
   this._evaluationType = other.evaluationType
   this._parameterIndex = other.parameterIndex


}

}
