package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Binding {
  def apply(graph: Graph, id: Long) = new Binding(graph, id)

  val Label = "BINDING"
  val LabelId: Int = 146

  object PropertyNames {
    val Name = "NAME" 
    val Signature = "SIGNATURE" 
    val IsMethodNeverOverridden = "IS_METHOD_NEVER_OVERRIDDEN" 
    val all: Set[String] = Set(Name, Signature, IsMethodNeverOverridden)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val Signature = new PropertyKey[String]("SIGNATURE") 
    val IsMethodNeverOverridden = new PropertyKey[Boolean]("IS_METHOD_NEVER_OVERRIDDEN") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Binds.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("BINDS","CONTAINS_NODE")
    val Out: Array[String] = Array("REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[BindingDb] {
    override val forLabel = Binding.Label
    override val forLabelId = Binding.LabelId

    override def createNode(ref: NodeRef[BindingDb]) =
      new BindingDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Binding(graph, id)
  }
}

trait BindingBase extends CpgNode  with HasName with HasSignature with HasIsMethodNeverOverridden {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Binding(graph: Graph, id: Long) extends NodeRef[BindingDb](graph, id)
  with BindingBase
  with StoredNode
   {
    override def name: String = get().name
  override def signature: String = get().signature
  override def isMethodNeverOverridden: Option[JBoolean] = get().isMethodNeverOverridden
  
  def _methodViaRefOut: Method = get()._methodViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeDeclViaBindsIn: TypeDecl = get()._typeDeclViaBindsIn
override def _bindsIn(): JIterator[StoredNode] = get()._bindsIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Binding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "isMethodNeverOverridden" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => signature
case 3 => isMethodNeverOverridden
    }

  override def productPrefix = "Binding"
  override def productArity = 4
}

class BindingDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with BindingBase {

  override def layoutInformation: NodeLayoutInformation = Binding.layoutInformation

private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _isMethodNeverOverridden: Option[JBoolean] = None
def isMethodNeverOverridden(): Option[JBoolean] = _isMethodNeverOverridden


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
isMethodNeverOverridden.map { value => properties.put("IS_METHOD_NEVER_OVERRIDDEN", value) }

  properties
}

  def _methodViaRefOut: Method = _refOut.asScala.collect { case node: Method => node }.next
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaBindsIn: TypeDecl = _bindsIn.asScala.collect { case node: TypeDecl => node }.next
override def _bindsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Binding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "isMethodNeverOverridden" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => signature
case 3 => isMethodNeverOverridden
    }

  override def productPrefix = "Binding"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[BindingDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "SIGNATURE" => this._signature
      case "IS_METHOD_NEVER_OVERRIDDEN" => this._isMethodNeverOverridden.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "SIGNATURE" => this._signature = value.asInstanceOf[String]
      case "IS_METHOD_NEVER_OVERRIDDEN" => this._isMethodNeverOverridden = value match {
        case null | None => None
        case someVal: JBoolean => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewBinding]
   this._name = other.name
   this._signature = other.signature
   this._isMethodNeverOverridden = other.isMethodNeverOverridden


}

}
