package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object DomAttribute {
  def apply(graph: Graph, id: Long) = new DomAttribute(graph, id)

  val Label = "DOM_ATTRIBUTE"
  val LabelId: Int = 601

  object PropertyNames {
    val Name = "NAME" 
    val Value = "VALUE" 
    val all: Set[String] = Set(Name, Value)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val Value = new PropertyKey[String]("VALUE") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[DomAttributeDb] {
    override val forLabel = DomAttribute.Label
    override val forLabelId = DomAttribute.LabelId

    override def createNode(ref: NodeRef[DomAttributeDb]) =
      new DomAttributeDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = DomAttribute(graph, id)
  }
}

trait DomAttributeBase extends CpgNode  with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class DomAttribute(graph: Graph, id: Long) extends NodeRef[DomAttributeDb](graph, id)
  with DomAttributeBase
  with StoredNode
   {
    override def name: String = get().name
  override def value: String = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _domNodeViaContainsNodeIn: Iterator[DomNode] = get()._domNodeViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DomAttribute.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => value
    }

  override def productPrefix = "DomAttribute"
  override def productArity = 3
}

class DomAttributeDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with DomAttributeBase {

  override def layoutInformation: NodeLayoutInformation = DomAttribute.layoutInformation

private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _domNodeViaContainsNodeIn: Iterator[DomNode] = _containsNodeIn.asScala.collect { case node: DomNode => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    DomAttribute.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => value
    }

  override def productPrefix = "DomAttribute"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DomAttributeDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "VALUE" => this._value
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "VALUE" => this._value = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewDomAttribute]
   this._name = other.name
   this._value = other.value


}

}
