package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object KeyValuePair {
  def apply(graph: Graph, id: Long) = new KeyValuePair(graph, id)

  val Label = "KEY_VALUE_PAIR"
  val LabelId: Int = 217

  object PropertyNames {
    val Key = "KEY" 
    val Value = "VALUE" 
    val all: Set[String] = Set(Key, Value)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Key = new PropertyKey[String]("KEY") 
    val Value = new PropertyKey[String]("VALUE") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[KeyValuePairDb] {
    override val forLabel = KeyValuePair.Label
    override val forLabelId = KeyValuePair.LabelId

    override def createNode(ref: NodeRef[KeyValuePairDb]) =
      new KeyValuePairDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = KeyValuePair(graph, id)
  }
}

trait KeyValuePairBase extends CpgNode  with HasKey with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class KeyValuePair(graph: Graph, id: Long) extends NodeRef[KeyValuePairDb](graph, id)
  with KeyValuePairBase
  with StoredNode
   {
    override def key: String = get().key
  override def value: String = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _findingViaContainsNodeIn: Iterator[Finding] = get()._findingViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    KeyValuePair.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "key" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => key
case 2 => value
    }

  override def productPrefix = "KeyValuePair"
  override def productArity = 3
}

class KeyValuePairDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with KeyValuePairBase {

  override def layoutInformation: NodeLayoutInformation = KeyValuePair.layoutInformation

private var _key: String = null
def key(): String = _key

private var _value: String = null
def value(): String = _value


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (key != null) { properties.put("KEY", key) }
if (value != null) { properties.put("VALUE", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _findingViaContainsNodeIn: Iterator[Finding] = _containsNodeIn.asScala.collect { case node: Finding => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    KeyValuePair.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "key" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => key
case 2 => value
    }

  override def productPrefix = "KeyValuePair"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[KeyValuePairDb]

  override def property(key:String): AnyRef = {
    key match {
      case "KEY" => this._key
      case "VALUE" => this._value
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "KEY" => this._key = value.asInstanceOf[String]
      case "VALUE" => this._value = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewKeyValuePair]
   this._key = other.key
   this._value = other.value


}

}
