package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object MatchInfo {
  def apply(graph: Graph, id: Long) = new MatchInfo(graph, id)

  val Label = "MATCH_INFO"
  val LabelId: Int = 51

  object PropertyNames {
    val Pattern = "PATTERN" 
    val Category = "CATEGORY" 
    val all: Set[String] = Set(Pattern, Category)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Pattern = new PropertyKey[String]("PATTERN") 
    val Category = new PropertyKey[String]("CATEGORY") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MatchInfoDb] {
    override val forLabel = MatchInfo.Label
    override val forLabelId = MatchInfo.LabelId

    override def createNode(ref: NodeRef[MatchInfoDb]) =
      new MatchInfoDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = MatchInfo(graph, id)
  }
}

trait MatchInfoBase extends CpgNode  with HasPattern with HasCategory {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MatchInfo(graph: Graph, id: Long) extends NodeRef[MatchInfoDb](graph, id)
  with MatchInfoBase
  with StoredNode
   {
    override def pattern: String = get().pattern
  override def category: String = get().category
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaContainsNodeIn
def _sensitiveMemberViaContainsNodeIn: Iterator[SensitiveMember] = get()._sensitiveMemberViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MatchInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "pattern" 
case 2 => "category" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => pattern
case 2 => category
    }

  override def productPrefix = "MatchInfo"
  override def productArity = 3
}

class MatchInfoDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with MatchInfoBase {

  override def layoutInformation: NodeLayoutInformation = MatchInfo.layoutInformation

private var _pattern: String = null
def pattern(): String = _pattern

private var _category: String = null
def category(): String = _category


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (pattern != null) { properties.put("PATTERN", pattern) }
if (category != null) { properties.put("CATEGORY", category) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = _containsNodeIn.asScala.collect { case node: SensitiveDataType => node }
def _sensitiveMemberViaContainsNodeIn: Iterator[SensitiveMember] = _containsNodeIn.asScala.collect { case node: SensitiveMember => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MatchInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "pattern" 
case 2 => "category" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => pattern
case 2 => category
    }

  override def productPrefix = "MatchInfo"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MatchInfoDb]

  override def property(key:String): AnyRef = {
    key match {
      case "PATTERN" => this._pattern
      case "CATEGORY" => this._category
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "PATTERN" => this._pattern = value.asInstanceOf[String]
      case "CATEGORY" => this._category = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMatchInfo]
   this._pattern = other.pattern
   this._category = other.category


}

}
