package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object NamespaceBlock {
  def apply(graph: Graph, id: Long) = new NamespaceBlock(graph, id)

  val Label = "NAMESPACE_BLOCK"
  val LabelId: Int = 41

  object PropertyNames {
    val Name = "NAME" 
    val FullName = "FULL_NAME" 
    val Order = "ORDER" 
    val Filename = "FILENAME" 
    val all: Set[String] = Set(Name, FullName, Order, Filename)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val FullName = new PropertyKey[String]("FULL_NAME") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val Filename = new PropertyKey[String]("FILENAME") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.SourceFile.layoutInformation, edges.Ref.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("SOURCE_FILE","REF","AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[NamespaceBlockDb] {
    override val forLabel = NamespaceBlock.Label
    override val forLabelId = NamespaceBlock.LabelId

    override def createNode(ref: NodeRef[NamespaceBlockDb]) =
      new NamespaceBlockDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = NamespaceBlock(graph, id)
  }
}

trait NamespaceBlockBase extends CpgNode with AstNodeBase with HasName with HasFullName with HasOrder with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class NamespaceBlock(graph: Graph, id: Long) extends NodeRef[NamespaceBlockDb](graph, id)
  with NamespaceBlockBase
  with StoredNode
  with AstNode {
    override def name: String = get().name
  override def fullName: String = get().fullName
  override def order: Integer = get().order
  override def filename: String = get().filename
  
  def _fileViaSourceFileOut: Iterator[File] = get()._fileViaSourceFileOut
override def _sourceFileOut(): JIterator[StoredNode] = get()._sourceFileOut
def _namespaceViaRefOut: Iterator[Namespace] = get()._namespaceViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
def _methodViaAstOut: Iterator[Method] = get()._methodViaAstOut
def _typeDeclViaAstOut: Iterator[TypeDecl] = get()._typeDeclViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _fileViaAstIn: Option[File] = get()._fileViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    NamespaceBlock.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "order" 
case 4 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => fullName
case 3 => order
case 4 => filename
    }

  override def productPrefix = "NamespaceBlock"
  override def productArity = 5
}

class NamespaceBlockDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with NamespaceBlockBase {

  override def layoutInformation: NodeLayoutInformation = NamespaceBlock.layoutInformation

private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _order: Integer = null
def order(): Integer = _order

private var _filename: String = null
def filename(): String = _filename


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (order != null) { properties.put("ORDER", order) }
if (filename != null) { properties.put("FILENAME", filename) }

  properties
}

  def _fileViaSourceFileOut: Iterator[File] = _sourceFileOut.asScala.collect { case node: File => node }
override def _sourceFileOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _namespaceViaRefOut: Iterator[Namespace] = _refOut.asScala.collect { case node: Namespace => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstOut: Iterator[Method] = _astOut.asScala.collect { case node: Method => node }
def _typeDeclViaAstOut: Iterator[TypeDecl] = _astOut.asScala.collect { case node: TypeDecl => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _fileViaAstIn: Option[File] = _astIn.asScala.collect { case node: File => node }.nextOption
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    NamespaceBlock.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "order" 
case 4 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => fullName
case 3 => order
case 4 => filename
    }

  override def productPrefix = "NamespaceBlock"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[NamespaceBlockDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "FULL_NAME" => this._fullName
      case "ORDER" => this._order
      case "FILENAME" => this._filename
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "FILENAME" => this._filename = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewNamespaceBlock]
   this._name = other.name
   this._fullName = other.fullName
   this._order = other.order
   this._filename = other.filename

  graph.indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}
