package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Route {
  def apply(graph: Graph, id: Long) = new Route(graph, id)

  val Label = "ROUTE"
  val LabelId: Int = 215

  object PropertyNames {
    val Path = "PATH" 
    val all: Set[String] = Set(Path)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Path = new PropertyKey[String]("PATH") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[RouteDb] {
    override val forLabel = Route.Label
    override val forLabelId = Route.LabelId

    override def createNode(ref: NodeRef[RouteDb]) =
      new RouteDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Route(graph, id)
  }
}

trait RouteBase extends CpgNode  with HasPath {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Route(graph: Graph, id: Long) extends NodeRef[RouteDb](graph, id)
  with RouteBase
  with StoredNode
   {
    override def path: String = get().path
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Route.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "path" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => path
    }

  override def productPrefix = "Route"
  override def productArity = 2
}

class RouteDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with RouteBase {

  override def layoutInformation: NodeLayoutInformation = Route.layoutInformation

private var _path: String = null
def path(): String = _path


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (path != null) { properties.put("PATH", path) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Route.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "path" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => path
    }

  override def productPrefix = "Route"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[RouteDb]

  override def property(key:String): AnyRef = {
    key match {
      case "PATH" => this._path
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "PATH" => this._path = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewRoute]
   this._path = other.path


}

}
