package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object SensitiveDataType {
  def apply(graph: Graph, id: Long) = new SensitiveDataType(graph, id)

  val Label = "SENSITIVE_DATA_TYPE"
  val LabelId: Int = 52

  object PropertyNames {
    val FullName = "FULL_NAME" 
    val Names = "names" 
    val Members = "members" 
    val all: Set[String] = Set(FullName, Names, Members)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val FullName = new PropertyKey[String]("FULL_NAME") 
    val Names = new PropertyKey[Seq[MatchInfo]]("names") 
    val Members = new PropertyKey[Seq[SensitiveMember]]("members") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataOfType.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_OF_TYPE","CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveDataTypeDb] {
    override val forLabel = SensitiveDataType.Label
    override val forLabelId = SensitiveDataType.LabelId

    override def createNode(ref: NodeRef[SensitiveDataTypeDb]) =
      new SensitiveDataTypeDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = SensitiveDataType(graph, id)
  }
}

trait SensitiveDataTypeBase extends CpgNode  with HasFullName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def names: List[MatchInfoBase]
def members: List[SensitiveMemberBase]
}

class SensitiveDataType(graph: Graph, id: Long) extends NodeRef[SensitiveDataTypeDb](graph, id)
  with SensitiveDataTypeBase
  with StoredNode
   {
    override def fullName: String = get().fullName
    def names = get().names
  def members = get().members
  def _typeDeclViaIsSensitiveDataDescrOfOut: Iterator[TypeDecl] = get()._typeDeclViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = get()._matchInfoViaContainsNodeOut
def _sensitiveMemberViaContainsNodeOut: Iterator[SensitiveMember] = get()._sensitiveMemberViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveVariableViaIsSensitiveDataOfTypeIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataOfTypeIn
override def _isSensitiveDataOfTypeIn(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveDataType.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fullName" 
case 2 => "names" 
case 3 => "members" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => fullName
case 2 => names
case 3 => members
    }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 4
}

class SensitiveDataTypeDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with SensitiveDataTypeBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveDataType.layoutInformation

private var _fullName: String = null
def fullName(): String = _fullName

private var _names: List[MatchInfo] = Nil
def names: List[MatchInfo] = this._names


private var _members: List[SensitiveMember] = Nil
def members: List[SensitiveMember] = this._members


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (fullName != null) { properties.put("FULL_NAME", fullName) }
  if (this._names.nonEmpty) { properties.put("names", this._names.asJava) }
  if (this._members.nonEmpty) { properties.put("members", this._members.asJava) }
  properties
}

  def _typeDeclViaIsSensitiveDataDescrOfOut: Iterator[TypeDecl] = _isSensitiveDataDescrOfOut.asScala.collect { case node: TypeDecl => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = _containsNodeOut.asScala.collect { case node: MatchInfo => node }
def _sensitiveMemberViaContainsNodeOut: Iterator[SensitiveMember] = _containsNodeOut.asScala.collect { case node: SensitiveMember => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataOfTypeIn: Iterator[SensitiveVariable] = _isSensitiveDataOfTypeIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataOfTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveDataType.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fullName" 
case 2 => "names" 
case 3 => "members" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => fullName
case 2 => names
case 3 => members
    }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveDataTypeDb]

  override def property(key:String): AnyRef = {
    key match {
      case "FULL_NAME" => this._fullName
      case "names" => this._names
      case "members" => this._members
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
      case "names" => this._names = value match {
        case singleValue: MatchInfo => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[MatchInfo]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[MatchInfo]]
      }
      case "members" => this._members = value match {
        case singleValue: SensitiveMember => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[SensitiveMember]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[SensitiveMember]]
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSensitiveDataType]
   this._fullName = other.fullName
  this._names = if(other.names == null) Nil else other.names.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[MatchInfo]
    case oldNode:StoredNode => oldNode.asInstanceOf[MatchInfo]
    case _ => throw new MatchError("unreachable")
  }}
  this._members = if(other.members == null) Nil else other.members.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[SensitiveMember]
    case oldNode:StoredNode => oldNode.asInstanceOf[SensitiveMember]
    case _ => throw new MatchError("unreachable")
  }}
  graph.indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}
