package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Write {
  def apply(graph: Graph, id: Long) = new Write(graph, id)

  val Label = "WRITE"
  val LabelId: Int = 210

  object PropertyNames {
    val Triggercallchains = "triggerCallChains" 
    val Descriptorflows = "descriptorFlows" 
    val Sink = "sink" 
    val Flows = "flows" 
    val all: Set[String] = Set(Triggercallchains, Descriptorflows, Sink, Flows)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    
    val Triggercallchains = new PropertyKey[Seq[CallChain]]("triggerCallChains") 
    val Descriptorflows = new PropertyKey[Seq[Flow]]("descriptorFlows") 
    val Sink = new PropertyKey[Sink]("sink") 
    val Flows = new PropertyKey[Seq[Flow]]("flows") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[WriteDb] {
    override val forLabel = Write.Label
    override val forLabelId = Write.LabelId

    override def createNode(ref: NodeRef[WriteDb]) =
      new WriteDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Write(graph, id)
  }
}

trait WriteBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def sink: SinkBase
def flows: List[FlowBase]
}

class Write(graph: Graph, id: Long) extends NodeRef[WriteDb](graph, id)
  with WriteBase
  with StoredNode
   {
  
    def triggerCallChains = get().triggerCallChains
  def descriptorFlows = get().descriptorFlows
  def sink = get().sink
  def flows = get().flows
  def _callChainViaContainsNodeOut: Iterator[CallChain] = get()._callChainViaContainsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Write.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "sink" 
case 4 => "flows" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => sink
case 4 => flows
    }

  override def productPrefix = "Write"
  override def productArity = 5
}

class WriteDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with WriteBase {

  override def layoutInformation: NodeLayoutInformation = Write.layoutInformation



private var _triggerCallChains: List[CallChain] = Nil
def triggerCallChains: List[CallChain] = this._triggerCallChains


private var _descriptorFlows: List[Flow] = Nil
def descriptorFlows: List[Flow] = this._descriptorFlows


private var _sink: Sink = null
def sink: Sink = this._sink


private var _flows: List[Flow] = Nil
def flows: List[Flow] = this._flows


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._triggerCallChains.nonEmpty) { properties.put("triggerCallChains", this._triggerCallChains.asJava) }
  if (this._descriptorFlows.nonEmpty) { properties.put("descriptorFlows", this._descriptorFlows.asJava) }
   if (this._sink != null) { properties.put("sink", this._sink) }
  if (this._flows.nonEmpty) { properties.put("flows", this._flows.asJava) }
  properties
}

  def _callChainViaContainsNodeOut: Iterator[CallChain] = _containsNodeOut.asScala.collect { case node: CallChain => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Write.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "sink" 
case 4 => "flows" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => sink
case 4 => flows
    }

  override def productPrefix = "Write"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[WriteDb]

  override def property(key:String): AnyRef = {
    key match {
      
      case "triggerCallChains" => this._triggerCallChains
      case "descriptorFlows" => this._descriptorFlows
      case "sink" => this._sink
      case "flows" => this._flows
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
    
      case "triggerCallChains" => this._triggerCallChains = value match {
        case singleValue: CallChain => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CallChain]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[CallChain]]
      }
      case "descriptorFlows" => this._descriptorFlows = value match {
        case singleValue: Flow => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Flow]]
      }
      case "sink" => this._sink = value.asInstanceOf[Sink]
      case "flows" => this._flows = value match {
        case singleValue: Flow => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Flow]]
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewWrite]

  this._triggerCallChains = if(other.triggerCallChains == null) Nil else other.triggerCallChains.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CallChain]
    case oldNode:StoredNode => oldNode.asInstanceOf[CallChain]
    case _ => throw new MatchError("unreachable")
  }}
  this._descriptorFlows = if(other.descriptorFlows == null) Nil else other.descriptorFlows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}
  this._sink = other.sink match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Sink]
    case oldNode: StoredNode => oldNode.asInstanceOf[Sink]
    case _ => throw new MatchError("unreachable")
  }
  this._flows = if(other.flows == null) Nil else other.flows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}

}

}
