package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object PropertyErrorRegister {
  private var errorMap = Set[(Class[_], String)]()
  private val logger = org.slf4j.LoggerFactory.getLogger(getClass)

  def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String): Unit = {
    if (!errorMap.contains((clazz, propertyName))) {
      logger.warn("Property " + propertyName + " is deprecated for " + clazz.getName + ".")
      errorMap += ((clazz, propertyName))
    }
  }
}


trait CpgNode {
  def label: String
}

/* a node that stored inside an Graph (rather than e.g. DiffGraph) */
trait StoredNode extends Node with CpgNode with Product {
  /* underlying Node in the graph.
   * since this is a StoredNode, this is always set */
  def underlying: Node = this

  /** labels of product elements, used e.g. for pretty-printing */
  def productElementLabel(n: Int): String

  /* all properties plus label and id */
  def toMap: Map[String, Any] = {
    val map = valueMap
    map.put("_label", label)
    map.put("_id", id: java.lang.Long)
    map.asScala.toMap
  }

  /*Sets fields from newNode*/
  def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode):Unit = ???

  /* all properties */
  def valueMap: JMap[String, AnyRef]

  def _bindsIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taintRemoveIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _evalTypeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _typeDeclAliasIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _capturedByIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _postDominateIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataOfTypeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _propagateIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _conditionIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _receiverIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _captureIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _attachedDataIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _argumentIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taggedByIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _aliasOfIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cdgIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsNodeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _parameterLinkIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _astIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _refIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dynamicTypeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _sourceFileIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsToIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _vtableIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _inheritsFromIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _reachingDefIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dominateIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cfgIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _callIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taintRemoveOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _evalTypeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _typeDeclAliasOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _capturedByOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _postDominateOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataOfTypeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _propagateOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _conditionOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _receiverOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _captureOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _attachedDataOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _argumentOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taggedByOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _aliasOfOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cdgOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsNodeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _parameterLinkOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _astOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _refOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dynamicTypeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _sourceFileOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsToOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _vtableOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _inheritsFromOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _reachingDefOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dominateOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cfgOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _callOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
}

trait DeclarationBase extends CpgNode with HasName 
trait Declaration extends StoredNode with DeclarationBase 

trait ExpressionBase extends CpgNode with HasCode with HasOrder with HasArgumentIndex with TrackingPointBase with CfgNodeBase with AstNodeBase
trait Expression extends StoredNode with ExpressionBase with TrackingPoint with CfgNode with AstNode

trait LocalLikeBase extends CpgNode with HasName 
trait LocalLike extends StoredNode with LocalLikeBase 

trait CfgNodeBase extends CpgNode with HasLineNumber with HasColumnNumber with HasInternalFlags with HasCode with WithinMethodBase with AstNodeBase
trait CfgNode extends StoredNode with CfgNodeBase with WithinMethod with AstNode

trait TrackingPointBase extends CpgNode  with WithinMethodBase
trait TrackingPoint extends StoredNode with TrackingPointBase with WithinMethod

trait WithinMethodBase extends CpgNode  
trait WithinMethod extends StoredNode with WithinMethodBase 

trait AstNodeBase extends CpgNode with HasOrder 
trait AstNode extends StoredNode with AstNodeBase 

trait CallReprBase extends CpgNode with HasCode with HasName with HasSignature with CfgNodeBase
trait CallRepr extends StoredNode with CallReprBase with CfgNode

trait HasNodeLabel { def nodeLabel: String }
trait HasCategories { def categories: List[String] }
trait HasInheritsFromTypeFullName { def inheritsFromTypeFullName: List[String] }
trait HasMethodFullName { def methodFullName: String }
trait HasSymbol { def symbol: String }
trait HasDispatchType { def dispatchType: String }
trait HasParameterIndex { def parameterIndex: Option[Integer] }
trait HasColumnNumber { def columnNumber: Option[Integer] }
trait HasEvalType { def evalType: String }
trait HasAnnotationName { def annotationName: String }
trait HasMethodShortName { def methodShortName: String }
trait HasFilename { def filename: String }
trait HasAliasTypeFullName { def aliasTypeFullName: Option[String] }
trait HasBinarySignature { def binarySignature: Option[String] }
trait HasClosureBindingId { def closureBindingId: Option[String] }
trait HasParserTypeName { def parserTypeName: String }
trait HasEvaluationStrategy { def evaluationStrategy: String }
trait HasDepthFirstOrder { def depthFirstOrder: Option[Integer] }
trait HasArgumentIndex { def argumentIndex: Integer }
trait HasTypeDeclFullName { def typeDeclFullName: String }
trait HasFullName { def fullName: String }
trait HasAstParentType { def astParentType: String }
trait HasAnnotationFullName { def annotationFullName: String }
trait HasCode { def code: String }
trait HasOrder { def order: Integer }
trait HasLineNumber { def lineNumber: Option[Integer] }
trait HasCategory { def category: String }
trait HasHasMapping { def hasMapping: Option[JBoolean] }
trait HasCanonicalName { def canonicalName: String }
trait HasSignature { def signature: String }
trait HasClassName { def className: String }
trait HasVersion { def version: String }
trait HasIsStatic { def isStatic: JBoolean }
trait HasPackageName { def packageName: String }
trait HasLineNumberEnd { def lineNumberEnd: Option[Integer] }
trait HasAstParentFullName { def astParentFullName: String }
trait HasVarType { def varType: String }
trait HasClassShortName { def classShortName: String }
trait HasLanguage { def language: String }
trait HasIsMethodNeverOverridden { def isMethodNeverOverridden: Option[JBoolean] }
trait HasResolved { def resolved: Option[JBoolean] }
trait HasPolicyDirectories { def policyDirectories: List[String] }
trait HasModifierType { def modifierType: String }
trait HasTypeFullName { def typeFullName: String }
trait HasIsExternal { def isExternal: JBoolean }
trait HasContainedRef { def containedRef: String }
trait HasSpid { def spid: Option[String] }
trait HasMethodInstFullName { def methodInstFullName: Option[String] }
trait HasInternalFlags { def internalFlags: Option[Integer] }
trait HasName { def name: String }
trait HasNodeId { def nodeId: String }
trait HasValue { def value: String }
trait HasSourceType { def sourceType: String }
trait HasLiteralsToSink { def literalsToSink: List[String] }
trait HasContent { def content: String }
trait HasClosureOriginalName { def closureOriginalName: Option[String] }
trait HasOverlays { def overlays: List[String] }
trait HasColumnNumberEnd { def columnNumberEnd: Option[Integer] }
trait HasFingerprint { def fingerprint: String }
trait HasKey { def key: String }
trait HasPath { def path: String }
trait HasDynamicTypeHintFullName { def dynamicTypeHintFullName: List[String] }
trait HasEvaluationType { def evaluationType: String }
trait HasPattern { def pattern: String }
trait HasDependencyGroupId { def dependencyGroupId: Option[String] }
trait HasSinkType { def sinkType: String }

object Factories {
  lazy val all: List[NodeFactory[_]] = List(Local.factory, Comment.factory, Method.factory, Tag.factory, TypeRef.factory, AnnotationLiteral.factory, Ioflow.factory, Transform.factory, Read.factory, MethodParameterIn.factory, Namespace.factory, VariableInfo.factory, Flow.factory, ClosureBinding.factory, Unknown.factory, AnnotationParameter.factory, DetachedTrackingPoint.factory, SensitiveDataType.factory, Member.factory, CallSite.factory, MethodInst.factory, ConfigFile.factory, SensitiveReference.factory, Location.factory, MetaData.factory, Return.factory, TagNodePair.factory, DomAttribute.factory, TypeArgument.factory, Source.factory, SensitiveVariable.factory, FieldIdentifier.factory, Write.factory, KeyValuePair.factory, DomNode.factory, MethodSummary.factory, NamespaceBlock.factory, ArrayInitializer.factory, ProgramPoint.factory, Annotation.factory, SensitiveMember.factory, Identifier.factory, Transformation.factory, File.factory, Dependency.factory, PackagePrefix.factory, ImplicitCall.factory, MatchInfo.factory, JumpTarget.factory, Framework.factory, Modifier.factory, ControlStructure.factory, Block.factory, SpBlacklist.factory, FrameworkData.factory, Literal.factory, Route.factory, MethodReturn.factory, MethodParameterOut.factory, CallChain.factory, Type.factory, MethodRef.factory, TypeDecl.factory, Sink.factory, SpAnnotationParameter.factory, Finding.factory, Call.factory, TypeParameter.factory, Tags.factory, AnnotationParameterAssign.factory, Binding.factory)
  lazy val allAsJava: java.util.List[NodeFactory[_]] = all.asJava
}

