package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object AnnotationLiteral {
  def apply(graph: Graph, id: Long) = new AnnotationLiteral(graph, id)

  val Label = "ANNOTATION_LITERAL"
  val LabelId: Int = 49

  object PropertyNames {
    val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
    val InternalFlags = "INTERNAL_FLAGS" 
    val Code = "CODE" 
    val Name = "NAME" 
    val Order = "ORDER" 
    val ArgumentIndex = "ARGUMENT_INDEX" 
    val ColumnNumber = "COLUMN_NUMBER" 
    val LineNumber = "LINE_NUMBER" 
    val all: Set[String] = Set(DepthFirstOrder, InternalFlags, Code, Name, Order, ArgumentIndex, ColumnNumber, LineNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val DepthFirstOrder = new PropertyKey[Integer]("DEPTH_FIRST_ORDER") 
    val InternalFlags = new PropertyKey[Integer]("INTERNAL_FLAGS") 
    val Code = new PropertyKey[String]("CODE") 
    val Name = new PropertyKey[String]("NAME") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val ArgumentIndex = new PropertyKey[Integer]("ARGUMENT_INDEX") 
    val ColumnNumber = new PropertyKey[Integer]("COLUMN_NUMBER") 
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationLiteralDb] {
    override val forLabel = AnnotationLiteral.Label
    override val forLabelId = AnnotationLiteral.LabelId

    override def createNode(ref: NodeRef[AnnotationLiteralDb]) =
      new AnnotationLiteralDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = AnnotationLiteral(graph, id)
  }
}

trait AnnotationLiteralBase extends CpgNode with ExpressionBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasName with HasOrder with HasArgumentIndex with HasColumnNumber with HasLineNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class AnnotationLiteral(graph: Graph, id: Long) extends NodeRef[AnnotationLiteralDb](graph, id)
  with AnnotationLiteralBase
  with StoredNode
  with Expression {
    override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  override def code: String = get().code
  override def name: String = get().name
  override def order: Integer = get().order
  override def argumentIndex: Integer = get().argumentIndex
  override def columnNumber: Option[Integer] = get().columnNumber
  override def lineNumber: Option[Integer] = get().lineNumber
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationLiteral.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "order" 
case 6 => "argumentIndex" 
case 7 => "columnNumber" 
case 8 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => order
case 6 => argumentIndex
case 7 => columnNumber
case 8 => lineNumber
    }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 9
}

class AnnotationLiteralDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with Expression with AnnotationLiteralBase {

  override def layoutInformation: NodeLayoutInformation = AnnotationLiteral.layoutInformation

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    AnnotationLiteral.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "order" 
case 6 => "argumentIndex" 
case 7 => "columnNumber" 
case 8 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => order
case 6 => argumentIndex
case 7 => columnNumber
case 8 => lineNumber
    }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationLiteralDb]

  override def property(key:String): AnyRef = {
    key match {
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
      case "INTERNAL_FLAGS" => this._internalFlags.orNull
      case "CODE" => this._code
      case "NAME" => this._name
      case "ORDER" => this._order
      case "ARGUMENT_INDEX" => this._argumentIndex
      case "COLUMN_NUMBER" => this._columnNumber.orNull
      case "LINE_NUMBER" => this._lineNumber.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "INTERNAL_FLAGS" => this._internalFlags = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "CODE" => this._code = value.asInstanceOf[String]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
      case "COLUMN_NUMBER" => this._columnNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewAnnotationLiteral]
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags
   this._code = other.code
   this._name = other.name
   this._order = other.order
   this._argumentIndex = other.argumentIndex
   this._columnNumber = other.columnNumber
   this._lineNumber = other.lineNumber


}

}
