package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object ArrayInitializer {
  def apply(graph: Graph, id: Long) = new ArrayInitializer(graph, id)

  val Label = "ARRAY_INITIALIZER"
  val LabelId: Int = 14

  object PropertyNames {
    val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
    val InternalFlags = "INTERNAL_FLAGS" 
    val Code = "CODE" 
    val Order = "ORDER" 
    val ArgumentIndex = "ARGUMENT_INDEX" 
    val ColumnNumber = "COLUMN_NUMBER" 
    val LineNumber = "LINE_NUMBER" 
    val all: Set[String] = Set(DepthFirstOrder, InternalFlags, Code, Order, ArgumentIndex, ColumnNumber, LineNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val DepthFirstOrder = new PropertyKey[Integer]("DEPTH_FIRST_ORDER") 
    val InternalFlags = new PropertyKey[Integer]("INTERNAL_FLAGS") 
    val Code = new PropertyKey[String]("CODE") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val ArgumentIndex = new PropertyKey[Integer]("ARGUMENT_INDEX") 
    val ColumnNumber = new PropertyKey[Integer]("COLUMN_NUMBER") 
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.EvalType.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Condition.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONDITION","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("EVAL_TYPE","AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ArrayInitializerDb] {
    override val forLabel = ArrayInitializer.Label
    override val forLabelId = ArrayInitializer.LabelId

    override def createNode(ref: NodeRef[ArrayInitializerDb]) =
      new ArrayInitializerDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = ArrayInitializer(graph, id)
  }
}

trait ArrayInitializerBase extends CpgNode with AstNodeBase with ExpressionBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasOrder with HasArgumentIndex with HasColumnNumber with HasLineNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ArrayInitializer(graph: Graph, id: Long) extends NodeRef[ArrayInitializerDb](graph, id)
  with ArrayInitializerBase
  with StoredNode
  with AstNode with Expression {
    override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  override def code: String = get().code
  override def order: Integer = get().order
  override def argumentIndex: Integer = get().argumentIndex
  override def columnNumber: Option[Integer] = get().columnNumber
  override def lineNumber: Option[Integer] = get().lineNumber
  
  def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _literalViaAstOut: Iterator[Literal] = get()._literalViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _controlStructureViaConditionIn: Iterator[ControlStructure] = get()._controlStructureViaConditionIn
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _controlStructureViaAstIn: Iterator[ControlStructure] = get()._controlStructureViaAstIn
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ArrayInitializer.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "order" 
case 5 => "argumentIndex" 
case 6 => "columnNumber" 
case 7 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => order
case 5 => argumentIndex
case 6 => columnNumber
case 7 => lineNumber
    }

  override def productPrefix = "ArrayInitializer"
  override def productArity = 8
}

class ArrayInitializerDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with Expression with ArrayInitializerBase {

  override def layoutInformation: NodeLayoutInformation = ArrayInitializer.layoutInformation

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }

  properties
}

  def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _literalViaAstOut: Iterator[Literal] = _astOut.asScala.collect { case node: Literal => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _controlStructureViaConditionIn: Iterator[ControlStructure] = _conditionIn.asScala.collect { case node: ControlStructure => node }
override def _conditionIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaAstIn: Iterator[ControlStructure] = _astIn.asScala.collect { case node: ControlStructure => node }
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ArrayInitializer.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "order" 
case 5 => "argumentIndex" 
case 6 => "columnNumber" 
case 7 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => order
case 5 => argumentIndex
case 6 => columnNumber
case 7 => lineNumber
    }

  override def productPrefix = "ArrayInitializer"
  override def productArity = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ArrayInitializerDb]

  override def property(key:String): AnyRef = {
    key match {
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
      case "INTERNAL_FLAGS" => this._internalFlags.orNull
      case "CODE" => this._code
      case "ORDER" => this._order
      case "ARGUMENT_INDEX" => this._argumentIndex
      case "COLUMN_NUMBER" => this._columnNumber.orNull
      case "LINE_NUMBER" => this._lineNumber.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "INTERNAL_FLAGS" => this._internalFlags = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "CODE" => this._code = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
      case "COLUMN_NUMBER" => this._columnNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewArrayInitializer]
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags
   this._code = other.code
   this._order = other.order
   this._argumentIndex = other.argumentIndex
   this._columnNumber = other.columnNumber
   this._lineNumber = other.lineNumber


}

}
