package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object CallSite {
  def apply(graph: Graph, id: Long) = new CallSite(graph, id)

  val Label = "CALL_SITE"
  val LabelId: Int = 201

  object PropertyNames {
    val Method = "method" 
    val Call = "call" 
    val Callermethod = "callerMethod" 
    val all: Set[String] = Set(Method, Call, Callermethod)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    
    val Method = new PropertyKey[Method]("method") 
    val Call = new PropertyKey[Call]("call") 
    val Callermethod = new PropertyKey[Method]("callerMethod") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[CallSiteDb] {
    override val forLabel = CallSite.Label
    override val forLabelId = CallSite.LabelId

    override def createNode(ref: NodeRef[CallSiteDb]) =
      new CallSiteDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = CallSite(graph, id)
  }
}

trait CallSiteBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def method: MethodBase
def call: CallBase
def callerMethod: MethodBase
}

class CallSite(graph: Graph, id: Long) extends NodeRef[CallSiteDb](graph, id)
  with CallSiteBase
  with StoredNode
   {
  
    def method = get().method
  def call = get().call
  def callerMethod = get().callerMethod
  def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    CallSite.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "method" 
case 2 => "call" 
case 3 => "callerMethod" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => method
case 2 => call
case 3 => callerMethod
    }

  override def productPrefix = "CallSite"
  override def productArity = 4
}

class CallSiteDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with CallSiteBase {

  override def layoutInformation: NodeLayoutInformation = CallSite.layoutInformation



private var _method: Method = null
def method: Method = this._method


private var _call: Call = null
def call: Call = this._call


private var _callerMethod: Method = null
def callerMethod: Method = this._callerMethod


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

   if (this._method != null) { properties.put("method", this._method) }
   if (this._call != null) { properties.put("call", this._call) }
   if (this._callerMethod != null) { properties.put("callerMethod", this._callerMethod) }
  properties
}

  def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    CallSite.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "method" 
case 2 => "call" 
case 3 => "callerMethod" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => method
case 2 => call
case 3 => callerMethod
    }

  override def productPrefix = "CallSite"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallSiteDb]

  override def property(key:String): AnyRef = {
    key match {
      
      case "method" => this._method
      case "call" => this._call
      case "callerMethod" => this._callerMethod
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
    
      case "method" => this._method = value.asInstanceOf[Method]
      case "call" => this._call = value.asInstanceOf[Call]
      case "callerMethod" => this._callerMethod = value.asInstanceOf[Method]
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewCallSite]

  this._method = other.method match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode: StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }
  this._call = other.call match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Call]
    case oldNode: StoredNode => oldNode.asInstanceOf[Call]
    case _ => throw new MatchError("unreachable")
  }
  this._callerMethod = other.callerMethod match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode: StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }

}

}
