package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Comment {
  def apply(graph: Graph, id: Long) = new Comment(graph, id)

  val Label = "COMMENT"
  val LabelId: Int = 511

  object PropertyNames {
    val LineNumber = "LINE_NUMBER" 
    val Code = "CODE" 
    val all: Set[String] = Set(LineNumber, Code)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    val Code = new PropertyKey[String]("CODE") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[CommentDb] {
    override val forLabel = Comment.Label
    override val forLabelId = Comment.LabelId

    override def createNode(ref: NodeRef[CommentDb]) =
      new CommentDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Comment(graph, id)
  }
}

trait CommentBase extends CpgNode  with HasLineNumber with HasCode {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Comment(graph: Graph, id: Long) extends NodeRef[CommentDb](graph, id)
  with CommentBase
  with StoredNode
   {
    override def lineNumber: Option[Integer] = get().lineNumber
  override def code: String = get().code
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _fileViaAstIn: Iterator[File] = get()._fileViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Comment.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "code" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => lineNumber
case 2 => code
    }

  override def productPrefix = "Comment"
  override def productArity = 3
}

class CommentDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with CommentBase {

  override def layoutInformation: NodeLayoutInformation = Comment.layoutInformation

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _code: String = null
def code(): String = _code


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (code != null) { properties.put("CODE", code) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _fileViaAstIn: Iterator[File] = _astIn.asScala.collect { case node: File => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Comment.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "code" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => lineNumber
case 2 => code
    }

  override def productPrefix = "Comment"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CommentDb]

  override def property(key:String): AnyRef = {
    key match {
      case "LINE_NUMBER" => this._lineNumber.orNull
      case "CODE" => this._code
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "CODE" => this._code = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewComment]
   this._lineNumber = other.lineNumber
   this._code = other.code


}

}
