package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Dependency {
  def apply(graph: Graph, id: Long) = new Dependency(graph, id)

  val Label = "DEPENDENCY"
  val LabelId: Int = 35

  object PropertyNames {
    val Version = "VERSION" 
    val Name = "NAME" 
    val DependencyGroupId = "DEPENDENCY_GROUP_ID" 
    val all: Set[String] = Set(Version, Name, DependencyGroupId)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Version = new PropertyKey[String]("VERSION") 
    val Name = new PropertyKey[String]("NAME") 
    val DependencyGroupId = new PropertyKey[String]("DEPENDENCY_GROUP_ID") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[DependencyDb] {
    override val forLabel = Dependency.Label
    override val forLabelId = Dependency.LabelId

    override def createNode(ref: NodeRef[DependencyDb]) =
      new DependencyDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Dependency(graph, id)
  }
}

trait DependencyBase extends CpgNode  with HasVersion with HasName with HasDependencyGroupId {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Dependency(graph: Graph, id: Long) extends NodeRef[DependencyDb](graph, id)
  with DependencyBase
  with StoredNode
   {
    override def version: String = get().version
  override def name: String = get().name
  override def dependencyGroupId: Option[String] = get().dependencyGroupId
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Dependency.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "version" 
case 2 => "name" 
case 3 => "dependencyGroupId" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => version
case 2 => name
case 3 => dependencyGroupId
    }

  override def productPrefix = "Dependency"
  override def productArity = 4
}

class DependencyDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with DependencyBase {

  override def layoutInformation: NodeLayoutInformation = Dependency.layoutInformation

private var _version: String = null
def version(): String = _version

private var _name: String = null
def name(): String = _name

private var _dependencyGroupId: Option[String] = None
def dependencyGroupId(): Option[String] = _dependencyGroupId


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (version != null) { properties.put("VERSION", version) }
if (name != null) { properties.put("NAME", name) }
dependencyGroupId.map { value => properties.put("DEPENDENCY_GROUP_ID", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Dependency.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "version" 
case 2 => "name" 
case 3 => "dependencyGroupId" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => version
case 2 => name
case 3 => dependencyGroupId
    }

  override def productPrefix = "Dependency"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DependencyDb]

  override def property(key:String): AnyRef = {
    key match {
      case "VERSION" => this._version
      case "NAME" => this._name
      case "DEPENDENCY_GROUP_ID" => this._dependencyGroupId.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "VERSION" => this._version = value.asInstanceOf[String]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "DEPENDENCY_GROUP_ID" => this._dependencyGroupId = value match {
        case null | None => None
        case someVal: String => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewDependency]
   this._version = other.version
   this._name = other.name
   this._dependencyGroupId = other.dependencyGroupId


}

}
