package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Modifier {
  def apply(graph: Graph, id: Long) = new Modifier(graph, id)

  val Label = "MODIFIER"
  val LabelId: Int = 300

  object PropertyNames {
    val ModifierType = "MODIFIER_TYPE" 
    val Order = "ORDER" 
    val all: Set[String] = Set(ModifierType, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val ModifierType = new PropertyKey[String]("MODIFIER_TYPE") 
    val Order = new PropertyKey[Integer]("ORDER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[ModifierDb] {
    override val forLabel = Modifier.Label
    override val forLabelId = Modifier.LabelId

    override def createNode(ref: NodeRef[ModifierDb]) =
      new ModifierDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Modifier(graph, id)
  }
}

trait ModifierBase extends CpgNode with AstNodeBase with HasModifierType with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Modifier(graph: Graph, id: Long) extends NodeRef[ModifierDb](graph, id)
  with ModifierBase
  with StoredNode
  with AstNode {
    override def modifierType: String = get().modifierType
  override def order: Integer = get().order
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodViaAstIn: Method = get()._methodViaAstIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _typeDeclViaAstIn: TypeDecl = get()._typeDeclViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _controlStructureViaAstIn: Iterator[ControlStructure] = get()._controlStructureViaAstIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Modifier.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "modifierType" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => modifierType
case 2 => order
    }

  override def productPrefix = "Modifier"
  override def productArity = 3
}

class ModifierDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with ModifierBase {

  override def layoutInformation: NodeLayoutInformation = Modifier.layoutInformation

private var _modifierType: String = null
def modifierType(): String = _modifierType

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (modifierType != null) { properties.put("MODIFIER_TYPE", modifierType) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Method = _astIn.asScala.collect { case node: Method => node }.next
def _controlStructureViaAstIn: Iterator[ControlStructure] = _astIn.asScala.collect { case node: ControlStructure => node }
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _typeDeclViaAstIn: TypeDecl = _astIn.asScala.collect { case node: TypeDecl => node }.next
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Modifier.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "modifierType" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => modifierType
case 2 => order
    }

  override def productPrefix = "Modifier"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ModifierDb]

  override def property(key:String): AnyRef = {
    key match {
      case "MODIFIER_TYPE" => this._modifierType
      case "ORDER" => this._order
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "MODIFIER_TYPE" => this._modifierType = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewModifier]
   this._modifierType = other.modifierType
   this._order = other.order


}

}
