package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Read {
  def apply(graph: Graph, id: Long) = new Read(graph, id)

  val Label = "READ"
  val LabelId: Int = 209

  object PropertyNames {
    val Triggercallchains = "triggerCallChains" 
    val Descriptorflows = "descriptorFlows" 
    val Source = "source" 
    val all: Set[String] = Set(Triggercallchains, Descriptorflows, Source)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    
    val Triggercallchains = new PropertyKey[Seq[CallChain]]("triggerCallChains") 
    val Descriptorflows = new PropertyKey[Seq[Flow]]("descriptorFlows") 
    val Source = new PropertyKey[Source]("source") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[ReadDb] {
    override val forLabel = Read.Label
    override val forLabelId = Read.LabelId

    override def createNode(ref: NodeRef[ReadDb]) =
      new ReadDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Read(graph, id)
  }
}

trait ReadBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def source: SourceBase
}

class Read(graph: Graph, id: Long) extends NodeRef[ReadDb](graph, id)
  with ReadBase
  with StoredNode
   {
  
    def triggerCallChains = get().triggerCallChains
  def descriptorFlows = get().descriptorFlows
  def source = get().source
  def _callChainViaContainsNodeOut: Iterator[CallChain] = get()._callChainViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Read.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "source" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => source
    }

  override def productPrefix = "Read"
  override def productArity = 4
}

class ReadDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with ReadBase {

  override def layoutInformation: NodeLayoutInformation = Read.layoutInformation



private var _triggerCallChains: List[CallChain] = Nil
def triggerCallChains: List[CallChain] = this._triggerCallChains


private var _descriptorFlows: List[Flow] = Nil
def descriptorFlows: List[Flow] = this._descriptorFlows


private var _source: Source = null
def source: Source = this._source


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._triggerCallChains.nonEmpty) { properties.put("triggerCallChains", this._triggerCallChains.asJava) }
  if (this._descriptorFlows.nonEmpty) { properties.put("descriptorFlows", this._descriptorFlows.asJava) }
   if (this._source != null) { properties.put("source", this._source) }
  properties
}

  def _callChainViaContainsNodeOut: Iterator[CallChain] = _containsNodeOut.asScala.collect { case node: CallChain => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Read.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "source" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => source
    }

  override def productPrefix = "Read"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ReadDb]

  override def property(key:String): AnyRef = {
    key match {
      
      case "triggerCallChains" => this._triggerCallChains
      case "descriptorFlows" => this._descriptorFlows
      case "source" => this._source
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
    
      case "triggerCallChains" => this._triggerCallChains = value match {
        case singleValue: CallChain => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CallChain]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[CallChain]]
      }
      case "descriptorFlows" => this._descriptorFlows = value match {
        case singleValue: Flow => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Flow]]
      }
      case "source" => this._source = value.asInstanceOf[Source]
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewRead]

  this._triggerCallChains = if(other.triggerCallChains == null) Nil else other.triggerCallChains.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CallChain]
    case oldNode:StoredNode => oldNode.asInstanceOf[CallChain]
    case _ => throw new MatchError("unreachable")
  }}
  this._descriptorFlows = if(other.descriptorFlows == null) Nil else other.descriptorFlows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}
  this._source = other.source match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Source]
    case oldNode: StoredNode => oldNode.asInstanceOf[Source]
    case _ => throw new MatchError("unreachable")
  }

}

}
