package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object SensitiveMember {
  def apply(graph: Graph, id: Long) = new SensitiveMember(graph, id)

  val Label = "SENSITIVE_MEMBER"
  val LabelId: Int = 53

  object PropertyNames {
    val Name = "NAME" 
    val Names = "names" 
    val all: Set[String] = Set(Name, Names)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val Names = new PropertyKey[Seq[MatchInfo]]("names") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveMemberDb] {
    override val forLabel = SensitiveMember.Label
    override val forLabelId = SensitiveMember.LabelId

    override def createNode(ref: NodeRef[SensitiveMemberDb]) =
      new SensitiveMemberDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = SensitiveMember(graph, id)
  }
}

trait SensitiveMemberBase extends CpgNode  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def names: List[MatchInfoBase]
}

class SensitiveMember(graph: Graph, id: Long) extends NodeRef[SensitiveMemberDb](graph, id)
  with SensitiveMemberBase
  with StoredNode
   {
    override def name: String = get().name
    def names = get().names
  def _memberViaIsSensitiveDataDescrOfOut: Iterator[Member] = get()._memberViaIsSensitiveDataDescrOfOut
def _typeViaIsSensitiveDataDescrOfOut: Iterator[Type] = get()._typeViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = get()._matchInfoViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveMember.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "names" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => names
    }

  override def productPrefix = "SensitiveMember"
  override def productArity = 3
}

class SensitiveMemberDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with SensitiveMemberBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveMember.layoutInformation

private var _name: String = null
def name(): String = _name

private var _names: List[MatchInfo] = Nil
def names: List[MatchInfo] = this._names


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
  if (this._names.nonEmpty) { properties.put("names", this._names.asJava) }
  properties
}

  def _memberViaIsSensitiveDataDescrOfOut: Iterator[Member] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Member => node }
def _typeViaIsSensitiveDataDescrOfOut: Iterator[Type] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Type => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = _containsNodeOut.asScala.collect { case node: MatchInfo => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = _containsNodeIn.asScala.collect { case node: SensitiveDataType => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveMember.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "names" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => names
    }

  override def productPrefix = "SensitiveMember"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveMemberDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "names" => this._names
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "names" => this._names = value match {
        case singleValue: MatchInfo => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[MatchInfo]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[MatchInfo]]
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSensitiveMember]
   this._name = other.name
  this._names = if(other.names == null) Nil else other.names.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[MatchInfo]
    case oldNode:StoredNode => oldNode.asInstanceOf[MatchInfo]
    case _ => throw new MatchError("unreachable")
  }}

}

}
