package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object VariableInfo {
  def apply(graph: Graph, id: Long) = new VariableInfo(graph, id)

  val Label = "VARIABLE_INFO"
  val LabelId: Int = 206

  object PropertyNames {
    val VarType = "VAR_TYPE" 
    val EvaluationType = "EVALUATION_TYPE" 
    val ParameterIndex = "PARAMETER_INDEX" 
    val all: Set[String] = Set(VarType, EvaluationType, ParameterIndex)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val VarType = new PropertyKey[String]("VAR_TYPE") 
    val EvaluationType = new PropertyKey[String]("EVALUATION_TYPE") 
    val ParameterIndex = new PropertyKey[Integer]("PARAMETER_INDEX") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[VariableInfoDb] {
    override val forLabel = VariableInfo.Label
    override val forLabelId = VariableInfo.LabelId

    override def createNode(ref: NodeRef[VariableInfoDb]) =
      new VariableInfoDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = VariableInfo(graph, id)
  }
}

trait VariableInfoBase extends CpgNode  with HasVarType with HasEvaluationType with HasParameterIndex {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class VariableInfo(graph: Graph, id: Long) extends NodeRef[VariableInfoDb](graph, id)
  with VariableInfoBase
  with StoredNode
   {
    override def varType: String = get().varType
  override def evaluationType: String = get().evaluationType
  override def parameterIndex: Option[Integer] = get().parameterIndex
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    VariableInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
    }

  override def productPrefix = "VariableInfo"
  override def productArity = 4
}

class VariableInfoDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with VariableInfoBase {

  override def layoutInformation: NodeLayoutInformation = VariableInfo.layoutInformation

private var _varType: String = null
def varType(): String = _varType

private var _evaluationType: String = null
def evaluationType(): String = _evaluationType

private var _parameterIndex: Option[Integer] = None
def parameterIndex(): Option[Integer] = _parameterIndex


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (varType != null) { properties.put("VAR_TYPE", varType) }
if (evaluationType != null) { properties.put("EVALUATION_TYPE", evaluationType) }
parameterIndex.map { value => properties.put("PARAMETER_INDEX", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    VariableInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
    }

  override def productPrefix = "VariableInfo"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[VariableInfoDb]

  override def property(key:String): AnyRef = {
    key match {
      case "VAR_TYPE" => this._varType
      case "EVALUATION_TYPE" => this._evaluationType
      case "PARAMETER_INDEX" => this._parameterIndex.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "VAR_TYPE" => this._varType = value.asInstanceOf[String]
      case "EVALUATION_TYPE" => this._evaluationType = value.asInstanceOf[String]
      case "PARAMETER_INDEX" => this._parameterIndex = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewVariableInfo]
   this._varType = other.varType
   this._evaluationType = other.evaluationType
   this._parameterIndex = other.parameterIndex


}

}
