package io.shiftleft.codepropertygraph.generated.edges

import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Set => JSet}
import java.util.{List => JList}
import overflowdb._
import scala.jdk.CollectionConverters._

object ContainsNode {
  val Label = "CONTAINS_NODE"

  object PropertyNames {
    val LocalName = "LOCAL_NAME" 
    val Index = "INDEX" 
    val all: Set[String] = Set(LocalName, Index)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val LocalName = new PropertyKey[String]("LOCAL_NAME") 
    val Index = new PropertyKey[Integer]("INDEX") 
  }

  val layoutInformation = new EdgeLayoutInformation(Label, PropertyNames.allAsJava)

  val factory = new EdgeFactory[ContainsNode] {
    override val forLabel = ContainsNode.Label

    override def createEdge(graph: Graph, outNode: NodeRef[NodeDb], inNode: NodeRef[NodeDb]) =
      new ContainsNode(graph, outNode, inNode)
  }
}

class ContainsNode(_graph: Graph, _outNode: NodeRef[NodeDb], _inNode: NodeRef[NodeDb])
extends Edge(_graph, ContainsNode.Label, _outNode, _inNode, ContainsNode.PropertyNames.allAsJava) {
def localName: Option[String] = Option(property("LOCAL_NAME")).asInstanceOf[Option[String]]

def index: Option[Integer] = Option(property("INDEX")).asInstanceOf[Option[Integer]]
}

