package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Annotation {
  def apply(graph: Graph, id: Long) = new Annotation(graph, id)

  val Label = "ANNOTATION"
  val LabelId: Int = 5

  object PropertyNames {
    val Code = "CODE" 
    val Name = "NAME" 
    val FullName = "FULL_NAME" 
    val Order = "ORDER" 
    val all: Set[String] = Set(Code, Name, FullName, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Code = new PropertyKey[String]("CODE") 
    val Name = new PropertyKey[String]("NAME") 
    val FullName = new PropertyKey[String]("FULL_NAME") 
    val Order = new PropertyKey[Integer]("ORDER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationDb] {
    override val forLabel = Annotation.Label
    override val forLabelId = Annotation.LabelId

    override def createNode(ref: NodeRef[AnnotationDb]) =
      new AnnotationDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Annotation(graph, id)
  }
}

trait AnnotationBase extends CpgNode with AstNodeBase with HasCode with HasName with HasFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Annotation(graph: Graph, id: Long) extends NodeRef[AnnotationDb](graph, id)
  with AnnotationBase
  with StoredNode
  with AstNode {
    override def code: String = get().code
  override def name: String = get().name
  override def fullName: String = get().fullName
  override def order: Integer = get().order
  
  def _annotationParameterAssignViaAstOut: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
def _methodParameterInViaAstIn: Iterator[MethodParameterIn] = get()._methodParameterInViaAstIn
def _memberViaAstIn: Iterator[Member] = get()._memberViaAstIn
def _methodViaAstIn: Iterator[Method] = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _typeDeclViaAstIn: Iterator[TypeDecl] = get()._typeDeclViaAstIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Annotation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => name
case 3 => fullName
case 4 => order
    }

  override def productPrefix = "Annotation"
  override def productArity = 5
}

class AnnotationDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with AnnotationBase {

  override def layoutInformation: NodeLayoutInformation = Annotation.layoutInformation

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _annotationParameterAssignViaAstOut: Iterator[AnnotationParameterAssign] = _astOut.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _memberViaAstIn: Iterator[Member] = _astIn.asScala.collect { case node: Member => node }
def _typeDeclViaAstIn: Iterator[TypeDecl] = _astIn.asScala.collect { case node: TypeDecl => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Iterator[Method] = _astIn.asScala.collect { case node: Method => node }
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
def _methodParameterInViaAstIn: Iterator[MethodParameterIn] = _astIn.asScala.collect { case node: MethodParameterIn => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Annotation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => name
case 3 => fullName
case 4 => order
    }

  override def productPrefix = "Annotation"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationDb]

  override def property(key:String): AnyRef = {
    key match {
      case "CODE" => this._code
      case "NAME" => this._name
      case "FULL_NAME" => this._fullName
      case "ORDER" => this._order
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "CODE" => this._code = value.asInstanceOf[String]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewAnnotation]
   this._code = other.code
   this._name = other.name
   this._fullName = other.fullName
   this._order = other.order

  graph.indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}

/** Traversal steps for Annotation */
class AnnotationTraversal[NodeType <: Annotation](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to fullName property */
  def fullName: Traversal[String] =
    traversal.map(_.fullName)

    /**
    * Traverse to nodes where the fullName matches the regular expression `value`
    * */
  def fullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the fullName matches at least one of the regular expressions in `values`
    * */
  def fullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where fullName matches `value` exactly.
    * */
  def fullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME, value)

  /**
    * Traverse to nodes where fullName matches one of the elements in `values` exactly.
    * */
  def fullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where fullName does not match the regular expression `value`.
    * */
  def fullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where fullName does not match any of the regular expressions in `values`.
    * */
  def fullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))



}
