package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object AnnotationLiteral {
  def apply(graph: Graph, id: Long) = new AnnotationLiteral(graph, id)

  val Label = "ANNOTATION_LITERAL"
  val LabelId: Int = 49

  object PropertyNames {
    val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
    val InternalFlags = "INTERNAL_FLAGS" 
    val Code = "CODE" 
    val Name = "NAME" 
    val Order = "ORDER" 
    val ArgumentIndex = "ARGUMENT_INDEX" 
    val ColumnNumber = "COLUMN_NUMBER" 
    val LineNumber = "LINE_NUMBER" 
    val all: Set[String] = Set(DepthFirstOrder, InternalFlags, Code, Name, Order, ArgumentIndex, ColumnNumber, LineNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val DepthFirstOrder = new PropertyKey[Integer]("DEPTH_FIRST_ORDER") 
    val InternalFlags = new PropertyKey[Integer]("INTERNAL_FLAGS") 
    val Code = new PropertyKey[String]("CODE") 
    val Name = new PropertyKey[String]("NAME") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val ArgumentIndex = new PropertyKey[Integer]("ARGUMENT_INDEX") 
    val ColumnNumber = new PropertyKey[Integer]("COLUMN_NUMBER") 
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationLiteralDb] {
    override val forLabel = AnnotationLiteral.Label
    override val forLabelId = AnnotationLiteral.LabelId

    override def createNode(ref: NodeRef[AnnotationLiteralDb]) =
      new AnnotationLiteralDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = AnnotationLiteral(graph, id)
  }
}

trait AnnotationLiteralBase extends CpgNode with ExpressionBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasName with HasOrder with HasArgumentIndex with HasColumnNumber with HasLineNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class AnnotationLiteral(graph: Graph, id: Long) extends NodeRef[AnnotationLiteralDb](graph, id)
  with AnnotationLiteralBase
  with StoredNode
  with Expression {
    override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  override def code: String = get().code
  override def name: String = get().name
  override def order: Integer = get().order
  override def argumentIndex: Integer = get().argumentIndex
  override def columnNumber: Option[Integer] = get().columnNumber
  override def lineNumber: Option[Integer] = get().lineNumber
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationLiteral.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "order" 
case 6 => "argumentIndex" 
case 7 => "columnNumber" 
case 8 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => order
case 6 => argumentIndex
case 7 => columnNumber
case 8 => lineNumber
    }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 9
}

class AnnotationLiteralDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with Expression with AnnotationLiteralBase {

  override def layoutInformation: NodeLayoutInformation = AnnotationLiteral.layoutInformation

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    AnnotationLiteral.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "order" 
case 6 => "argumentIndex" 
case 7 => "columnNumber" 
case 8 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => order
case 6 => argumentIndex
case 7 => columnNumber
case 8 => lineNumber
    }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationLiteralDb]

  override def property(key:String): AnyRef = {
    key match {
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
      case "INTERNAL_FLAGS" => this._internalFlags.orNull
      case "CODE" => this._code
      case "NAME" => this._name
      case "ORDER" => this._order
      case "ARGUMENT_INDEX" => this._argumentIndex
      case "COLUMN_NUMBER" => this._columnNumber.orNull
      case "LINE_NUMBER" => this._lineNumber.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "INTERNAL_FLAGS" => this._internalFlags = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "CODE" => this._code = value.asInstanceOf[String]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
      case "COLUMN_NUMBER" => this._columnNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewAnnotationLiteral]
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags
   this._code = other.code
   this._name = other.name
   this._order = other.order
   this._argumentIndex = other.argumentIndex
   this._columnNumber = other.columnNumber
   this._lineNumber = other.lineNumber


}

}

/** Traversal steps for AnnotationLiteral */
class AnnotationLiteralTraversal[NodeType <: AnnotationLiteral](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to depthFirstOrder property */
  def depthFirstOrder: Traversal[Integer] =
    traversal.flatMap(_.depthFirstOrder)

    /**
    * Traverse to nodes where the depthFirstOrder equals the given `value`
    * */
  def depthFirstOrder(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER, value)

  /**
    * Traverse to nodes where the depthFirstOrder equals at least one of the given `values`
    * */
  def depthFirstOrder(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the depthFirstOrder is greater than the given `value`
    * */
  def depthFirstOrderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ > value))

  /**
    * Traverse to nodes where the depthFirstOrder is greater than or equal the given `value`
    * */
  def depthFirstOrderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the depthFirstOrder is less than the given `value`
    * */
  def depthFirstOrderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ < value))

  /**
    * Traverse to nodes where the depthFirstOrder is less than or equal the given `value`
    * */
  def depthFirstOrderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ <= value))

  /**
    * Traverse to nodes where depthFirstOrder is not equal to the given `value`.
    * */
  def depthFirstOrderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.DEPTH_FIRST_ORDER, value)

  /**
    * Traverse to nodes where depthFirstOrder is not equal to any of the given `values`.
    * */
  def depthFirstOrderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.DEPTH_FIRST_ORDER.where(P.within(values.toSet)))


  /** Traverse to internalFlags property */
  def internalFlags: Traversal[Integer] =
    traversal.flatMap(_.internalFlags)

    /**
    * Traverse to nodes where the internalFlags equals the given `value`
    * */
  def internalFlags(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS, value)

  /**
    * Traverse to nodes where the internalFlags equals at least one of the given `values`
    * */
  def internalFlags(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the internalFlags is greater than the given `value`
    * */
  def internalFlagsGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ > value))

  /**
    * Traverse to nodes where the internalFlags is greater than or equal the given `value`
    * */
  def internalFlagsGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ >= value))

  /**
    * Traverse to nodes where the internalFlags is less than the given `value`
    * */
  def internalFlagsLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ < value))

  /**
    * Traverse to nodes where the internalFlags is less than or equal the given `value`
    * */
  def internalFlagsLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ <= value))

  /**
    * Traverse to nodes where internalFlags is not equal to the given `value`.
    * */
  def internalFlagsNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.INTERNAL_FLAGS, value)

  /**
    * Traverse to nodes where internalFlags is not equal to any of the given `values`.
    * */
  def internalFlagsNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.INTERNAL_FLAGS.where(P.within(values.toSet)))


  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))


  /** Traverse to argumentIndex property */
  def argumentIndex: Traversal[Integer] =
    traversal.map(_.argumentIndex)

    /**
    * Traverse to nodes where the argumentIndex equals the given `value`
    * */
  def argumentIndex(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX, value)

  /**
    * Traverse to nodes where the argumentIndex equals at least one of the given `values`
    * */
  def argumentIndex(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the argumentIndex is greater than the given `value`
    * */
  def argumentIndexGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ > value))

  /**
    * Traverse to nodes where the argumentIndex is greater than or equal the given `value`
    * */
  def argumentIndexGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ >= value))

  /**
    * Traverse to nodes where the argumentIndex is less than the given `value`
    * */
  def argumentIndexLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ < value))

  /**
    * Traverse to nodes where the argumentIndex is less than or equal the given `value`
    * */
  def argumentIndexLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ <= value))

  /**
    * Traverse to nodes where argumentIndex is not equal to the given `value`.
    * */
  def argumentIndexNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ARGUMENT_INDEX, value)

  /**
    * Traverse to nodes where argumentIndex is not equal to any of the given `values`.
    * */
  def argumentIndexNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ARGUMENT_INDEX.where(P.within(values.toSet)))


  /** Traverse to columnNumber property */
  def columnNumber: Traversal[Integer] =
    traversal.flatMap(_.columnNumber)

    /**
    * Traverse to nodes where the columnNumber equals the given `value`
    * */
  def columnNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where the columnNumber equals at least one of the given `values`
    * */
  def columnNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the columnNumber is greater than the given `value`
    * */
  def columnNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the columnNumber is greater than or equal the given `value`
    * */
  def columnNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the columnNumber is less than the given `value`
    * */
  def columnNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the columnNumber is less than or equal the given `value`
    * */
  def columnNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where columnNumber is not equal to the given `value`.
    * */
  def columnNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where columnNumber is not equal to any of the given `values`.
    * */
  def columnNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))


  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

    /**
    * Traverse to nodes where the lineNumber equals the given `value`
    * */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where the lineNumber equals at least one of the given `values`
    * */
  def lineNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the lineNumber is greater than the given `value`
    * */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the lineNumber is greater than or equal the given `value`
    * */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the lineNumber is less than the given `value`
    * */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the lineNumber is less than or equal the given `value`
    * */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where lineNumber is not equal to the given `value`.
    * */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where lineNumber is not equal to any of the given `values`.
    * */
  def lineNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))



}
