package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object AnnotationParameterAssign {
  def apply(graph: Graph, id: Long) = new AnnotationParameterAssign(graph, id)

  val Label = "ANNOTATION_PARAMETER_ASSIGN"
  val LabelId: Int = 6

  object PropertyNames {
    val Code = "CODE" 
    val Order = "ORDER" 
    val all: Set[String] = Set(Code, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Code = new PropertyKey[String]("CODE") 
    val Order = new PropertyKey[Integer]("ORDER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationParameterAssignDb] {
    override val forLabel = AnnotationParameterAssign.Label
    override val forLabelId = AnnotationParameterAssign.LabelId

    override def createNode(ref: NodeRef[AnnotationParameterAssignDb]) =
      new AnnotationParameterAssignDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = AnnotationParameterAssign(graph, id)
  }
}

trait AnnotationParameterAssignBase extends CpgNode with AstNodeBase with HasCode with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class AnnotationParameterAssign(graph: Graph, id: Long) extends NodeRef[AnnotationParameterAssignDb](graph, id)
  with AnnotationParameterAssignBase
  with StoredNode
  with AstNode {
    override def code: String = get().code
  override def order: Integer = get().order
  
  override def _astOut(): JIterator[StoredNode] = get()._astOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
def _arrayInitializerViaAstOut: Iterator[ArrayInitializer] = get()._arrayInitializerViaAstOut
def _annotationParameterViaAstOut: Iterator[AnnotationParameter] = get()._annotationParameterViaAstOut
def _annotationLiteralViaAstOut: Iterator[AnnotationLiteral] = get()._annotationLiteralViaAstOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationViaAstIn: Iterator[Annotation] = get()._annotationViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationParameterAssign.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => order
    }

  override def productPrefix = "AnnotationParameterAssign"
  override def productArity = 3
}

class AnnotationParameterAssignDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with AnnotationParameterAssignBase {

  override def layoutInformation: NodeLayoutInformation = AnnotationParameterAssign.layoutInformation

private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _annotationParameterViaAstOut: Iterator[AnnotationParameter] = _astOut.asScala.collect { case node: AnnotationParameter => node }
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
def _annotationLiteralViaAstOut: Iterator[AnnotationLiteral] = _astOut.asScala.collect { case node: AnnotationLiteral => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _arrayInitializerViaAstOut: Iterator[ArrayInitializer] = _astOut.asScala.collect { case node: ArrayInitializer => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _annotationViaAstIn: Iterator[Annotation] = _astIn.asScala.collect { case node: Annotation => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    AnnotationParameterAssign.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => order
    }

  override def productPrefix = "AnnotationParameterAssign"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationParameterAssignDb]

  override def property(key:String): AnyRef = {
    key match {
      case "CODE" => this._code
      case "ORDER" => this._order
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "CODE" => this._code = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewAnnotationParameterAssign]
   this._code = other.code
   this._order = other.order


}

}

/** Traversal steps for AnnotationParameterAssign */
class AnnotationParameterAssignTraversal[NodeType <: AnnotationParameterAssign](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))



}
