package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.NodeKeys
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal

trait CallReprBase extends CpgNode 
with HasCode with HasName with HasSignature 
with CfgNodeBase

trait CallRepr extends StoredNode with CallReprBase 
with CfgNode


/** Traversal steps for CallRepr */
class CallReprTraversal[NodeType <: CallRepr](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to signature property */
  def signature: Traversal[String] =
    traversal.map(_.signature)

    /**
    * Traverse to nodes where the signature matches the regular expression `value`
    * */
  def signature(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the signature matches at least one of the regular expressions in `values`
    * */
  def signature(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where signature matches `value` exactly.
    * */
  def signatureExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE, value)

  /**
    * Traverse to nodes where signature matches one of the elements in `values` exactly.
    * */
  def signatureExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where signature does not match the regular expression `value`.
    * */
  def signatureNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SIGNATURE.where(P.matches(regex)))

  /**
    * Traverse to nodes where signature does not match any of the regular expressions in `values`.
    * */
  def signatureNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SIGNATURE.where(P.within(values.to(Set))))




}

