package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.NodeKeys
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal

trait CfgNodeBase extends CpgNode 
with HasLineNumber with HasColumnNumber with HasInternalFlags with HasCode 
with WithinMethodBase with AstNodeBase

trait CfgNode extends StoredNode with CfgNodeBase 
with WithinMethod with AstNode


/** Traversal steps for CfgNode */
class CfgNodeTraversal[NodeType <: CfgNode](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

    /**
    * Traverse to nodes where the lineNumber equals the given `value`
    * */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where the lineNumber equals at least one of the given `values`
    * */
  def lineNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the lineNumber is greater than the given `value`
    * */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the lineNumber is greater than or equal the given `value`
    * */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the lineNumber is less than the given `value`
    * */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the lineNumber is less than or equal the given `value`
    * */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where lineNumber is not equal to the given `value`.
    * */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where lineNumber is not equal to any of the given `values`.
    * */
  def lineNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))


  /** Traverse to columnNumber property */
  def columnNumber: Traversal[Integer] =
    traversal.flatMap(_.columnNumber)

    /**
    * Traverse to nodes where the columnNumber equals the given `value`
    * */
  def columnNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where the columnNumber equals at least one of the given `values`
    * */
  def columnNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the columnNumber is greater than the given `value`
    * */
  def columnNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the columnNumber is greater than or equal the given `value`
    * */
  def columnNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the columnNumber is less than the given `value`
    * */
  def columnNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the columnNumber is less than or equal the given `value`
    * */
  def columnNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where columnNumber is not equal to the given `value`.
    * */
  def columnNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where columnNumber is not equal to any of the given `values`.
    * */
  def columnNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))


  /** Traverse to internalFlags property */
  def internalFlags: Traversal[Integer] =
    traversal.flatMap(_.internalFlags)

    /**
    * Traverse to nodes where the internalFlags equals the given `value`
    * */
  def internalFlags(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS, value)

  /**
    * Traverse to nodes where the internalFlags equals at least one of the given `values`
    * */
  def internalFlags(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the internalFlags is greater than the given `value`
    * */
  def internalFlagsGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ > value))

  /**
    * Traverse to nodes where the internalFlags is greater than or equal the given `value`
    * */
  def internalFlagsGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ >= value))

  /**
    * Traverse to nodes where the internalFlags is less than the given `value`
    * */
  def internalFlagsLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ < value))

  /**
    * Traverse to nodes where the internalFlags is less than or equal the given `value`
    * */
  def internalFlagsLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ <= value))

  /**
    * Traverse to nodes where internalFlags is not equal to the given `value`.
    * */
  def internalFlagsNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.INTERNAL_FLAGS, value)

  /**
    * Traverse to nodes where internalFlags is not equal to any of the given `values`.
    * */
  def internalFlagsNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.INTERNAL_FLAGS.where(P.within(values.toSet)))


  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))




}

