package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object ClosureBinding {
  def apply(graph: Graph, id: Long) = new ClosureBinding(graph, id)

  val Label = "CLOSURE_BINDING"
  val LabelId: Int = 334

  object PropertyNames {
    val ClosureBindingId = "CLOSURE_BINDING_ID" 
    val EvaluationStrategy = "EVALUATION_STRATEGY" 
    val ClosureOriginalName = "CLOSURE_ORIGINAL_NAME" 
    val all: Set[String] = Set(ClosureBindingId, EvaluationStrategy, ClosureOriginalName)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val ClosureBindingId = new PropertyKey[String]("CLOSURE_BINDING_ID") 
    val EvaluationStrategy = new PropertyKey[String]("EVALUATION_STRATEGY") 
    val ClosureOriginalName = new PropertyKey[String]("CLOSURE_ORIGINAL_NAME") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Capture.layoutInformation, edges.CapturedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CAPTURE","CAPTURED_BY","CONTAINS_NODE")
    val Out: Array[String] = Array("REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ClosureBindingDb] {
    override val forLabel = ClosureBinding.Label
    override val forLabelId = ClosureBinding.LabelId

    override def createNode(ref: NodeRef[ClosureBindingDb]) =
      new ClosureBindingDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = ClosureBinding(graph, id)
  }
}

trait ClosureBindingBase extends CpgNode  with HasClosureBindingId with HasEvaluationStrategy with HasClosureOriginalName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ClosureBinding(graph: Graph, id: Long) extends NodeRef[ClosureBindingDb](graph, id)
  with ClosureBindingBase
  with StoredNode
   {
    override def closureBindingId: Option[String] = get().closureBindingId
  override def evaluationStrategy: String = get().evaluationStrategy
  override def closureOriginalName: Option[String] = get().closureOriginalName
  
  def _localViaRefOut: Local = get()._localViaRefOut
def _methodParameterInViaRefOut: Iterator[MethodParameterIn] = get()._methodParameterInViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeRefViaCaptureIn: Iterator[TypeRef] = get()._typeRefViaCaptureIn
def _methodRefViaCaptureIn: Iterator[MethodRef] = get()._methodRefViaCaptureIn
override def _captureIn(): JIterator[StoredNode] = get()._captureIn
def _localViaCapturedByIn: Iterator[Local] = get()._localViaCapturedByIn
override def _capturedByIn(): JIterator[StoredNode] = get()._capturedByIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ClosureBinding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "closureBindingId" 
case 2 => "evaluationStrategy" 
case 3 => "closureOriginalName" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => closureBindingId
case 2 => evaluationStrategy
case 3 => closureOriginalName
    }

  override def productPrefix = "ClosureBinding"
  override def productArity = 4
}

class ClosureBindingDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with ClosureBindingBase {

  override def layoutInformation: NodeLayoutInformation = ClosureBinding.layoutInformation

private var _closureBindingId: Option[String] = None
def closureBindingId(): Option[String] = _closureBindingId

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _closureOriginalName: Option[String] = None
def closureOriginalName(): Option[String] = _closureOriginalName


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
closureOriginalName.map { value => properties.put("CLOSURE_ORIGINAL_NAME", value) }

  properties
}

  def _localViaRefOut: Local = _refOut.asScala.collect { case node: Local => node }.next
def _methodParameterInViaRefOut: Iterator[MethodParameterIn] = _refOut.asScala.collect { case node: MethodParameterIn => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _typeRefViaCaptureIn: Iterator[TypeRef] = _captureIn.asScala.collect { case node: TypeRef => node }
def _methodRefViaCaptureIn: Iterator[MethodRef] = _captureIn.asScala.collect { case node: MethodRef => node }
override def _captureIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _localViaCapturedByIn: Iterator[Local] = _capturedByIn.asScala.collect { case node: Local => node }
override def _capturedByIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ClosureBinding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "closureBindingId" 
case 2 => "evaluationStrategy" 
case 3 => "closureOriginalName" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => closureBindingId
case 2 => evaluationStrategy
case 3 => closureOriginalName
    }

  override def productPrefix = "ClosureBinding"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ClosureBindingDb]

  override def property(key:String): AnyRef = {
    key match {
      case "CLOSURE_BINDING_ID" => this._closureBindingId.orNull
      case "EVALUATION_STRATEGY" => this._evaluationStrategy
      case "CLOSURE_ORIGINAL_NAME" => this._closureOriginalName.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "CLOSURE_BINDING_ID" => this._closureBindingId = value match {
        case null | None => None
        case someVal: String => Some(someVal)
      }
      case "EVALUATION_STRATEGY" => this._evaluationStrategy = value.asInstanceOf[String]
      case "CLOSURE_ORIGINAL_NAME" => this._closureOriginalName = value match {
        case null | None => None
        case someVal: String => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewClosureBinding]
   this._closureBindingId = other.closureBindingId
   this._evaluationStrategy = other.evaluationStrategy
   this._closureOriginalName = other.closureOriginalName


}

}

/** Traversal steps for ClosureBinding */
class ClosureBindingTraversal[NodeType <: ClosureBinding](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to closureBindingId property */
  def closureBindingId: Traversal[String] =
    traversal.flatMap(_.closureBindingId)

    /**
    * Traverse to nodes where the closureBindingId matches the regular expression `value`
    * */
  def closureBindingId(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_BINDING_ID.where(P.matches(regex)))

  /**
    * Traverse to nodes where the closureBindingId matches at least one of the regular expressions in `values`
    * */
  def closureBindingId(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_BINDING_ID.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where closureBindingId matches `value` exactly.
    * */
  def closureBindingIdExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_BINDING_ID, value)

  /**
    * Traverse to nodes where closureBindingId matches one of the elements in `values` exactly.
    * */
  def closureBindingIdExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_BINDING_ID.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where closureBindingId does not match the regular expression `value`.
    * */
  def closureBindingIdNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLOSURE_BINDING_ID.where(P.matches(regex)))

  /**
    * Traverse to nodes where closureBindingId does not match any of the regular expressions in `values`.
    * */
  def closureBindingIdNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLOSURE_BINDING_ID.where(P.within(values.to(Set))))



  /** Traverse to evaluationStrategy property */
  def evaluationStrategy: Traversal[String] =
    traversal.map(_.evaluationStrategy)

    /**
    * Traverse to nodes where the evaluationStrategy matches the regular expression `value`
    * */
  def evaluationStrategy(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regex)))

  /**
    * Traverse to nodes where the evaluationStrategy matches at least one of the regular expressions in `values`
    * */
  def evaluationStrategy(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where evaluationStrategy matches `value` exactly.
    * */
  def evaluationStrategyExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY, value)

  /**
    * Traverse to nodes where evaluationStrategy matches one of the elements in `values` exactly.
    * */
  def evaluationStrategyExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where evaluationStrategy does not match the regular expression `value`.
    * */
  def evaluationStrategyNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regex)))

  /**
    * Traverse to nodes where evaluationStrategy does not match any of the regular expressions in `values`.
    * */
  def evaluationStrategyNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVALUATION_STRATEGY.where(P.within(values.to(Set))))



  /** Traverse to closureOriginalName property */
  def closureOriginalName: Traversal[String] =
    traversal.flatMap(_.closureOriginalName)

    /**
    * Traverse to nodes where the closureOriginalName matches the regular expression `value`
    * */
  def closureOriginalName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_ORIGINAL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the closureOriginalName matches at least one of the regular expressions in `values`
    * */
  def closureOriginalName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_ORIGINAL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where closureOriginalName matches `value` exactly.
    * */
  def closureOriginalNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_ORIGINAL_NAME, value)

  /**
    * Traverse to nodes where closureOriginalName matches one of the elements in `values` exactly.
    * */
  def closureOriginalNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLOSURE_ORIGINAL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where closureOriginalName does not match the regular expression `value`.
    * */
  def closureOriginalNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLOSURE_ORIGINAL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where closureOriginalName does not match any of the regular expressions in `values`.
    * */
  def closureOriginalNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLOSURE_ORIGINAL_NAME.where(P.within(values.to(Set))))




}
