package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.NodeKeys
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal

trait ExpressionBase extends CpgNode 
with HasCode with HasOrder with HasArgumentIndex 
with TrackingPointBase with CfgNodeBase with AstNodeBase

trait Expression extends StoredNode with ExpressionBase 
with TrackingPoint with CfgNode with AstNode


/** Traversal steps for Expression */
class ExpressionTraversal[NodeType <: Expression](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))


  /** Traverse to argumentIndex property */
  def argumentIndex: Traversal[Integer] =
    traversal.map(_.argumentIndex)

    /**
    * Traverse to nodes where the argumentIndex equals the given `value`
    * */
  def argumentIndex(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX, value)

  /**
    * Traverse to nodes where the argumentIndex equals at least one of the given `values`
    * */
  def argumentIndex(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the argumentIndex is greater than the given `value`
    * */
  def argumentIndexGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ > value))

  /**
    * Traverse to nodes where the argumentIndex is greater than or equal the given `value`
    * */
  def argumentIndexGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ >= value))

  /**
    * Traverse to nodes where the argumentIndex is less than the given `value`
    * */
  def argumentIndexLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ < value))

  /**
    * Traverse to nodes where the argumentIndex is less than or equal the given `value`
    * */
  def argumentIndexLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ <= value))

  /**
    * Traverse to nodes where argumentIndex is not equal to the given `value`.
    * */
  def argumentIndexNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ARGUMENT_INDEX, value)

  /**
    * Traverse to nodes where argumentIndex is not equal to any of the given `values`.
    * */
  def argumentIndexNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ARGUMENT_INDEX.where(P.within(values.toSet)))



}

