package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Flow {
  def apply(graph: Graph, id: Long) = new Flow(graph, id)

  val Label = "FLOW"
  val LabelId: Int = 207

  object PropertyNames {
    val Points = "points" 
    val Source = "source" 
    val Sink = "sink" 
    val Transformations = "transformations" 
    val Branchpoints = "branchPoints" 
    val Cfgnodes = "cfgNodes" 
    val all: Set[String] = Set(Points, Source, Sink, Transformations, Branchpoints, Cfgnodes)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    
    val Points = new PropertyKey[Seq[ProgramPoint]]("points") 
    val Source = new PropertyKey[Source]("source") 
    val Sink = new PropertyKey[Sink]("sink") 
    val Transformations = new PropertyKey[Seq[Transformation]]("transformations") 
    val Branchpoints = new PropertyKey[Seq[TrackingPoint]]("branchPoints") 
    val Cfgnodes = new PropertyKey[Seq[CfgNode]]("cfgNodes") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[FlowDb] {
    override val forLabel = Flow.Label
    override val forLabelId = Flow.LabelId

    override def createNode(ref: NodeRef[FlowDb]) =
      new FlowDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Flow(graph, id)
  }
}

trait FlowBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def points: List[ProgramPointBase]
def source: SourceBase
def sink: SinkBase
def transformations: List[TransformationBase]
def branchPoints: List[TrackingPointBase]
def cfgNodes: List[CfgNodeBase]
}

class Flow(graph: Graph, id: Long) extends NodeRef[FlowDb](graph, id)
  with FlowBase
  with StoredNode
   {
  
    def points = get().points
  def source = get().source
  def sink = get().sink
  def transformations = get().transformations
  def branchPoints = get().branchPoints
  def cfgNodes = get().cfgNodes
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = get()._cfgNodeViaContainsNodeOut
def _transformationViaContainsNodeOut: Iterator[Transformation] = get()._transformationViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _programPointViaContainsNodeOut: Iterator[ProgramPoint] = get()._programPointViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _writeViaContainsNodeIn: Iterator[Write] = get()._writeViaContainsNodeIn
def _readViaContainsNodeIn: Iterator[Read] = get()._readViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Flow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "points" 
case 2 => "source" 
case 3 => "sink" 
case 4 => "transformations" 
case 5 => "branchPoints" 
case 6 => "cfgNodes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => points
case 2 => source
case 3 => sink
case 4 => transformations
case 5 => branchPoints
case 6 => cfgNodes
    }

  override def productPrefix = "Flow"
  override def productArity = 7
}

class FlowDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with FlowBase {

  override def layoutInformation: NodeLayoutInformation = Flow.layoutInformation



private var _points: List[ProgramPoint] = Nil
def points: List[ProgramPoint] = this._points


private var _source: Source = null
def source: Source = this._source


private var _sink: Sink = null
def sink: Sink = this._sink


private var _transformations: List[Transformation] = Nil
def transformations: List[Transformation] = this._transformations


private var _branchPoints: List[TrackingPoint] = Nil
def branchPoints: List[TrackingPoint] = this._branchPoints


private var _cfgNodes: List[CfgNode] = Nil
def cfgNodes: List[CfgNode] = this._cfgNodes


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._points.nonEmpty) { properties.put("points", this._points.asJava) }
   if (this._source != null) { properties.put("source", this._source) }
   if (this._sink != null) { properties.put("sink", this._sink) }
  if (this._transformations.nonEmpty) { properties.put("transformations", this._transformations.asJava) }
  if (this._branchPoints.nonEmpty) { properties.put("branchPoints", this._branchPoints.asJava) }
  if (this._cfgNodes.nonEmpty) { properties.put("cfgNodes", this._cfgNodes.asJava) }
  properties
}

  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = _containsNodeOut.asScala.collect { case node: CfgNode => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _transformationViaContainsNodeOut: Iterator[Transformation] = _containsNodeOut.asScala.collect { case node: Transformation => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
def _programPointViaContainsNodeOut: Iterator[ProgramPoint] = _containsNodeOut.asScala.collect { case node: ProgramPoint => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _writeViaContainsNodeIn: Iterator[Write] = _containsNodeIn.asScala.collect { case node: Write => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _readViaContainsNodeIn: Iterator[Read] = _containsNodeIn.asScala.collect { case node: Read => node }

  override def label: String = {
    Flow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "points" 
case 2 => "source" 
case 3 => "sink" 
case 4 => "transformations" 
case 5 => "branchPoints" 
case 6 => "cfgNodes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => points
case 2 => source
case 3 => sink
case 4 => transformations
case 5 => branchPoints
case 6 => cfgNodes
    }

  override def productPrefix = "Flow"
  override def productArity = 7

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FlowDb]

  override def property(key:String): AnyRef = {
    key match {
      
      case "points" => this._points
      case "source" => this._source
      case "sink" => this._sink
      case "transformations" => this._transformations
      case "branchPoints" => this._branchPoints
      case "cfgNodes" => this._cfgNodes
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
    
      case "points" => this._points = value match {
        case singleValue: ProgramPoint => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[ProgramPoint]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[ProgramPoint]]
      }
      case "source" => this._source = value.asInstanceOf[Source]
      case "sink" => this._sink = value.asInstanceOf[Sink]
      case "transformations" => this._transformations = value match {
        case singleValue: Transformation => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Transformation]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Transformation]]
      }
      case "branchPoints" => this._branchPoints = value match {
        case singleValue: TrackingPoint => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[TrackingPoint]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[TrackingPoint]]
      }
      case "cfgNodes" => this._cfgNodes = value match {
        case singleValue: CfgNode => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CfgNode]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[CfgNode]]
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewFlow]

  this._points = if(other.points == null) Nil else other.points.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[ProgramPoint]
    case oldNode:StoredNode => oldNode.asInstanceOf[ProgramPoint]
    case _ => throw new MatchError("unreachable")
  }}
  this._source = other.source match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Source]
    case oldNode: StoredNode => oldNode.asInstanceOf[Source]
    case _ => throw new MatchError("unreachable")
  }
  this._sink = other.sink match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Sink]
    case oldNode: StoredNode => oldNode.asInstanceOf[Sink]
    case _ => throw new MatchError("unreachable")
  }
  this._transformations = if(other.transformations == null) Nil else other.transformations.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Transformation]
    case oldNode:StoredNode => oldNode.asInstanceOf[Transformation]
    case _ => throw new MatchError("unreachable")
  }}
  this._branchPoints = if(other.branchPoints == null) Nil else other.branchPoints.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode:StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }}
  this._cfgNodes = if(other.cfgNodes == null) Nil else other.cfgNodes.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CfgNode]
    case oldNode:StoredNode => oldNode.asInstanceOf[CfgNode]
    case _ => throw new MatchError("unreachable")
  }}

}

}

/** Traversal steps for Flow */
class FlowTraversal[NodeType <: Flow](val traversal: Traversal[NodeType]) extends AnyVal {



}
