package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Ioflow {
  def apply(graph: Graph, id: Long) = new Ioflow(graph, id)

  val Label = "IOFLOW"
  val LabelId: Int = 212

  object PropertyNames {
    val Fingerprint = "FINGERPRINT" 
    val LiteralsToSink = "LITERALS_TO_SINK" 
    val Datatags = "dataTags" 
    val Sourcedescriptortags = "sourceDescriptorTags" 
    val Sinkdescriptortags = "sinkDescriptorTags" 
    val Sourcetags = "sourceTags" 
    val Dsttags = "dstTags" 
    val Source = "source" 
    val Sink = "sink" 
    val Transforms = "transforms" 
    val Sourcedescriptorflows = "sourceDescriptorFlows" 
    val Sinkdescriptorflows = "sinkDescriptorFlows" 
    val Primaryflow = "primaryFlow" 
    val Triggermethods = "triggerMethods" 
    val all: Set[String] = Set(Fingerprint, LiteralsToSink, Datatags, Sourcedescriptortags, Sinkdescriptortags, Sourcetags, Dsttags, Source, Sink, Transforms, Sourcedescriptorflows, Sinkdescriptorflows, Primaryflow, Triggermethods)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Fingerprint = new PropertyKey[String]("FINGERPRINT") 
    val LiteralsToSink = new PropertyKey[Seq[String]]("LITERALS_TO_SINK") 
    val Datatags = new PropertyKey[Seq[Tag]]("dataTags") 
    val Sourcedescriptortags = new PropertyKey[Seq[Tag]]("sourceDescriptorTags") 
    val Sinkdescriptortags = new PropertyKey[Seq[Tag]]("sinkDescriptorTags") 
    val Sourcetags = new PropertyKey[Seq[Tag]]("sourceTags") 
    val Dsttags = new PropertyKey[Seq[Tag]]("dstTags") 
    val Source = new PropertyKey[Source]("source") 
    val Sink = new PropertyKey[Sink]("sink") 
    val Transforms = new PropertyKey[Seq[Transform]]("transforms") 
    val Sourcedescriptorflows = new PropertyKey[Seq[Flow]]("sourceDescriptorFlows") 
    val Sinkdescriptorflows = new PropertyKey[Seq[Flow]]("sinkDescriptorFlows") 
    val Primaryflow = new PropertyKey[Flow]("primaryFlow") 
    val Triggermethods = new PropertyKey[Seq[Method]]("triggerMethods") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[IoflowDb] {
    override val forLabel = Ioflow.Label
    override val forLabelId = Ioflow.LabelId

    override def createNode(ref: NodeRef[IoflowDb]) =
      new IoflowDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Ioflow(graph, id)
  }
}

trait IoflowBase extends CpgNode  with HasFingerprint with HasLiteralsToSink {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def dataTags: List[TagBase]
def sourceDescriptorTags: List[TagBase]
def sinkDescriptorTags: List[TagBase]
def sourceTags: List[TagBase]
def dstTags: List[TagBase]
def source: SourceBase
def sink: SinkBase
def transforms: List[TransformBase]
def sourceDescriptorFlows: List[FlowBase]
def sinkDescriptorFlows: List[FlowBase]
def primaryFlow: FlowBase
def triggerMethods: List[MethodBase]
}

class Ioflow(graph: Graph, id: Long) extends NodeRef[IoflowDb](graph, id)
  with IoflowBase
  with StoredNode
   {
    override def fingerprint: String = get().fingerprint
  override def literalsToSink: List[String] = get().literalsToSink
    def dataTags = get().dataTags
  def sourceDescriptorTags = get().sourceDescriptorTags
  def sinkDescriptorTags = get().sinkDescriptorTags
  def sourceTags = get().sourceTags
  def dstTags = get().dstTags
  def source = get().source
  def sink = get().sink
  def transforms = get().transforms
  def sourceDescriptorFlows = get().sourceDescriptorFlows
  def sinkDescriptorFlows = get().sinkDescriptorFlows
  def primaryFlow = get().primaryFlow
  def triggerMethods = get().triggerMethods
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _transformViaContainsNodeOut: Iterator[Transform] = get()._transformViaContainsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _sensitiveReferenceViaContainsNodeIn: Iterator[SensitiveReference] = get()._sensitiveReferenceViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Ioflow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fingerprint" 
case 2 => "literalsToSink" 
case 3 => "dataTags" 
case 4 => "sourceDescriptorTags" 
case 5 => "sinkDescriptorTags" 
case 6 => "sourceTags" 
case 7 => "dstTags" 
case 8 => "source" 
case 9 => "sink" 
case 10 => "transforms" 
case 11 => "sourceDescriptorFlows" 
case 12 => "sinkDescriptorFlows" 
case 13 => "primaryFlow" 
case 14 => "triggerMethods" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => fingerprint
case 2 => literalsToSink
case 3 => dataTags
case 4 => sourceDescriptorTags
case 5 => sinkDescriptorTags
case 6 => sourceTags
case 7 => dstTags
case 8 => source
case 9 => sink
case 10 => transforms
case 11 => sourceDescriptorFlows
case 12 => sinkDescriptorFlows
case 13 => primaryFlow
case 14 => triggerMethods
    }

  override def productPrefix = "Ioflow"
  override def productArity = 15
}

class IoflowDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with IoflowBase {

  override def layoutInformation: NodeLayoutInformation = Ioflow.layoutInformation

private var _fingerprint: String = null
def fingerprint(): String = _fingerprint

private var _literalsToSink: List[String] = Nil
def literalsToSink(): List[String] = _literalsToSink

private var _dataTags: List[Tag] = Nil
def dataTags: List[Tag] = this._dataTags


private var _sourceDescriptorTags: List[Tag] = Nil
def sourceDescriptorTags: List[Tag] = this._sourceDescriptorTags


private var _sinkDescriptorTags: List[Tag] = Nil
def sinkDescriptorTags: List[Tag] = this._sinkDescriptorTags


private var _sourceTags: List[Tag] = Nil
def sourceTags: List[Tag] = this._sourceTags


private var _dstTags: List[Tag] = Nil
def dstTags: List[Tag] = this._dstTags


private var _source: Source = null
def source: Source = this._source


private var _sink: Sink = null
def sink: Sink = this._sink


private var _transforms: List[Transform] = Nil
def transforms: List[Transform] = this._transforms


private var _sourceDescriptorFlows: List[Flow] = Nil
def sourceDescriptorFlows: List[Flow] = this._sourceDescriptorFlows


private var _sinkDescriptorFlows: List[Flow] = Nil
def sinkDescriptorFlows: List[Flow] = this._sinkDescriptorFlows


private var _primaryFlow: Flow = null
def primaryFlow: Flow = this._primaryFlow


private var _triggerMethods: List[Method] = Nil
def triggerMethods: List[Method] = this._triggerMethods


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (fingerprint != null) { properties.put("FINGERPRINT", fingerprint) }
if (literalsToSink.nonEmpty) { properties.put("LITERALS_TO_SINK", literalsToSink.asJava) }
  if (this._dataTags.nonEmpty) { properties.put("dataTags", this._dataTags.asJava) }
  if (this._sourceDescriptorTags.nonEmpty) { properties.put("sourceDescriptorTags", this._sourceDescriptorTags.asJava) }
  if (this._sinkDescriptorTags.nonEmpty) { properties.put("sinkDescriptorTags", this._sinkDescriptorTags.asJava) }
  if (this._sourceTags.nonEmpty) { properties.put("sourceTags", this._sourceTags.asJava) }
  if (this._dstTags.nonEmpty) { properties.put("dstTags", this._dstTags.asJava) }
   if (this._source != null) { properties.put("source", this._source) }
   if (this._sink != null) { properties.put("sink", this._sink) }
  if (this._transforms.nonEmpty) { properties.put("transforms", this._transforms.asJava) }
  if (this._sourceDescriptorFlows.nonEmpty) { properties.put("sourceDescriptorFlows", this._sourceDescriptorFlows.asJava) }
  if (this._sinkDescriptorFlows.nonEmpty) { properties.put("sinkDescriptorFlows", this._sinkDescriptorFlows.asJava) }
   if (this._primaryFlow != null) { properties.put("primaryFlow", this._primaryFlow) }
  if (this._triggerMethods.nonEmpty) { properties.put("triggerMethods", this._triggerMethods.asJava) }
  properties
}

  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
def _transformViaContainsNodeOut: Iterator[Transform] = _containsNodeOut.asScala.collect { case node: Transform => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _sensitiveReferenceViaContainsNodeIn: Iterator[SensitiveReference] = _containsNodeIn.asScala.collect { case node: SensitiveReference => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Ioflow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fingerprint" 
case 2 => "literalsToSink" 
case 3 => "dataTags" 
case 4 => "sourceDescriptorTags" 
case 5 => "sinkDescriptorTags" 
case 6 => "sourceTags" 
case 7 => "dstTags" 
case 8 => "source" 
case 9 => "sink" 
case 10 => "transforms" 
case 11 => "sourceDescriptorFlows" 
case 12 => "sinkDescriptorFlows" 
case 13 => "primaryFlow" 
case 14 => "triggerMethods" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => fingerprint
case 2 => literalsToSink
case 3 => dataTags
case 4 => sourceDescriptorTags
case 5 => sinkDescriptorTags
case 6 => sourceTags
case 7 => dstTags
case 8 => source
case 9 => sink
case 10 => transforms
case 11 => sourceDescriptorFlows
case 12 => sinkDescriptorFlows
case 13 => primaryFlow
case 14 => triggerMethods
    }

  override def productPrefix = "Ioflow"
  override def productArity = 15

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[IoflowDb]

  override def property(key:String): AnyRef = {
    key match {
      case "FINGERPRINT" => this._fingerprint
      case "LITERALS_TO_SINK" => this._literalsToSink
      case "dataTags" => this._dataTags
      case "sourceDescriptorTags" => this._sourceDescriptorTags
      case "sinkDescriptorTags" => this._sinkDescriptorTags
      case "sourceTags" => this._sourceTags
      case "dstTags" => this._dstTags
      case "source" => this._source
      case "sink" => this._sink
      case "transforms" => this._transforms
      case "sourceDescriptorFlows" => this._sourceDescriptorFlows
      case "sinkDescriptorFlows" => this._sinkDescriptorFlows
      case "primaryFlow" => this._primaryFlow
      case "triggerMethods" => this._triggerMethods
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "FINGERPRINT" => this._fingerprint = value.asInstanceOf[String]
      case "LITERALS_TO_SINK" => this._literalsToSink = value match {
        case singleValue: String => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[String]]
      }
      case "dataTags" => this._dataTags = value match {
        case singleValue: Tag => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Tag]]
      }
      case "sourceDescriptorTags" => this._sourceDescriptorTags = value match {
        case singleValue: Tag => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Tag]]
      }
      case "sinkDescriptorTags" => this._sinkDescriptorTags = value match {
        case singleValue: Tag => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Tag]]
      }
      case "sourceTags" => this._sourceTags = value match {
        case singleValue: Tag => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Tag]]
      }
      case "dstTags" => this._dstTags = value match {
        case singleValue: Tag => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Tag]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Tag]]
      }
      case "source" => this._source = value.asInstanceOf[Source]
      case "sink" => this._sink = value.asInstanceOf[Sink]
      case "transforms" => this._transforms = value match {
        case singleValue: Transform => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Transform]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Transform]]
      }
      case "sourceDescriptorFlows" => this._sourceDescriptorFlows = value match {
        case singleValue: Flow => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Flow]]
      }
      case "sinkDescriptorFlows" => this._sinkDescriptorFlows = value match {
        case singleValue: Flow => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Flow]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Flow]]
      }
      case "primaryFlow" => this._primaryFlow = value.asInstanceOf[Flow]
      case "triggerMethods" => this._triggerMethods = value match {
        case singleValue: Method => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Method]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Method]]
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewIoflow]
   this._fingerprint = other.fingerprint
   this._literalsToSink = other.literalsToSink
  this._dataTags = if(other.dataTags == null) Nil else other.dataTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._sourceDescriptorTags = if(other.sourceDescriptorTags == null) Nil else other.sourceDescriptorTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._sinkDescriptorTags = if(other.sinkDescriptorTags == null) Nil else other.sinkDescriptorTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._sourceTags = if(other.sourceTags == null) Nil else other.sourceTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._dstTags = if(other.dstTags == null) Nil else other.dstTags.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Tag]
    case oldNode:StoredNode => oldNode.asInstanceOf[Tag]
    case _ => throw new MatchError("unreachable")
  }}
  this._source = other.source match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Source]
    case oldNode: StoredNode => oldNode.asInstanceOf[Source]
    case _ => throw new MatchError("unreachable")
  }
  this._sink = other.sink match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Sink]
    case oldNode: StoredNode => oldNode.asInstanceOf[Sink]
    case _ => throw new MatchError("unreachable")
  }
  this._transforms = if(other.transforms == null) Nil else other.transforms.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Transform]
    case oldNode:StoredNode => oldNode.asInstanceOf[Transform]
    case _ => throw new MatchError("unreachable")
  }}
  this._sourceDescriptorFlows = if(other.sourceDescriptorFlows == null) Nil else other.sourceDescriptorFlows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}
  this._sinkDescriptorFlows = if(other.sinkDescriptorFlows == null) Nil else other.sinkDescriptorFlows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }}
  this._primaryFlow = other.primaryFlow match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Flow]
    case oldNode: StoredNode => oldNode.asInstanceOf[Flow]
    case _ => throw new MatchError("unreachable")
  }
  this._triggerMethods = if(other.triggerMethods == null) Nil else other.triggerMethods.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode:StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }}

}

}

/** Traversal steps for Ioflow */
class IoflowTraversal[NodeType <: Ioflow](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to fingerprint property */
  def fingerprint: Traversal[String] =
    traversal.map(_.fingerprint)

    /**
    * Traverse to nodes where the fingerprint matches the regular expression `value`
    * */
  def fingerprint(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FINGERPRINT.where(P.matches(regex)))

  /**
    * Traverse to nodes where the fingerprint matches at least one of the regular expressions in `values`
    * */
  def fingerprint(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FINGERPRINT.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where fingerprint matches `value` exactly.
    * */
  def fingerprintExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FINGERPRINT, value)

  /**
    * Traverse to nodes where fingerprint matches one of the elements in `values` exactly.
    * */
  def fingerprintExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FINGERPRINT.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where fingerprint does not match the regular expression `value`.
    * */
  def fingerprintNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FINGERPRINT.where(P.matches(regex)))

  /**
    * Traverse to nodes where fingerprint does not match any of the regular expressions in `values`.
    * */
  def fingerprintNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FINGERPRINT.where(P.within(values.to(Set))))



  /** Traverse to literalsToSink property */
  def literalsToSink: Traversal[String] =
    traversal.flatMap(_.literalsToSink)

  


}
