package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Location {
  def apply(graph: Graph, id: Long) = new Location(graph, id)

  val Label = "LOCATION"
  val LabelId: Int = 25

  object PropertyNames {
    val Symbol = "SYMBOL" 
    val MethodFullName = "METHOD_FULL_NAME" 
    val MethodShortName = "METHOD_SHORT_NAME" 
    val PackageName = "PACKAGE_NAME" 
    val LineNumber = "LINE_NUMBER" 
    val ClassName = "CLASS_NAME" 
    val ClassShortName = "CLASS_SHORT_NAME" 
    val NodeLabel = "NODE_LABEL" 
    val Filename = "FILENAME" 
    val Node = "node" 
    val all: Set[String] = Set(Symbol, MethodFullName, MethodShortName, PackageName, LineNumber, ClassName, ClassShortName, NodeLabel, Filename, Node)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Symbol = new PropertyKey[String]("SYMBOL") 
    val MethodFullName = new PropertyKey[String]("METHOD_FULL_NAME") 
    val MethodShortName = new PropertyKey[String]("METHOD_SHORT_NAME") 
    val PackageName = new PropertyKey[String]("PACKAGE_NAME") 
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    val ClassName = new PropertyKey[String]("CLASS_NAME") 
    val ClassShortName = new PropertyKey[String]("CLASS_SHORT_NAME") 
    val NodeLabel = new PropertyKey[String]("NODE_LABEL") 
    val Filename = new PropertyKey[String]("FILENAME") 
    val Node = new PropertyKey[CpgNode]("node") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[LocationDb] {
    override val forLabel = Location.Label
    override val forLabelId = Location.LabelId

    override def createNode(ref: NodeRef[LocationDb]) =
      new LocationDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Location(graph, id)
  }
}

trait LocationBase extends CpgNode  with HasSymbol with HasMethodFullName with HasMethodShortName with HasPackageName with HasLineNumber with HasClassName with HasClassShortName with HasNodeLabel with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: Option[CpgNode]
}

class Location(graph: Graph, id: Long) extends NodeRef[LocationDb](graph, id)
  with LocationBase
  with StoredNode
   {
    override def symbol: String = get().symbol
  override def methodFullName: String = get().methodFullName
  override def methodShortName: String = get().methodShortName
  override def packageName: String = get().packageName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def className: String = get().className
  override def classShortName: String = get().classShortName
  override def nodeLabel: String = get().nodeLabel
  override def filename: String = get().filename
    def node = get().node
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Location.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "classShortName" 
case 8 => "nodeLabel" 
case 9 => "filename" 
case 10 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => classShortName
case 8 => nodeLabel
case 9 => filename
case 10 => node
    }

  override def productPrefix = "Location"
  override def productArity = 11
}

class LocationDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with LocationBase {

  override def layoutInformation: NodeLayoutInformation = Location.layoutInformation

private var _symbol: String = null
def symbol(): String = _symbol

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _methodShortName: String = null
def methodShortName(): String = _methodShortName

private var _packageName: String = null
def packageName(): String = _packageName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _className: String = null
def className(): String = _className

private var _classShortName: String = null
def classShortName(): String = _classShortName

private var _nodeLabel: String = null
def nodeLabel(): String = _nodeLabel

private var _filename: String = null
def filename(): String = _filename

private var _node: Option[CpgNode] = None
def node: Option[CpgNode] = this._node


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (symbol != null) { properties.put("SYMBOL", symbol) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (methodShortName != null) { properties.put("METHOD_SHORT_NAME", methodShortName) }
if (packageName != null) { properties.put("PACKAGE_NAME", packageName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (className != null) { properties.put("CLASS_NAME", className) }
if (classShortName != null) { properties.put("CLASS_SHORT_NAME", classShortName) }
if (nodeLabel != null) { properties.put("NODE_LABEL", nodeLabel) }
if (filename != null) { properties.put("FILENAME", filename) }
   if (this._node.nonEmpty) { properties.put("node", this._node.get) }
  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Location.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "classShortName" 
case 8 => "nodeLabel" 
case 9 => "filename" 
case 10 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => classShortName
case 8 => nodeLabel
case 9 => filename
case 10 => node
    }

  override def productPrefix = "Location"
  override def productArity = 11

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LocationDb]

  override def property(key:String): AnyRef = {
    key match {
      case "SYMBOL" => this._symbol
      case "METHOD_FULL_NAME" => this._methodFullName
      case "METHOD_SHORT_NAME" => this._methodShortName
      case "PACKAGE_NAME" => this._packageName
      case "LINE_NUMBER" => this._lineNumber.orNull
      case "CLASS_NAME" => this._className
      case "CLASS_SHORT_NAME" => this._classShortName
      case "NODE_LABEL" => this._nodeLabel
      case "FILENAME" => this._filename
      case "node" => this._node.orNull
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "SYMBOL" => this._symbol = value.asInstanceOf[String]
      case "METHOD_FULL_NAME" => this._methodFullName = value.asInstanceOf[String]
      case "METHOD_SHORT_NAME" => this._methodShortName = value.asInstanceOf[String]
      case "PACKAGE_NAME" => this._packageName = value.asInstanceOf[String]
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "CLASS_NAME" => this._className = value.asInstanceOf[String]
      case "CLASS_SHORT_NAME" => this._classShortName = value.asInstanceOf[String]
      case "NODE_LABEL" => this._nodeLabel = value.asInstanceOf[String]
      case "FILENAME" => this._filename = value.asInstanceOf[String]
      case "node" => this._node = value match {
        case null | None => None
        case someVal: CpgNode => Some(someVal)
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewLocation]
   this._symbol = other.symbol
   this._methodFullName = other.methodFullName
   this._methodShortName = other.methodShortName
   this._packageName = other.packageName
   this._lineNumber = other.lineNumber
   this._className = other.className
   this._classShortName = other.classShortName
   this._nodeLabel = other.nodeLabel
   this._filename = other.filename
  this._node = other.node match {
    case null | None => None
    case Some(newNode:NewNode) => Some(mapping(newNode).asInstanceOf[CpgNode])
    case Some(oldNode:StoredNode) => Some(oldNode.asInstanceOf[CpgNode])
    case _ => throw new MatchError("unreachable")
  }

}

}

/** Traversal steps for Location */
class LocationTraversal[NodeType <: Location](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to symbol property */
  def symbol: Traversal[String] =
    traversal.map(_.symbol)

    /**
    * Traverse to nodes where the symbol matches the regular expression `value`
    * */
  def symbol(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SYMBOL.where(P.matches(regex)))

  /**
    * Traverse to nodes where the symbol matches at least one of the regular expressions in `values`
    * */
  def symbol(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SYMBOL.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where symbol matches `value` exactly.
    * */
  def symbolExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SYMBOL, value)

  /**
    * Traverse to nodes where symbol matches one of the elements in `values` exactly.
    * */
  def symbolExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SYMBOL.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where symbol does not match the regular expression `value`.
    * */
  def symbolNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SYMBOL.where(P.matches(regex)))

  /**
    * Traverse to nodes where symbol does not match any of the regular expressions in `values`.
    * */
  def symbolNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SYMBOL.where(P.within(values.to(Set))))



  /** Traverse to methodFullName property */
  def methodFullName: Traversal[String] =
    traversal.map(_.methodFullName)

    /**
    * Traverse to nodes where the methodFullName matches the regular expression `value`
    * */
  def methodFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the methodFullName matches at least one of the regular expressions in `values`
    * */
  def methodFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where methodFullName matches `value` exactly.
    * */
  def methodFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME, value)

  /**
    * Traverse to nodes where methodFullName matches one of the elements in `values` exactly.
    * */
  def methodFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where methodFullName does not match the regular expression `value`.
    * */
  def methodFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.METHOD_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where methodFullName does not match any of the regular expressions in `values`.
    * */
  def methodFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.METHOD_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to methodShortName property */
  def methodShortName: Traversal[String] =
    traversal.map(_.methodShortName)

    /**
    * Traverse to nodes where the methodShortName matches the regular expression `value`
    * */
  def methodShortName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_SHORT_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the methodShortName matches at least one of the regular expressions in `values`
    * */
  def methodShortName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_SHORT_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where methodShortName matches `value` exactly.
    * */
  def methodShortNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_SHORT_NAME, value)

  /**
    * Traverse to nodes where methodShortName matches one of the elements in `values` exactly.
    * */
  def methodShortNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_SHORT_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where methodShortName does not match the regular expression `value`.
    * */
  def methodShortNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.METHOD_SHORT_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where methodShortName does not match any of the regular expressions in `values`.
    * */
  def methodShortNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.METHOD_SHORT_NAME.where(P.within(values.to(Set))))



  /** Traverse to packageName property */
  def packageName: Traversal[String] =
    traversal.map(_.packageName)

    /**
    * Traverse to nodes where the packageName matches the regular expression `value`
    * */
  def packageName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.PACKAGE_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the packageName matches at least one of the regular expressions in `values`
    * */
  def packageName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.PACKAGE_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where packageName matches `value` exactly.
    * */
  def packageNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.PACKAGE_NAME, value)

  /**
    * Traverse to nodes where packageName matches one of the elements in `values` exactly.
    * */
  def packageNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.PACKAGE_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where packageName does not match the regular expression `value`.
    * */
  def packageNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.PACKAGE_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where packageName does not match any of the regular expressions in `values`.
    * */
  def packageNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.PACKAGE_NAME.where(P.within(values.to(Set))))



  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

    /**
    * Traverse to nodes where the lineNumber equals the given `value`
    * */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where the lineNumber equals at least one of the given `values`
    * */
  def lineNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the lineNumber is greater than the given `value`
    * */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the lineNumber is greater than or equal the given `value`
    * */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the lineNumber is less than the given `value`
    * */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the lineNumber is less than or equal the given `value`
    * */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where lineNumber is not equal to the given `value`.
    * */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where lineNumber is not equal to any of the given `values`.
    * */
  def lineNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))


  /** Traverse to className property */
  def className: Traversal[String] =
    traversal.map(_.className)

    /**
    * Traverse to nodes where the className matches the regular expression `value`
    * */
  def className(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the className matches at least one of the regular expressions in `values`
    * */
  def className(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where className matches `value` exactly.
    * */
  def classNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_NAME, value)

  /**
    * Traverse to nodes where className matches one of the elements in `values` exactly.
    * */
  def classNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where className does not match the regular expression `value`.
    * */
  def classNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLASS_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where className does not match any of the regular expressions in `values`.
    * */
  def classNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLASS_NAME.where(P.within(values.to(Set))))



  /** Traverse to classShortName property */
  def classShortName: Traversal[String] =
    traversal.map(_.classShortName)

    /**
    * Traverse to nodes where the classShortName matches the regular expression `value`
    * */
  def classShortName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_SHORT_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the classShortName matches at least one of the regular expressions in `values`
    * */
  def classShortName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_SHORT_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where classShortName matches `value` exactly.
    * */
  def classShortNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_SHORT_NAME, value)

  /**
    * Traverse to nodes where classShortName matches one of the elements in `values` exactly.
    * */
  def classShortNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CLASS_SHORT_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where classShortName does not match the regular expression `value`.
    * */
  def classShortNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLASS_SHORT_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where classShortName does not match any of the regular expressions in `values`.
    * */
  def classShortNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CLASS_SHORT_NAME.where(P.within(values.to(Set))))



  /** Traverse to nodeLabel property */
  def nodeLabel: Traversal[String] =
    traversal.map(_.nodeLabel)

    /**
    * Traverse to nodes where the nodeLabel matches the regular expression `value`
    * */
  def nodeLabel(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NODE_LABEL.where(P.matches(regex)))

  /**
    * Traverse to nodes where the nodeLabel matches at least one of the regular expressions in `values`
    * */
  def nodeLabel(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NODE_LABEL.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where nodeLabel matches `value` exactly.
    * */
  def nodeLabelExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NODE_LABEL, value)

  /**
    * Traverse to nodes where nodeLabel matches one of the elements in `values` exactly.
    * */
  def nodeLabelExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NODE_LABEL.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where nodeLabel does not match the regular expression `value`.
    * */
  def nodeLabelNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NODE_LABEL.where(P.matches(regex)))

  /**
    * Traverse to nodes where nodeLabel does not match any of the regular expressions in `values`.
    * */
  def nodeLabelNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NODE_LABEL.where(P.within(values.to(Set))))



  /** Traverse to filename property */
  def filename: Traversal[String] =
    traversal.map(_.filename)

    /**
    * Traverse to nodes where the filename matches the regular expression `value`
    * */
  def filename(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the filename matches at least one of the regular expressions in `values`
    * */
  def filename(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where filename matches `value` exactly.
    * */
  def filenameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME, value)

  /**
    * Traverse to nodes where filename matches one of the elements in `values` exactly.
    * */
  def filenameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where filename does not match the regular expression `value`.
    * */
  def filenameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FILENAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where filename does not match any of the regular expressions in `values`.
    * */
  def filenameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FILENAME.where(P.within(values.to(Set))))




}
