package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object MetaData {
  def apply(graph: Graph, id: Long) = new MetaData(graph, id)

  val Label = "META_DATA"
  val LabelId: Int = 39

  object PropertyNames {
    val Language = "LANGUAGE" 
    val Version = "VERSION" 
    val Overlays = "OVERLAYS" 
    val PolicyDirectories = "POLICY_DIRECTORIES" 
    val Spid = "SPID" 
    val all: Set[String] = Set(Language, Version, Overlays, PolicyDirectories, Spid)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Language = new PropertyKey[String]("LANGUAGE") 
    val Version = new PropertyKey[String]("VERSION") 
    val Overlays = new PropertyKey[Seq[String]]("OVERLAYS") 
    val PolicyDirectories = new PropertyKey[Seq[String]]("POLICY_DIRECTORIES") 
    val Spid = new PropertyKey[String]("SPID") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MetaDataDb] {
    override val forLabel = MetaData.Label
    override val forLabelId = MetaData.LabelId

    override def createNode(ref: NodeRef[MetaDataDb]) =
      new MetaDataDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = MetaData(graph, id)
  }
}

trait MetaDataBase extends CpgNode  with HasLanguage with HasVersion with HasOverlays with HasPolicyDirectories with HasSpid {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MetaData(graph: Graph, id: Long) extends NodeRef[MetaDataDb](graph, id)
  with MetaDataBase
  with StoredNode
   {
    override def language: String = get().language
  override def version: String = get().version
  override def overlays: List[String] = get().overlays
  override def policyDirectories: List[String] = get().policyDirectories
  override def spid: Option[String] = get().spid
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MetaData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "language" 
case 2 => "version" 
case 3 => "overlays" 
case 4 => "policyDirectories" 
case 5 => "spid" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => language
case 2 => version
case 3 => overlays
case 4 => policyDirectories
case 5 => spid
    }

  override def productPrefix = "MetaData"
  override def productArity = 6
}

class MetaDataDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with MetaDataBase {

  override def layoutInformation: NodeLayoutInformation = MetaData.layoutInformation

private var _language: String = null
def language(): String = _language

private var _version: String = null
def version(): String = _version

private var _overlays: List[String] = Nil
def overlays(): List[String] = _overlays

private var _policyDirectories: List[String] = Nil
def policyDirectories(): List[String] = _policyDirectories

private var _spid: Option[String] = None
def spid(): Option[String] = _spid


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (language != null) { properties.put("LANGUAGE", language) }
if (version != null) { properties.put("VERSION", version) }
if (overlays.nonEmpty) { properties.put("OVERLAYS", overlays.asJava) }
if (policyDirectories.nonEmpty) { properties.put("POLICY_DIRECTORIES", policyDirectories.asJava) }
spid.map { value => properties.put("SPID", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MetaData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "language" 
case 2 => "version" 
case 3 => "overlays" 
case 4 => "policyDirectories" 
case 5 => "spid" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => language
case 2 => version
case 3 => overlays
case 4 => policyDirectories
case 5 => spid
    }

  override def productPrefix = "MetaData"
  override def productArity = 6

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MetaDataDb]

  override def property(key:String): AnyRef = {
    key match {
      case "LANGUAGE" => this._language
      case "VERSION" => this._version
      case "OVERLAYS" => this._overlays
      case "POLICY_DIRECTORIES" => this._policyDirectories
      case "SPID" => this._spid.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "LANGUAGE" => this._language = value.asInstanceOf[String]
      case "VERSION" => this._version = value.asInstanceOf[String]
      case "OVERLAYS" => this._overlays = value match {
        case singleValue: String => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[String]]
      }
      case "POLICY_DIRECTORIES" => this._policyDirectories = value match {
        case singleValue: String => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[String]]
      }
      case "SPID" => this._spid = value match {
        case null | None => None
        case someVal: String => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMetaData]
   this._language = other.language
   this._version = other.version
   this._overlays = other.overlays
   this._policyDirectories = other.policyDirectories
   this._spid = other.spid


}

}

/** Traversal steps for MetaData */
class MetaDataTraversal[NodeType <: MetaData](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to language property */
  def language: Traversal[String] =
    traversal.map(_.language)

    /**
    * Traverse to nodes where the language matches the regular expression `value`
    * */
  def language(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.LANGUAGE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the language matches at least one of the regular expressions in `values`
    * */
  def language(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.LANGUAGE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where language matches `value` exactly.
    * */
  def languageExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.LANGUAGE, value)

  /**
    * Traverse to nodes where language matches one of the elements in `values` exactly.
    * */
  def languageExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.LANGUAGE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where language does not match the regular expression `value`.
    * */
  def languageNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LANGUAGE.where(P.matches(regex)))

  /**
    * Traverse to nodes where language does not match any of the regular expressions in `values`.
    * */
  def languageNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LANGUAGE.where(P.within(values.to(Set))))



  /** Traverse to version property */
  def version: Traversal[String] =
    traversal.map(_.version)

    /**
    * Traverse to nodes where the version matches the regular expression `value`
    * */
  def version(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.VERSION.where(P.matches(regex)))

  /**
    * Traverse to nodes where the version matches at least one of the regular expressions in `values`
    * */
  def version(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.VERSION.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where version matches `value` exactly.
    * */
  def versionExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.VERSION, value)

  /**
    * Traverse to nodes where version matches one of the elements in `values` exactly.
    * */
  def versionExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.VERSION.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where version does not match the regular expression `value`.
    * */
  def versionNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.VERSION.where(P.matches(regex)))

  /**
    * Traverse to nodes where version does not match any of the regular expressions in `values`.
    * */
  def versionNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.VERSION.where(P.within(values.to(Set))))



  /** Traverse to overlays property */
  def overlays: Traversal[String] =
    traversal.flatMap(_.overlays)

  

  /** Traverse to policyDirectories property */
  def policyDirectories: Traversal[String] =
    traversal.flatMap(_.policyDirectories)

  

  /** Traverse to spid property */
  def spid: Traversal[String] =
    traversal.flatMap(_.spid)

    /**
    * Traverse to nodes where the spid matches the regular expression `value`
    * */
  def spid(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SPID.where(P.matches(regex)))

  /**
    * Traverse to nodes where the spid matches at least one of the regular expressions in `values`
    * */
  def spid(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SPID.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where spid matches `value` exactly.
    * */
  def spidExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SPID, value)

  /**
    * Traverse to nodes where spid matches one of the elements in `values` exactly.
    * */
  def spidExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SPID.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where spid does not match the regular expression `value`.
    * */
  def spidNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SPID.where(P.matches(regex)))

  /**
    * Traverse to nodes where spid does not match any of the regular expressions in `values`.
    * */
  def spidNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SPID.where(P.within(values.to(Set))))




}
